/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.exchange.LocalExchange;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.util.MergeSortedPages;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class LocalMergeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<LocalExchangeSource> sources;
    private final WorkProcessor<Page> mergedPages;

    public LocalMergeSourceOperator(OperatorContext operatorContext, List<LocalExchangeSource> sources, List<Type> types, PageWithPositionComparator comparator) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sources = Objects.requireNonNull(sources, "sources is null");
        List pageProducers = (List)sources.stream().map(LocalExchangeSource::pages).collect(ImmutableList.toImmutableList());
        this.mergedPages = MergeSortedPages.mergeSortedPages(pageProducers, Objects.requireNonNull(comparator, "comparator is null"), types, operatorContext.aggregateUserMemoryContext(), operatorContext.getDriverContext().getYieldSignal());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.sources.forEach(LocalExchangeSource::finish);
    }

    @Override
    public boolean isFinished() {
        return this.mergedPages.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.mergedPages.isBlocked()) {
            return this.mergedPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.mergedPages.process() || this.mergedPages.isFinished()) {
            return null;
        }
        Page page = this.mergedPages.getResult();
        this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        return page;
    }

    @Override
    public void close() {
        this.sources.forEach(LocalExchangeSource::close);
    }

    public static class LocalMergeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final LocalExchange localExchange;
        private final List<Type> types;
        private final OrderingCompiler orderingCompiler;
        private final List<Integer> sortChannels;
        private final List<SortOrder> orderings;
        private boolean closed;

        public LocalMergeSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, LocalExchange localExchange, List<Type> types, OrderingCompiler orderingCompiler, List<Integer> sortChannels, List<SortOrder> orderings) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.localExchange = Objects.requireNonNull(localExchange, "localExchange is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalMergeSourceOperator.class.getSimpleName());
            PageWithPositionComparator comparator = this.orderingCompiler.compilePageWithPositionComparator(this.types, this.sortChannels, this.orderings);
            List sources = (List)IntStream.range(0, this.localExchange.getBufferCount()).boxed().map(index -> this.localExchange.getNextSource()).collect(ImmutableList.toImmutableList());
            return new LocalMergeSourceOperator(operatorContext, sources, this.types, comparator);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories cannot be duplicated");
        }
    }
}

