/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import io.airlift.stats.TDigest;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;
import io.trino.util.Failures;

public final class TDigestFunctions {
    public static final double DEFAULT_WEIGHT = 1.0;

    private TDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantile(@SqlType(value="tdigest") TDigest input, @SqlType(value="double") double quantile) {
        return input.valueAt(quantile);
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantiles(@SqlType(value="tdigest") TDigest input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        double[] valuesAtPercentiles;
        double[] percentiles = new double[percentilesArrayBlock.getPositionCount()];
        for (int i = 0; i < percentiles.length; ++i) {
            percentiles[i] = DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i);
        }
        Failures.checkCondition(Ordering.natural().isOrdered((Iterable)Doubles.asList((double[])percentiles)), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "percentiles must be sorted in increasing order", new Object[0]);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        double[] dArray = valuesAtPercentiles = input.valuesAt(percentiles);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            DoubleType.DOUBLE.writeDouble(output, value.doubleValue());
        }
        return output.build();
    }

    public static double verifyWeight(double weight) {
        Failures.checkCondition(weight >= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "weight must be >= 1, was %s", weight);
        return weight;
    }
}

