/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import org.joda.time.chrono.ISOChronology;

@Description(value="Truncate to the specified precision in the session timezone")
@ScalarFunction(value="date_trunc")
public final class DateTrunc {
    private DateTrunc() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") long timestamp) {
        timestamp = DateTimes.scaleEpochMicrosToMillis(timestamp);
        long result = DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).roundFloor(timestamp);
        return DateTimes.scaleEpochMillisToMicros(result);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(timestamp.getEpochMicros());
        long result = DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).roundFloor(epochMillis);
        return new LongTimestamp(DateTimes.scaleEpochMillisToMicros(result), 0);
    }
}

