/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.columnar.AndFilterEvaluator;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterEvaluator;
import io.trino.sql.gen.columnar.DictionaryAwareColumnarFilter;
import io.trino.sql.gen.columnar.OrFilterEvaluator;
import io.trino.sql.gen.columnar.PageFilterEvaluator;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.DeterminismEvaluator;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public sealed interface FilterEvaluator
permits AndFilterEvaluator, ColumnarFilterEvaluator, OrFilterEvaluator, PageFilterEvaluator {
    public SelectionResult evaluate(ConnectorSession var1, SelectedPositions var2, Page var3);

    public static Optional<Supplier<FilterEvaluator>> createColumnarFilterEvaluator(boolean columnarFilterEvaluationEnabled, Optional<RowExpression> filter, ColumnarFilterCompiler columnarFilterCompiler) {
        if (columnarFilterEvaluationEnabled && filter.isPresent()) {
            return FilterEvaluator.createColumnarFilterEvaluator(filter.get(), columnarFilterCompiler);
        }
        return Optional.empty();
    }

    public static Optional<Supplier<FilterEvaluator>> createColumnarFilterEvaluator(RowExpression rowExpression, ColumnarFilterCompiler compiler) {
        if (rowExpression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)rowExpression;
            if (FilterEvaluator.isNotExpression(callExpression)) {
                SpecialForm specialFormArg;
                RowExpression rowExpression2 = callExpression.arguments().getFirst();
                if (rowExpression2 instanceof SpecialForm && (specialFormArg = (SpecialForm)rowExpression2).form() == SpecialForm.Form.IS_NULL) {
                    return FilterEvaluator.createIsNotNullExpressionEvaluator(compiler, callExpression);
                }
                return Optional.empty();
            }
            return FilterEvaluator.createCallExpressionEvaluator(compiler, callExpression);
        }
        if (rowExpression instanceof SpecialForm) {
            SpecialForm specialFormArg = (SpecialForm)rowExpression;
            if (specialFormArg.form() == SpecialForm.Form.IS_NULL) {
                return FilterEvaluator.createIsNullExpressionEvaluator(compiler, specialFormArg);
            }
            if (specialFormArg.form() == SpecialForm.Form.AND) {
                return AndFilterEvaluator.createAndExpressionEvaluator(compiler, specialFormArg);
            }
            if (specialFormArg.form() == SpecialForm.Form.OR) {
                return OrFilterEvaluator.createOrExpressionEvaluator(compiler, specialFormArg);
            }
            if (specialFormArg.form() == SpecialForm.Form.BETWEEN) {
                return FilterEvaluator.createBetweenEvaluator(compiler, specialFormArg);
            }
            if (specialFormArg.form() == SpecialForm.Form.IN) {
                return FilterEvaluator.createInExpressionEvaluator(compiler, specialFormArg);
            }
        }
        return Optional.empty();
    }

    public static boolean isNotExpression(CallExpression callExpression) {
        CatalogSchemaFunctionName functionName = callExpression.resolvedFunction().name();
        return GlobalFunctionCatalog.isBuiltinFunctionName(functionName) && functionName.getFunctionName().equals("$not");
    }

    private static Optional<Supplier<FilterEvaluator>> createBetweenEvaluator(ColumnarFilterCompiler compiler, SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.BETWEEN ? 1 : 0) != 0, (Object)"specialForm should be BETWEEN");
        Preconditions.checkArgument((specialForm.arguments().size() == 3 ? 1 : 0) != 0, (String)"BETWEEN should have 3 arguments %s", specialForm.arguments());
        Preconditions.checkArgument((specialForm.functionDependencies().size() == 1 ? 1 : 0) != 0, (String)"BETWEEN should have 1 functional dependency %s", specialForm.functionDependencies());
        ResolvedFunction lessThanOrEqual = specialForm.getOperatorDependency(OperatorType.LESS_THAN_OR_EQUAL);
        RowExpression valueExpression = specialForm.arguments().get(0);
        if (!(valueExpression instanceof InputReferenceExpression)) {
            return Optional.empty();
        }
        if (specialForm.arguments().get(1) instanceof ConstantExpression && specialForm.arguments().get(2) instanceof ConstantExpression) {
            Optional<Supplier<ColumnarFilter>> compiledFilter = compiler.generateFilter(specialForm);
            return compiledFilter.map(filterSupplier -> () -> FilterEvaluator.lambda$createBetweenEvaluator$0((Supplier)filterSupplier));
        }
        return AndFilterEvaluator.createAndExpressionEvaluator(compiler, new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)Expressions.call(lessThanOrEqual, specialForm.arguments().get(1), valueExpression), (Object)Expressions.call(lessThanOrEqual, valueExpression, specialForm.arguments().get(2))), (List<ResolvedFunction>)ImmutableList.of()));
    }

    private static Optional<Supplier<FilterEvaluator>> createInExpressionEvaluator(ColumnarFilterCompiler compiler, SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.IN ? 1 : 0) != 0, (String)"specialForm %s should be IN", (Object)specialForm);
        Optional<Supplier<ColumnarFilter>> compiledFilter = compiler.generateFilter(specialForm);
        return compiledFilter.map(filterSupplier -> () -> FilterEvaluator.lambda$createInExpressionEvaluator$2((Supplier)filterSupplier));
    }

    private static Optional<Supplier<FilterEvaluator>> createCallExpressionEvaluator(ColumnarFilterCompiler compiler, CallExpression callExpression) {
        Optional<Supplier<ColumnarFilter>> compiledFilter = compiler.generateFilter(callExpression);
        boolean isDeterministic = DeterminismEvaluator.isDeterministic(callExpression);
        return compiledFilter.map(filterSupplier -> () -> FilterEvaluator.lambda$createCallExpressionEvaluator$4((Supplier)filterSupplier, isDeterministic));
    }

    private static Optional<Supplier<FilterEvaluator>> createIsNotNullExpressionEvaluator(ColumnarFilterCompiler compiler, CallExpression callExpression) {
        Preconditions.checkArgument((boolean)FilterEvaluator.isNotExpression(callExpression), (String)"callExpression %s should be not", (Object)callExpression);
        Preconditions.checkArgument((callExpression.arguments().size() == 1 ? 1 : 0) != 0);
        SpecialForm specialForm = (SpecialForm)callExpression.arguments().getFirst();
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.IS_NULL ? 1 : 0) != 0, (String)"specialForm %s should be IS_NULL", (Object)specialForm);
        Type argumentType = specialForm.arguments().getFirst().type();
        Preconditions.checkArgument((!argumentType.equals((Object)UnknownType.UNKNOWN) ? 1 : 0) != 0, (String)"argumentType %s should not be UNKNOWN", (Object)argumentType);
        Optional<Supplier<ColumnarFilter>> compiledFilter = compiler.generateFilter(callExpression);
        return compiledFilter.map(filterSupplier -> () -> FilterEvaluator.lambda$createIsNotNullExpressionEvaluator$6((Supplier)filterSupplier));
    }

    private static Optional<Supplier<FilterEvaluator>> createIsNullExpressionEvaluator(ColumnarFilterCompiler compiler, SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.IS_NULL ? 1 : 0) != 0, (String)"specialForm %s should be IS_NULL", (Object)specialForm);
        Type argumentType = specialForm.arguments().getFirst().type();
        Preconditions.checkArgument((!argumentType.equals((Object)UnknownType.UNKNOWN) ? 1 : 0) != 0, (String)"argumentType %s should not be UNKNOWN", (Object)argumentType);
        Optional<Supplier<ColumnarFilter>> compiledFilter = compiler.generateFilter(specialForm);
        return compiledFilter.map(filterSupplier -> () -> FilterEvaluator.lambda$createIsNullExpressionEvaluator$8((Supplier)filterSupplier));
    }

    private static FilterEvaluator createDictionaryAwareEvaluator(ColumnarFilter filter) {
        Preconditions.checkArgument((filter.getInputChannels().size() == 1 ? 1 : 0) != 0, (Object)"filter should have 1 input channel");
        return new ColumnarFilterEvaluator(new DictionaryAwareColumnarFilter(filter));
    }

    private static /* synthetic */ FilterEvaluator lambda$createIsNullExpressionEvaluator$8(Supplier filterSupplier) {
        return FilterEvaluator.createDictionaryAwareEvaluator((ColumnarFilter)filterSupplier.get());
    }

    private static /* synthetic */ FilterEvaluator lambda$createIsNotNullExpressionEvaluator$6(Supplier filterSupplier) {
        return FilterEvaluator.createDictionaryAwareEvaluator((ColumnarFilter)filterSupplier.get());
    }

    private static /* synthetic */ FilterEvaluator lambda$createCallExpressionEvaluator$4(Supplier filterSupplier, boolean isDeterministic) {
        ColumnarFilter filter = (ColumnarFilter)filterSupplier.get();
        return filter.getInputChannels().size() == 1 && isDeterministic ? FilterEvaluator.createDictionaryAwareEvaluator(filter) : new ColumnarFilterEvaluator(filter);
    }

    private static /* synthetic */ FilterEvaluator lambda$createInExpressionEvaluator$2(Supplier filterSupplier) {
        return FilterEvaluator.createDictionaryAwareEvaluator((ColumnarFilter)filterSupplier.get());
    }

    private static /* synthetic */ FilterEvaluator lambda$createBetweenEvaluator$0(Supplier filterSupplier) {
        return FilterEvaluator.createDictionaryAwareEvaluator((ColumnarFilter)filterSupplier.get());
    }

    public record SelectionResult(SelectedPositions selectedPositions, long filterTimeNanos) {
    }
}

