/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.DefaultTraversalVisitor;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Switch;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private NullabilityAnalyzer() {
    }

    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process(expression, result);
        return result.get();
    }

    private static class Visitor
    extends DefaultTraversalVisitor<AtomicBoolean> {
        private Visitor() {
        }

        @Override
        protected Void visitCast(Cast node, AtomicBoolean result) {
            this.process(node.expression(), result);
            return null;
        }

        @Override
        protected Void visitNullIf(NullIf node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitIn(In node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitCase(Case node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitSwitch(Switch node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitFieldReference(FieldReference node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        @Override
        protected Void visitCall(Call node, AtomicBoolean result) {
            if (node.function().functionNullability().isReturnNullable()) {
                result.set(true);
            }
            return null;
        }

        @Override
        protected Void visitConstant(Constant node, AtomicBoolean result) {
            if (node.value() == null) {
                result.set(true);
            }
            return null;
        }
    }
}

