/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Collection;

public final class WindowNodeUtil {
    private WindowNodeUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (parent.getOrderingScheme().isPresent()) {
            if (parent.getOrderingScheme().get().orderBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        }
        if (!parent.getWindowFunctions().values().stream().map(SymbolsExtractor::extractUnique).flatMap(Collection::stream).anyMatch(child.getCreatedSymbols()::contains)) return false;
        return true;
    }
}

