/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MockConnectorTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName tableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<ColumnHandle>> columns;

    public MockConnectorTableHandle(SchemaTableName tableName) {
        this(tableName, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty());
    }

    @JsonCreator
    public MockConnectorTableHandle(@JsonProperty SchemaTableName tableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="columns") Optional<List<ColumnHandle>> columns) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columns = columns.map(ImmutableList::copyOf);
    }

    @JsonProperty
    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<List<ColumnHandle>> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockConnectorTableHandle other = (MockConnectorTableHandle)o;
        return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.constraint, this.columns);
    }

    public String toString() {
        return this.tableName.toString();
    }
}

