/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.execution.StateMachine;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestStateMachine {
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testNullState() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new StateMachine("test", (Executor)this.executor, null)).isInstanceOf(NullPointerException.class)).hasMessage("initialState is null");
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.set(null)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.trySet(null)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.compareAndSet((Object)State.BREAKFAST, null)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.compareAndSet((Object)State.LUNCH, null)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.setIf(null, currentState -> true)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.setIf(null, currentState -> false)).isInstanceOf(NullPointerException.class)).hasMessage("newState is null"));
    }

    @Test
    public void testSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.set((Object)State.BREAKFAST)))))).isEqualTo((Object)State.BREAKFAST));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.set((Object)State.LUNCH)))))).isEqualTo((Object)State.BREAKFAST), State.LUNCH);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.set((Object)State.BREAKFAST)))))).isEqualTo((Object)State.LUNCH), State.BREAKFAST);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.set((Object)State.DINNER)))))).isEqualTo((Object)State.BREAKFAST), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.set((Object)State.LUNCH)).isInstanceOf(IllegalStateException.class)).hasMessage("test cannot transition from DINNER to LUNCH"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.set((Object)State.DINNER));
    }

    @Test
    public void testTrySet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.trySet((Object)State.BREAKFAST)))))).isEqualTo((Object)State.BREAKFAST));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.trySet((Object)State.LUNCH)))))).isEqualTo((Object)State.BREAKFAST), State.LUNCH);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.trySet((Object)State.BREAKFAST)))))).isEqualTo((Object)State.LUNCH), State.BREAKFAST);
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((Comparable)((Object)((State)((Object)((Object)stateMachine.trySet((Object)State.DINNER)))))).isEqualTo((Object)State.BREAKFAST), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.trySet((Object)State.LUNCH));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.trySet((Object)State.DINNER));
    }

    @Test
    public void testCompareAndSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH), State.LUNCH);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.LUNCH));
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.DINNER), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH)).isInstanceOf(IllegalStateException.class)).hasMessage("test cannot transition from DINNER to LUNCH"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.DINNER));
    }

    @Test
    public void testSetIf() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)State.BREAKFAST);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assertions.assertThat((Comparable)((Object)currentState)).isEqualTo((Object)State.BREAKFAST);
            return false;
        })).isFalse());
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assertions.assertThat((Comparable)((Object)currentState)).isEqualTo((Object)State.BREAKFAST);
            return true;
        })).isTrue(), State.LUNCH);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assertions.assertThat((Comparable)((Object)currentState)).isEqualTo((Object)State.LUNCH);
            return false;
        })).isFalse());
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assertions.assertThat((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assertions.assertThat((Comparable)((Object)currentState)).isEqualTo((Object)State.LUNCH);
            return true;
        })).isFalse());
        TestStateMachine.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true), State.DINNER);
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateMachine.setIf((Object)State.LUNCH, currentState -> true)).isInstanceOf(IllegalStateException.class)).hasMessage("test cannot transition from DINNER to LUNCH"));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.LUNCH, currentState -> false));
        TestStateMachine.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true));
    }

    private static void assertStateChange(StateMachine<State> stateMachine, StateChanger stateChange, State expectedState) throws Exception {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture<State> listenerChange = TestStateMachine.addTestListener(stateMachine);
        stateChange.run();
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)expectedState);
        Assertions.assertThat((Comparable)((Object)((State)((Object)futureChange.get(10L, TimeUnit.SECONDS))))).isEqualTo((Object)expectedState);
        Assertions.assertThat((Comparable)((Object)((State)((Object)listenerChange.get(10L, TimeUnit.SECONDS))))).isEqualTo((Object)expectedState);
        boolean isTerminalState = stateMachine.isTerminalState((Object)expectedState);
        if (isTerminalState) {
            Assertions.assertThat((List)stateMachine.getStateChangeListeners()).containsExactlyElementsOf((Iterable)ImmutableSet.of());
        }
    }

    private static void assertNoStateChange(StateMachine<State> stateMachine, StateChanger stateChange) {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture<State> listenerChange = TestStateMachine.addTestListener(stateMachine);
        boolean isTerminalState = stateMachine.isTerminalState((Object)initialState);
        if (isTerminalState) {
            Assertions.assertThat((List)stateMachine.getStateChangeListeners()).containsExactlyElementsOf((Iterable)ImmutableSet.of());
        }
        stateChange.run();
        Assertions.assertThat((Comparable)((Object)((State)((Object)stateMachine.get())))).isEqualTo((Object)initialState);
        Assertions.assertThat((boolean)futureChange.isDone()).isEqualTo(isTerminalState);
        futureChange.cancel(true);
        Assertions.assertThat((boolean)listenerChange.isDone()).isFalse();
        listenerChange.cancel(true);
    }

    private static SettableFuture<State> addTestListener(StateMachine<State> stateMachine) {
        State initialState = (State)((Object)stateMachine.get());
        SettableFuture initialStateNotified = SettableFuture.create();
        SettableFuture stateChanged = SettableFuture.create();
        Thread addingThread = Thread.currentThread();
        stateMachine.addStateChangeListener(newState -> {
            Thread callbackThread = Thread.currentThread();
            if (callbackThread == addingThread) {
                stateChanged.setException((Throwable)((Object)new AssertionError((Object)"Listener was not called back on a different thread")));
                return;
            }
            if (newState == initialState) {
                initialStateNotified.set((Object)true);
            } else {
                stateChanged.set((Object)newState);
            }
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)MoreFutures.tryGetFutureValue((Future)initialStateNotified, (int)10, (TimeUnit)TimeUnit.SECONDS).isPresent()).describedAs("Initial state notification not fired", new Object[0])).isTrue();
        return stateChanged;
    }

    private static enum State {
        BREAKFAST,
        LUNCH,
        DINNER;

    }

    private static interface StateChanger {
        public void run();
    }
}

