/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.FunctionType;
import io.trino.type.JsonPathType;
import io.trino.type.JsonType;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
class TestJsonStringArrayExtractScalar {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction TRANSFORM = FUNCTIONS.resolveFunction("transform", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)JsonType.JSON), new FunctionType(List.of(JsonType.JSON), (Type)VarcharType.VARCHAR)}));
    private static final CatalogSchemaFunctionName JSON_STRING_ARRAY_EXTRACT_SCALAR = FUNCTIONS.getMetadata().resolveBuiltinFunction("$internal$json_string_array_extract_scalar", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, JsonPathType.JSON_PATH})).name();
    private final QueryAssertions assertions = new QueryAssertions();

    TestJsonStringArrayExtractScalar() {
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    void testEmptySliceExtract() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("transform(cast(json_parse(a) as array<json>), x -> json_extract_scalar(\"x\", '$.name'))").binding("a", "''").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array(varchar). Expected a json array, but got null");
    }

    @Test
    void testEmptyStringExtract() {
        this.failedExtract("", "$");
    }

    @Test
    void testObjectStringExtract() {
        this.failedExtract("{}", "$");
    }

    @Test
    void testScalarStringExtract() {
        this.failedExtract("1", "$");
    }

    @Test
    void testEmptyArrayExtract() {
        Assertions.assertThat((Object)this.extract("[]", "$.name").value()).isEqualTo((Object)ImmutableList.of());
    }

    @Test
    void testScalarArrayExtract() {
        Assertions.assertThat((Object)this.extract("[1, \"abc\", 2.2]", "$.name").value()).isEqualTo(Arrays.asList(null, null, null));
        Assertions.assertThat((Object)this.extract("[1, \"abc\", 2.2]", "$").value()).isEqualTo(Arrays.asList("1", "abc", "2.2"));
    }

    @Test
    void testEmptyElementsArrayExtract() {
        Assertions.assertThat((Object)this.extract("[null, [], {}]", "$.name").value()).isEqualTo(Arrays.asList(null, null, null));
    }

    @Test
    void testExtract() {
        Assertions.assertThat((Object)this.extract("[{\"name\": \"a\"}, {\"name\": \"b\"}, [], {}]", "$.name").value()).isEqualTo(Arrays.asList("a", "b", null, null));
    }

    @Test
    void testMixedExtract() {
        Assertions.assertThat((Object)this.extract("[{\"name\": \"a\"}, 1]", "$.name").value()).isEqualTo(Arrays.asList("a", null));
    }

    @Test
    void testComplexExtract() {
        Assertions.assertThat((Object)this.extract("[{\"name\": [1, 2, 3]}, 1]", "$.name").value()).isEqualTo(Arrays.asList(null, null));
        Assertions.assertThat((Object)this.extract("[{\"name\": {}}, 1]", "$.name").value()).isEqualTo(Arrays.asList(null, null));
    }

    private QueryAssertions.ExpressionAssertProvider.Result extract(String json, String jsonPath) {
        QueryAssertions.ExpressionAssertProvider.Result transformationResult = this.extractTransformationResult(json, jsonPath);
        QueryAssertions.ExpressionAssertProvider.Result jsonStringResult = this.extractJsonStringArrayExtractResult(json, jsonPath);
        Assertions.assertThat((Object)transformationResult.value()).isEqualTo(jsonStringResult.value());
        return jsonStringResult;
    }

    private QueryAssertions.ExpressionAssertProvider.Result extractTransformationResult(String json, String jsonPath) {
        QueryAssertions.ExpressionAssertProvider.Result result = this.assertions.expression("transform(cast(json_parse('" + json + "') as array<json>), elem -> json_extract_scalar(\"elem\", '" + jsonPath + "'))").evaluate();
        Assertions.assertThat((boolean)result.expression().isPresent()).isTrue();
        Assertions.assertThat((Object)result.expression().get()).isInstanceOf(Call.class);
        Assertions.assertThat((Object)((Call)result.expression().get()).function()).isEqualTo((Object)TRANSFORM);
        return result;
    }

    private QueryAssertions.ExpressionAssertProvider.Result extractJsonStringArrayExtractResult(String json, String jsonPath) {
        QueryAssertions.ExpressionAssertProvider.Result result = this.assertions.expression("transform(cast(json_parse(json) as array<json>), elem -> json_extract_scalar(\"elem\", '" + jsonPath + "'))").binding("json", "'" + json + "'").evaluate();
        Assertions.assertThat((boolean)result.expression().isPresent()).isTrue();
        Assertions.assertThat((Object)result.expression().get()).isInstanceOf(Call.class);
        Assertions.assertThat((Object)((Call)result.expression().get()).function().name()).isEqualTo((Object)JSON_STRING_ARRAY_EXTRACT_SCALAR);
        return result;
    }

    private void failedExtract(String json, String jsonPath) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.extractTransformationResult(json, jsonPath)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.extractJsonStringArrayExtractResult(json, jsonPath)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array");
    }
}

