/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.scalar.ConstructorWithInvalidTypeParameters;
import io.trino.operator.scalar.ConstructorWithValidTypeParameters;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestScalarValidation {
    @Test
    public void testBogusParametricMethodAnnotation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractParametricScalar(BogusParametricMethodAnnotation.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Parametric class method .* is annotated with @ScalarFunction");
    }

    @Test
    public void testNoParametricMethods() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractParametricScalar(NoParametricMethods.class)).isInstanceOf(TrinoException.class)).hasMessageMatching("Parametric class .* does not have any annotated methods");
    }

    @Test
    public void testMethodMissingReturnAnnotation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(MethodMissingReturnAnnotation.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* is missing @SqlType annotation");
    }

    @Test
    public void testMethodMissingScalarAnnotation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(MethodMissingScalarAnnotation.class)).isInstanceOf(TrinoException.class)).hasMessageMatching("Method .* annotated with @SqlType is missing @ScalarFunction or @ScalarOperator");
    }

    @Test
    public void testPrimitiveWrapperReturnWithoutNullable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(PrimitiveWrapperReturnWithoutNullable.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* has wrapper return type Long but is missing @SqlNullable");
    }

    @Test
    public void testPrimitiveReturnWithNullable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(PrimitiveReturnWithNullable.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* annotated with @SqlNullable has primitive return type long");
    }

    @Test
    public void testPrimitiveWrapperParameterWithoutNullable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(PrimitiveWrapperParameterWithoutNullable.class)).isInstanceOf(TrinoException.class)).hasMessageMatching("A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method .*");
    }

    @Test
    public void testPrimitiveParameterWithNullable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(PrimitiveParameterWithNullable.class)).isInstanceOf(TrinoException.class)).hasMessageMatching("Method .* has parameter with primitive type double annotated with @SqlNullable");
    }

    @Test
    public void testParameterWithoutType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithoutType.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* is missing @SqlType annotation for parameter");
    }

    @Test
    public void testNonPublicAnnnotatedMethod() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(NonPublicAnnnotatedMethod.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* annotated with @ScalarFunction must be public");
    }

    @Test
    public void testMethodWithLegacyNullable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(MethodWithLegacyNullable.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* is annotated with @Nullable but not @SqlNullable");
    }

    @Test
    public void testParameterWithConnectorAndIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithConnectorAndIsNull.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* has @IsNull parameter that does not follow a @SqlType parameter");
    }

    @Test
    public void testParameterWithOnlyIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithOnlyIsNull.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* has @IsNull parameter that does not follow a @SqlType parameter");
    }

    @Test
    public void testParameterWithNonBooleanIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithNonBooleanIsNull.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* has non-boolean parameter with @IsNull");
    }

    @Test
    public void testParameterWithBoxedPrimitiveIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithBoxedPrimitiveIsNull.class)).isInstanceOf(TrinoException.class)).hasMessageMatching("A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method .*");
    }

    @Test
    public void testParameterWithOtherAnnotationsWithIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(ParameterWithOtherAnnotationsWithIsNull.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Method .* has @IsNull parameter that has other annotations");
    }

    @Test
    public void testNonUpperCaseTypeParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(TypeParameterWithNonUpperCaseAnnotation.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Expected type parameter to only contain A-Z and 0-9 \\(starting with A-Z\\), but got bad on method .*");
    }

    @Test
    public void testLeadingNumericTypeParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(TypeParameterWithLeadingNumbers.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Expected type parameter to only contain A-Z and 0-9 \\(starting with A-Z\\), but got 1E on method .*");
    }

    @Test
    public void testNonPrimitiveTypeParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractScalars(TypeParameterWithNonPrimitiveAnnotation.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Expected type parameter not to take parameters, but got 'e' on method .*");
    }

    @Test
    public void testValidTypeParameters() {
        TestScalarValidation.extractScalars(ValidTypeParameter.class);
    }

    @Test
    public void testValidTypeParametersForConstructors() {
        TestScalarValidation.extractParametricScalar(ConstructorWithValidTypeParameters.class);
    }

    @Test
    public void testInvalidTypeParametersForConstructors() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestScalarValidation.extractParametricScalar(ConstructorWithInvalidTypeParameters.class)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Expected type parameter not to take parameters, but got 'k' on method .*");
    }

    private static void extractParametricScalar(Class<?> clazz) {
        InternalFunctionBundle.builder().scalar(clazz);
    }

    private static void extractScalars(Class<?> clazz) {
        InternalFunctionBundle.builder().scalars(clazz);
    }

    public static final class ValidTypeParameter {
        private ValidTypeParameter() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long good1(@TypeParameter(value="ROW(ARRAY(BIGINT),MAP(INTEGER,DECIMAL),SMALLINT,CHAR,BOOLEAN,DATE,TIMESTAMP,VARCHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }

        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="E12"), @TypeParameter(value="F34")})
        public static long good2(@TypeParameter(value="ROW(ARRAY(E12),JSON,TIME,VARBINARY,ROW(ROW(F34)))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithNonPrimitiveAnnotation {
        private TypeParameterWithNonPrimitiveAnnotation() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="E")
        public static long bad(@TypeParameter(value="E(VARCHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithLeadingNumbers {
        private TypeParameterWithLeadingNumbers() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="1E")
        public static long bad(@TypeParameter(value="array(1E)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithNonUpperCaseAnnotation {
        private TypeParameterWithNonUpperCaseAnnotation() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="bad")
        public static long bad(@TypeParameter(value="array(bad)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class ParameterWithOtherAnnotationsWithIsNull {
        private ParameterWithOtherAnnotationsWithIsNull() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") long value, @IsNull @SqlNullable boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithBoxedPrimitiveIsNull {
        private ParameterWithBoxedPrimitiveIsNull() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") Long value, @IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithNonBooleanIsNull {
        private ParameterWithNonBooleanIsNull() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") long value, @IsNull int isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithOnlyIsNull {
        private ParameterWithOnlyIsNull() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithConnectorAndIsNull {
        private ParameterWithConnectorAndIsNull() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(ConnectorSession session, @IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class MethodWithLegacyNullable {
        private MethodWithLegacyNullable() {
        }

        @ScalarFunction
        @Nullable
        @SqlType(value="bigint")
        public static Long bad() {
            return 0L;
        }
    }

    public static final class NonPublicAnnnotatedMethod {
        @ScalarFunction
        @SqlType(value="bigint")
        private static long bad() {
            return 0L;
        }
    }

    public static final class ParameterWithoutType {
        private ParameterWithoutType() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(long missing) {
            return 0L;
        }
    }

    public static final class PrimitiveParameterWithNullable {
        private PrimitiveParameterWithNullable() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlNullable @SqlType(value="double") double primitive) {
            return 0L;
        }
    }

    public static final class PrimitiveWrapperParameterWithoutNullable {
        private PrimitiveWrapperParameterWithoutNullable() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="boolean") Boolean boxed) {
            return 0L;
        }
    }

    public static final class PrimitiveReturnWithNullable {
        private PrimitiveReturnWithNullable() {
        }

        @ScalarFunction
        @SqlNullable
        @SqlType(value="bigint")
        public static long bad() {
            return 0L;
        }
    }

    public static final class PrimitiveWrapperReturnWithoutNullable {
        private PrimitiveWrapperReturnWithoutNullable() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static Long bad() {
            return 0L;
        }
    }

    public static final class MethodMissingScalarAnnotation {
        private MethodMissingScalarAnnotation() {
        }

        @SqlType
        public static void bad() {
        }
    }

    public static final class MethodMissingReturnAnnotation {
        private MethodMissingReturnAnnotation() {
        }

        @ScalarFunction
        public static void bad() {
        }
    }

    @ScalarFunction
    public static final class NoParametricMethods {
    }

    @ScalarFunction
    public static final class BogusParametricMethodAnnotation {
        private BogusParametricMethodAnnotation() {
        }

        @ScalarFunction
        public static void bad() {
        }
    }
}

