/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestUrlFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testUrlExtract() {
        this.validateUrlExtract("http://example.com/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", null, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("http://example.com/path1/p.php?", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com/path1/p.php", "http", "example.com", null, "/path1/p.php", "", "");
        this.validateUrlExtract("http://example.com:8080/path1/p.php?k1=v1&k2=v2#Ref1", "http", "example.com", 8080L, "/path1/p.php", "k1=v1&k2=v2", "Ref1");
        this.validateUrlExtract("https://username@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("https://username:password@example.com", "https", "example.com", null, "", "", "");
        this.validateUrlExtract("mailto:test@example.com", "mailto", "", null, "", "", "");
        this.validateUrlExtract("foo", "", "", null, "foo", "", "");
        this.validateUrlExtract("http://example.com/^", null, null, null, null, null, null);
    }

    @Test
    public void testUrlExtractParameter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k1')")))).hasType((Type)VarcharType.createVarcharType((int)53)).isEqualTo("v1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k2')")))).hasType((Type)VarcharType.createVarcharType((int)53)).isEqualTo("v2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k3')")))).hasType((Type)VarcharType.createVarcharType((int)53)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k4')")))).hasType((Type)VarcharType.createVarcharType((int)53)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k2=v2&k3&k4#Ref1', 'k5')")))).isNull((Type)VarcharType.createVarcharType((int)53));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=v1&k1=v2&k1&k1#Ref1', 'k1')")))).hasType((Type)VarcharType.createVarcharType((int)53)).isEqualTo("v1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1&k1=v1&k1&k1#Ref1', 'k1')")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k=a=b=c&x=y#Ref1', 'k')")))).hasType((Type)VarcharType.createVarcharType((int)47)).isEqualTo("a=b=c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('http://example.com/path1/p.php?k1=a%26k2%3Db&k2=c#Ref1', 'k2')")))).hasType((Type)VarcharType.createVarcharType((int)54)).isEqualTo("c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("url_extract_parameter('foo', 'k1')")))).isNull((Type)VarcharType.createVarcharType((int)3));
    }

    @Test
    public void testUrlEncode() {
        String[][] outputInputPairs;
        for (String[] outputInputPair : outputInputPairs = new String[][]{{"http%3A%2F%2Ftest", "http://test"}, {"http%3A%2F%2Ftest%3Fa%3Db%26c%3Dd", "http://test?a=b&c=d"}, {"http%3A%2F%2F%E3%83%86%E3%82%B9%E3%83%88", "http://\u30c6\u30b9\u30c8"}, {"%7E%40%3A.-*_%2B+%E2%98%83", "~@:.-*_+ \u2603"}, {"test", "test"}}) {
            String input = outputInputPair[1];
            String output = outputInputPair[0];
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_encode", "'" + input + "'")))).hasType((Type)VarcharType.createVarcharType((int)(input.length() * 12))).isEqualTo(output);
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_encode", "'\ud867\ude3d'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("%F0%A9%B8%BD");
    }

    @Test
    public void testUrlDecode() {
        String[][] inputOutputPairs;
        for (String[] inputOutputPair : inputOutputPairs = new String[][]{{"http%3A%2F%2Ftest", "http://test"}, {"http%3A%2F%2Ftest%3Fa%3Db%26c%3Dd", "http://test?a=b&c=d"}, {"http%3A%2F%2F%E3%83%86%E3%82%B9%E3%83%88", "http://\u30c6\u30b9\u30c8"}, {"%7E%40%3A.-*_%2B+%E2%98%83", "~@:.-*_+ \u2603"}, {"test", "test"}}) {
            String input = inputOutputPair[0];
            String output = inputOutputPair[1];
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_decode", "'" + input + "'")))).hasType((Type)VarcharType.createVarcharType((int)input.length())).isEqualTo(output);
        }
    }

    private void validateUrlExtract(String url, String protocol, String host, Long port, String path, String query, String fragment) {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_protocol", "'" + url + "'")))).hasType((Type)VarcharType.createVarcharType((int)url.length())).isEqualTo(protocol);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_host", "'" + url + "'")))).hasType((Type)VarcharType.createVarcharType((int)url.length())).isEqualTo(host);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_port", "'" + url + "'")))).hasType((Type)BigintType.BIGINT).isEqualTo(port);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_path", "'" + url + "'")))).hasType((Type)VarcharType.createVarcharType((int)url.length())).isEqualTo(path);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_query", "'" + url + "'")))).hasType((Type)VarcharType.createVarcharType((int)url.length())).isEqualTo(query);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("url_extract_fragment", "'" + url + "'")))).hasType((Type)VarcharType.createVarcharType((int)url.length())).isEqualTo(fragment);
    }
}

