/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SpecializeCastWithJsonParse;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecializeCastWithJsonParse {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution(InMemoryTransactionManager.createTestTransactionManager(), TestingPlannerContext.PLANNER_CONTEXT);
    private static final ResolvedFunction JSON_PARSE = FUNCTIONS.resolveFunction("json_parse", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));

    @Test
    void testArray() {
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Call(JSON_PARSE, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x"))), (Type)new ArrayType((Type)BigintType.BIGINT)))).isEqualTo(Optional.of(new Call(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().getCoercion(GlobalFunctionCatalog.builtinFunctionName((String)"$internal$json_string_to_array_cast"), (Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x")))));
    }

    @Test
    void testMap() {
        TypeOperators typeOperators = new TypeOperators();
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Call(JSON_PARSE, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x"))), (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, typeOperators)))).isEqualTo(Optional.of(new Call(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().getCoercion(GlobalFunctionCatalog.builtinFunctionName((String)"$internal$json_string_to_map_cast"), (Type)VarcharType.VARCHAR, (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, typeOperators)), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x")))));
    }

    @Test
    void testRow() {
        Assertions.assertThat(this.optimize((Expression)new Cast((Expression)new Call(JSON_PARSE, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x"))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})))).isEqualTo(Optional.of(new Call(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().getCoercion(GlobalFunctionCatalog.builtinFunctionName((String)"$internal$json_string_to_row_cast"), (Type)VarcharType.VARCHAR, (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x")))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SpecializeCastWithJsonParse(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

