/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSymbolSerializer {
    private static final JsonCodecFactory CODEC_FACTORY;
    private static final JsonCodec<Symbol> SYMBOL_CODEC;
    private static final JsonCodec<Map<Symbol, String>> MAP_CODEC;

    TestSymbolSerializer() {
    }

    @Test
    void testAsValue() {
        Assertions.assertThat((Object)((Symbol)SYMBOL_CODEC.fromJson(SYMBOL_CODEC.toJson((Object)new Symbol((Type)BigintType.BIGINT, "abc123!@# :/{}[]*"))))).isEqualTo((Object)new Symbol((Type)BigintType.BIGINT, "abc123!@# :/{}[]*"));
        Assertions.assertThat((Object)((Symbol)SYMBOL_CODEC.fromJson(SYMBOL_CODEC.toJson((Object)new Symbol((Type)BigintType.BIGINT, "abc::def"))))).isEqualTo((Object)new Symbol((Type)BigintType.BIGINT, "abc::def"));
        Assertions.assertThat((Object)((Symbol)SYMBOL_CODEC.fromJson(SYMBOL_CODEC.toJson((Object)new Symbol((Type)BigintType.BIGINT, "a:"))))).isEqualTo((Object)new Symbol((Type)BigintType.BIGINT, "a:"));
        Assertions.assertThat((Object)((Symbol)SYMBOL_CODEC.fromJson(SYMBOL_CODEC.toJson((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc", (Type)BigintType.BIGINT)}), "a:"))))).isEqualTo((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc", (Type)BigintType.BIGINT)}), "a:"));
        Assertions.assertThat((Object)((Symbol)SYMBOL_CODEC.fromJson(SYMBOL_CODEC.toJson((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc::123", (Type)BigintType.BIGINT)}), "a:"))))).isEqualTo((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc::123", (Type)BigintType.BIGINT)}), "a:"));
    }

    @Test
    void testAsKey() {
        Assertions.assertThat((Map)((Map)MAP_CODEC.fromJson(MAP_CODEC.toJson((Object)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "abc123!@# :/{}[]*"), (Object)""))))).isEqualTo((Object)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "abc123!@# :/{}[]*"), (Object)""));
        Assertions.assertThat((Map)((Map)MAP_CODEC.fromJson(MAP_CODEC.toJson((Object)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "a:"), (Object)""))))).isEqualTo((Object)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "a:"), (Object)""));
        Assertions.assertThat((Map)((Map)MAP_CODEC.fromJson(MAP_CODEC.toJson((Object)ImmutableMap.of((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc::123", (Type)BigintType.BIGINT)}), "a:"), (Object)""))))).isEqualTo((Object)ImmutableMap.of((Object)new Symbol((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"abc::123", (Type)BigintType.BIGINT)}), "a:"), (Object)""));
    }

    static {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.builder().put(Symbol.class, (Object)new SymbolKeyDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)).buildOrThrow());
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        CODEC_FACTORY = new JsonCodecFactory((Provider)provider);
        SYMBOL_CODEC = CODEC_FACTORY.jsonCodec(Symbol.class);
        MAP_CODEC = CODEC_FACTORY.jsonCodec((TypeToken)new TypeToken<Map<Symbol, String>>(){});
    }
}

