/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Objects;

final class NotPlanNodeMatcher
implements Matcher {
    private final Class<? extends PlanNode> excludedNodeClass;

    NotPlanNodeMatcher(Class<? extends PlanNode> excludedNodeClass) {
        this.excludedNodeClass = Objects.requireNonNull(excludedNodeClass, "excludedNodeClass is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return !node.getClass().equals(this.excludedNodeClass);
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("excludedNodeClass", this.excludedNodeClass).toString();
    }
}

