/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TableFunctionProcessorMatcher
implements Matcher {
    private final String name;
    private final List<String> properOutputs;
    private final List<List<String>> passThroughSymbols;
    private final List<List<String>> requiredSymbols;
    private final Optional<Map<String, String>> markerSymbols;
    private final Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification;
    private final Optional<String> hashSymbol;

    private TableFunctionProcessorMatcher(String name, List<String> properOutputs, List<List<String>> passThroughSymbols, List<List<String>> requiredSymbols, Optional<Map<String, String>> markerSymbols, Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification, Optional<String> hashSymbol) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.passThroughSymbols = (List)passThroughSymbols.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.requiredSymbols = (List)requiredSymbols.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.markerSymbols = markerSymbols.map(ImmutableMap::copyOf);
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableFunctionProcessorNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Map actualMapping;
        Map expectedMapping;
        List actualRequired;
        List actualPassThrough;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableFunctionProcessorNode tableFunctionProcessorNode = (TableFunctionProcessorNode)node;
        if (!this.name.equals(tableFunctionProcessorNode.getName())) {
            return MatchResult.NO_MATCH;
        }
        if (this.properOutputs.size() != tableFunctionProcessorNode.getProperOutputs().size()) {
            return MatchResult.NO_MATCH;
        }
        List expectedPassThrough = (List)this.passThroughSymbols.stream().map(list -> (ImmutableList)list.stream().map(symbolAliases::get).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        if (!expectedPassThrough.equals(actualPassThrough = (List)tableFunctionProcessorNode.getPassThroughSpecifications().stream().map(TableFunctionNode.PassThroughSpecification::columns).map(list -> (ImmutableList)list.stream().map(TableFunctionNode.PassThroughColumn::symbol).map(Symbol::toSymbolReference).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList()))) {
            return MatchResult.NO_MATCH;
        }
        List expectedRequired = (List)this.requiredSymbols.stream().map(list -> (ImmutableList)list.stream().map(symbolAliases::get).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        if (!expectedRequired.equals(actualRequired = (List)tableFunctionProcessorNode.getRequiredSymbols().stream().map(list -> (ImmutableList)list.stream().map(Symbol::toSymbolReference).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList()))) {
            return MatchResult.NO_MATCH;
        }
        if (this.markerSymbols.isPresent() != tableFunctionProcessorNode.getMarkerSymbols().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (this.markerSymbols.isPresent() && !(expectedMapping = (Map)this.markerSymbols.get().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> symbolAliases.get((String)entry.getKey()), entry -> symbolAliases.get((String)entry.getValue())))).equals(actualMapping = (Map)((Map)tableFunctionProcessorNode.getMarkerSymbols().orElseThrow()).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).toSymbolReference(), entry -> ((Symbol)entry.getValue()).toSymbolReference())))) {
            return MatchResult.NO_MATCH;
        }
        if (this.specification.isPresent() != tableFunctionProcessorNode.getSpecification().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (this.specification.isPresent() && !this.specification.get().getExpectedValue(symbolAliases).equals(tableFunctionProcessorNode.getSpecification().orElseThrow())) {
            return MatchResult.NO_MATCH;
        }
        if (this.hashSymbol.isPresent()) {
            if (!this.hashSymbol.map(symbolAliases::get).equals(tableFunctionProcessorNode.getHashSymbol().map(Symbol::toSymbolReference))) {
                return MatchResult.NO_MATCH;
            }
        }
        ImmutableMap.Builder properOutputsMapping = ImmutableMap.builder();
        for (int i = 0; i < this.properOutputs.size(); ++i) {
            properOutputsMapping.put((Object)this.properOutputs.get(i), (Object)((Symbol)tableFunctionProcessorNode.getProperOutputs().get(i)).toSymbolReference());
        }
        return MatchResult.match(SymbolAliases.builder().putAll(symbolAliases).putAll((Map<String, Reference>)properOutputsMapping.buildOrThrow()).build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("properOutputs", this.properOutputs).add("passThroughSymbols", this.passThroughSymbols).add("requiredSymbols", this.requiredSymbols).add("markerSymbols", this.markerSymbols).add("specification", this.specification).add("hashSymbol", this.hashSymbol).toString();
    }

    public static class Builder {
        private final Optional<PlanMatchPattern> source;
        private String name;
        private List<String> properOutputs = ImmutableList.of();
        private List<List<String>> passThroughSymbols = ImmutableList.of();
        private List<List<String>> requiredSymbols = ImmutableList.of();
        private Optional<Map<String, String>> markerSymbols = Optional.empty();
        private Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification = Optional.empty();
        private Optional<String> hashSymbol = Optional.empty();

        public Builder() {
            this.source = Optional.empty();
        }

        public Builder(PlanMatchPattern source) {
            this.source = Optional.of(source);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder properOutputs(List<String> properOutputs) {
            this.properOutputs = properOutputs;
            return this;
        }

        public Builder passThroughSymbols(List<List<String>> passThroughSymbols) {
            this.passThroughSymbols = passThroughSymbols;
            return this;
        }

        public Builder requiredSymbols(List<List<String>> requiredSymbols) {
            this.requiredSymbols = requiredSymbols;
            return this;
        }

        public Builder markerSymbols(Map<String, String> markerSymbols) {
            this.markerSymbols = Optional.of(markerSymbols);
            return this;
        }

        public Builder specification(ExpectedValueProvider<DataOrganizationSpecification> specification) {
            this.specification = Optional.of(specification);
            return this;
        }

        public Builder hashSymbol(String hashSymbol) {
            this.hashSymbol = Optional.of(hashSymbol);
            return this;
        }

        /*
         * Exception decompiling
         */
        public PlanMatchPattern build() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

