/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughUnion;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushProjectionThroughUnion
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final RowType ROW_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushProjectionThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testTrivialProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> {
            Symbol left = p.symbol("left");
            Symbol right = p.symbol("right");
            Symbol unioned = p.symbol("unioned");
            Symbol renamed = p.symbol("renamed");
            return p.project(Assignments.of((Symbol)renamed, (Expression)unioned.toSymbolReference()), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)unioned, (Object)left).put((Object)unioned, (Object)right).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(left), (Object)p.values(right))));
        }).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughUnion()).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            Symbol c = p.symbol("c", (Type)BigintType.BIGINT);
            Symbol d = p.symbol("d", (Type)ROW_TYPE);
            Symbol cTimes3 = p.symbol("c_times_3", (Type)BigintType.BIGINT);
            Symbol dX = p.symbol("d_x", (Type)BigintType.BIGINT);
            Symbol z = p.symbol("z", (Type)ROW_TYPE);
            Symbol w = p.symbol("w", (Type)ROW_TYPE);
            return p.project(Assignments.of((Symbol)cTimes3, (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)c.toSymbolReference(), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L))), (Symbol)dX, (Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "d"), 0)), (PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).put((Object)d, (Object)z).put((Object)d, (Object)w).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(a, z), (Object)p.values(b, w))));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_times_3", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L)))), (Object)"z_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "z"), 0))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"z"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b_times_3", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L)))), (Object)"w_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)ROW_TYPE, "w"), 0))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b", (Object)"w")))).withNumberOfOutputColumns(2).withAlias("a_times_3").withAlias("b_times_3").withAlias("z_x").withAlias("w_x"));
    }
}

