/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushTopNThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestPushTopNThroughOuterJoin
extends BaseRuleTest {
    public TestPushTopNThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushTopNThroughLeftJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("leftKey", "rightKey").left(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("leftKey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("leftKey"))).right(PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testPushTopNThroughRightJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.join(JoinType.RIGHT, builder -> builder.equiCriteria("leftKey", "rightKey").left(PlanMatchPattern.values("leftKey")).right(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("rightKey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("rightKey")))));
    }

    @Test
    public void testFullJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushTopNWhenSymbolsFromBothSources() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey, (Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenAlreadyLimited() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinType.LEFT, (PlanNode)p.limit(1L, (PlanNode)p.values(5, leftKey)), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenStepNotPartial() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.FINAL, (PlanNode)p.join(JoinType.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }
}

