/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestListagg {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testListaggQueryWithOneValue() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a') t(value)"))).matches("VALUES (VARCHAR 'a')");
    }

    @Test
    public void testListaggQueryWithOneValueGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES (1, 'a')) t(id, value) GROUP BY id ORDER BY id "))).matches("VALUES (1, VARCHAR 'a')");
    }

    @Test
    public void testListaggQueryWithMultipleValues() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) "))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithImplicitSeparator() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'b', 'c') t(value) "))).matches("VALUES (VARCHAR 'abc')");
    }

    @Test
    public void testListaggQueryWithImplicitSeparatorGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES          (1, 'c'),          (2, 'b'),          (1, 'a'),         (2, 'd')     )  t(id, value) GROUP BY id ORDER BY id "))).matches("VALUES         (1, VARCHAR 'ac'),        (2, VARCHAR 'bd')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesOrderedDescending() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value DESC) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) "))).matches("VALUES (VARCHAR 'dddd,ccc,bb,a')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesMultipleSortItems() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY sortitem1, sortitem2) FROM (VALUES (2, 'C', 'ccc'), (2, 'B', 'bb'), (3, 'D', 'dddd'), (1, 'A', 'a')) t(sortitem1, sortitem2, value) "))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesMultipleSortItemsGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY weight, label) FROM (VALUES (1, 200, 'C', 'ccc'), (1, 200, 'B', 'bb'), (2, 300, 'D', 'dddd'), (1, 100, 'A', 'a')) t(id, weight, label, value) GROUP BY id ORDER BY id "))).matches("VALUES (1, VARCHAR 'a,bb,ccc'),        (2, VARCHAR 'dddd')");
    }

    @Test
    public void testListaggQueryWithFunctionExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(upper(value), ' ') WITHIN GROUP (ORDER BY value) FROM (VALUES 'Trino', 'SQL', 'everything') t(value) "))).matches("VALUES (VARCHAR 'SQL TRINO EVERYTHING')");
    }

    @Test
    public void testListaggQueryWithNullValues() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', NULL, 'bb', NULL, 'ccc', NULL, 'dddd', NULL) t(value) "))).matches("VALUES (VARCHAR 'a,bb,ccc,dddd')");
    }

    @Test
    public void testListaggQueryWithNullValuesGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, listagg(value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES              (1, 'a'),              (2, NULL),              (3, 'bb'),              (1, NULL),              (1, 'ccc'),              (2, NULL),              (3, 'dddd'),              (2, NULL)     ) t(id, value) GROUP BY id ORDER BY id "))).matches("VALUES (1, VARCHAR 'a,ccc'),        (2, NULL),        (3, VARCHAR 'bb,dddd')");
    }

    @Test
    public void testListaggQueryIncorrectSyntax() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(v, ',') FROM (VALUES 'a') t(v)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:24: mismatched input 'FROM'. Expecting: 'WITHIN'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(v) FROM (VALUES 'a') t(v)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:19: mismatched input 'FROM'. Expecting: 'WITHIN'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(v, ',', '...') WITHIN GROUP (ORDER BY v)FROM (VALUES 'a') t(v)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:22: mismatched input ','. Expecting: ')', 'ON'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(v, ',') WITHIN GROUP (ORDER BY v) OVER (PARTITION BY id)FROM (VALUES (1, 'a')) t(id, v)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:55: mismatched input '('. Expecting: ',', 'EXCEPT', 'FETCH', 'FROM', 'GROUP', 'HAVING', 'INTERSECT', 'LIMIT', 'OFFSET', 'ORDER', 'UNION', 'WHERE', 'WINDOW', <EOF>");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(v, ',' ON OVERFLOW COLLAPSE) WITHIN GROUP (ORDER BY v)FROM (VALUES 'a') t(v)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:35: mismatched input 'COLLAPSE'. Expecting: 'ERROR', 'TRUNCATE'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(v, 123) WITHIN GROUP (ORDER BY v) FROM (VALUES 'Trino', 'SQL', 'everything') t(v) "))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:19: mismatched input '123'. Expecting: <string>");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(v, ',' ON OVERFLOW TRUNCATE 1234567890 WITHOUT COUNT) WITHIN GROUP (ORDER BY v) FROM (VALUES 'Trino', 'SQL', 'everything') t(v) "))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:44: mismatched input '1234567890'. Expecting: 'WITH', 'WITHOUT', <string>");
    }

    @Test
    public void testListaggQueryIncorrectExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES 1, NULL, 2, 3, 4) t(value)"))).failure().hasMessage("line 1:8: Expected expression of varchar, but 'value' has integer type");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES TRUE, NULL, FALSE, FALSE, TRUE) t(value)"))).failure().hasMessage("line 1:8: Expected expression of varchar, but 'value' has boolean type");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY value)FROM (VALUES array['abc', 'def'], array['sql']) t(value)"))).failure().hasMessage("line 1:8: Expected expression of varchar, but 'value' has array(varchar(3)) type");
    }

    @Test
    public void testListaaggQueryIncorrectOrderByExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(label, ',') WITHIN GROUP (ORDER BY rgb) FROM (VALUES ('red', rgb(255, 0, 0)), ('green', rgb(0, 128, 0)), ('blue', rgb(0, 0, 255))) color(label, rgb) "))).failure().hasMessage("line 1:8: ORDER BY can only be applied to orderable types (actual: color)");
    }

    @Test
    public void testListaggQueryWithExplicitlyCastedNumericValues() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(try_cast(value as varchar), ',') WITHIN GROUP (ORDER BY value)FROM (VALUES 1, NULL, 2, 3, 4) t(value)"))).matches("VALUES (VARCHAR '1,2,3,4')");
    }

    @Test
    public void testListaggQueryWithDistinct() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg( DISTINCT value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES  'a', 'b', 'a', 'b', 'c', 'd', 'd', 'a', 'd', 'b', 'd') t(value)"))).matches("VALUES (VARCHAR 'a,b,c,d')");
    }

    @Test
    public void testListaggQueryWithDistinctGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, listagg( DISTINCT value, ',') WITHIN GROUP (ORDER BY value) FROM (VALUES            (1, 'a'),           (1, 'b'),           (1, 'a'),           (2, 'b'),           (1, 'c'),           (1, 'd'),           (2, 'd'),           (1, 'a'),           (2, 'd'),           (2, 'b'),           (1, 'd')    ) t(id, value) GROUP BY id ORDER BY id "))).matches("VALUES (1, VARCHAR 'a,b,c,d'),        (2, VARCHAR 'b,d')");
    }

    @Test
    public void testListaggQueryWithMultipleValuesWithDefaultSeparator() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value) WITHIN GROUP (ORDER BY value) FROM (VALUES 'a', 'bb', 'ccc', 'dddd') t(value) "))).matches("VALUES (VARCHAR 'abbcccdddd')");
    }

    @Test
    public void testListaggQueryWithOrderingAndGrouping() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, LISTAGG(value, ',') WITHIN GROUP (ORDER BY value)           FROM (VALUES                    (1, 'a'),                    (1, 'b'),                    (2, 'd'),                    (2, 'c')                ) t(id, value)          GROUP BY id          ORDER BY id"))).matches("VALUES          (1, VARCHAR 'a,b'),     (2, VARCHAR 'c,d')");
    }

    @Test
    public void testListaggQueryOverflowError() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(value, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY value) FROM (VALUES lpad('a', 1048576, 'a'),'Trino') t(value) "))).failure().hasMessage("Concatenated string has the length in bytes larger than the maximum output length 1048576")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT});
    }

    @Test
    public void testListaggQueryOverflowErrorGrouping() {
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, LISTAGG(value, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY value) FROM (VALUES            (1, lpad('a', 1048576, 'a')),           (1, 'Trino'),           (2, 'SQL')     ) t(id, value) GROUP BY id ORDER BY id "))).failure().hasMessage("Concatenated string has the length in bytes larger than the maximum output length 1048576")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT});
    }

    @Test
    public void testListaggQueryOverflowTruncateWithoutCountAndWithoutOverflowFiller() {
        int size = 1048566;
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT LISTAGG(value, ',' ON OVERFLOW TRUNCATE WITHOUT COUNT) WITHIN GROUP (ORDER BY value) FROM (VALUES lpad('', " + size + ", 'a'), 'trino', 'rocks') t(value) "))).matches("VALUES (lpad('', " + size + ", 'a') || ',rocks,...')");
    }

    @Test
    public void testListaggQueryOverflowTruncateWithCountAndWithOverflowFiller() {
        int size = 1048564;
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT substring(LISTAGG(value, ',' ON OVERFLOW TRUNCATE '.....' WITH COUNT) WITHIN GROUP (ORDER BY value), -30) FROM (VALUES lpad('', " + size + ", 'a'), 'trino', 'sql', 'everything') t(value) "))).skippingTypesCheck().matches("VALUES ('aaaaaaaaaa,everything,.....(2)')");
    }

    @Test
    public void testListaggQueryGroupingOverflowTruncateWithCountAndWithOverflowFiller() {
        int size = 1048564;
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT id, substring(LISTAGG(value, ',' ON OVERFLOW TRUNCATE '.....' WITH COUNT) WITHIN GROUP (ORDER BY value), if(id = 1, -30, 1)) FROM (VALUES              (1, lpad('', " + size + ", 'a')),              (1, 'trino'),              (1, 'sql'),              (1, 'everything'),              (2, 'listagg'),              (2, 'string joiner')      ) t(id, value) GROUP BY id ORDER BY id "))).matches("VALUES    (1, VARCHAR 'aaaaaaaaaa,everything,.....(2)'),   (2, VARCHAR 'listagg,string joiner')");
    }

    @Test
    void testFilter() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT listagg(value, ',') WITHIN GROUP (ORDER BY id) FILTER (WHERE id % 2 = 0)\nFROM (\n     VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')\n) t(id, value)\n"))).matches("VALUES VARCHAR 'b,d'");
    }
}

