/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDecimalToDecimalCasts {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testShortDecimalToShortDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1, 0))").binding("a", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 2))").binding("a", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1, 0))").binding("a", "DECIMAL '2'")))).isEqualTo(SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1, 0))").binding("a", "DECIMAL '-2'")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '2.0'")))).isEqualTo(SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '-2.0'")))).isEqualTo(SqlDecimal.decimal((String)"-2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "DECIMAL '2.0'")))).isEqualTo(SqlDecimal.decimal((String)"02", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "DECIMAL '-2.0'")))).isEqualTo(SqlDecimal.decimal((String)"-02", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 2))").binding("a", "DECIMAL '2.0'")))).isEqualTo(SqlDecimal.decimal((String)"2.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 2))").binding("a", "DECIMAL '-2.0'")))).isEqualTo(SqlDecimal.decimal((String)"-2.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '1.449'")))).isEqualTo(SqlDecimal.decimal((String)"1.4", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '1.459'")))).isEqualTo(SqlDecimal.decimal((String)"1.5", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '-1.449'")))).isEqualTo(SqlDecimal.decimal((String)"-1.4", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 1))").binding("a", "DECIMAL '-1.459'")))).isEqualTo(SqlDecimal.decimal((String)"-1.5", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "DECIMAL '12345.6'").evaluate()).hasMessage("Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "DECIMAL '-12345.6'").evaluate()).hasMessage("Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "DECIMAL '12345.6'").evaluate()).hasMessage("Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "DECIMAL '-12345.6'").evaluate()).hasMessage("Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testShortDecimalToLongDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '1.2345'")))).isEqualTo(SqlDecimal.decimal((String)"1.23450000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '-1.2345'")))).isEqualTo(SqlDecimal.decimal((String)"-1.23450000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
    }

    @Test
    public void testLongDecimalToShortDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5, 4))").binding("a", "DECIMAL '1.23450000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.2345", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5, 4))").binding("a", "DECIMAL '-1.23450000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-1.2345", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)));
    }

    @Test
    public void testLongDecimalToLongDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(22, 20))").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"00.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(23, 20))").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"000.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 19))").binding("a", "DECIMAL '2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"2.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 19))").binding("a", "DECIMAL '-2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-2.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"2.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '-2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-2.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(22, 20))").binding("a", "DECIMAL '2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"02.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(22, 20))").binding("a", "DECIMAL '-2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-02.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(22, 21))").binding("a", "DECIMAL '2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"2.000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(22, 21))").binding("a", "DECIMAL '-2.00000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-2.000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '1.000000000000000000004'")))).isEqualTo(SqlDecimal.decimal((String)"1.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '1.000000000000000000005'")))).isEqualTo(SqlDecimal.decimal((String)"1.00000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '-1.000000000000000000004'")))).isEqualTo(SqlDecimal.decimal((String)"-1.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(21, 20))").binding("a", "DECIMAL '-1.000000000000000000005'")))).isEqualTo(SqlDecimal.decimal((String)"-1.00000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DECIMAL '1234500000000000000000000.6'").evaluate()).hasMessage("Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(20, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DECIMAL '-1234500000000000000000000.6'").evaluate()).hasMessage("Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(20, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(22,2))").binding("a", "DECIMAL '1234500000000000000000000.6'").evaluate()).hasMessage("Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(22, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(22,2))").binding("a", "DECIMAL '-1234500000000000000000000.6'").evaluate()).hasMessage("Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(22, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }
}

