/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.connector.CatalogPruneTask;
import io.trino.connector.CatalogPruneTaskConfig;
import io.trino.connector.CatalogStoreConfig;
import io.trino.connector.CatalogStoreManager;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.CoordinatorDynamicCatalogManager;
import io.trino.connector.DefaultCatalogFactory;
import io.trino.connector.FileCatalogStore;
import io.trino.connector.FileCatalogStoreConfig;
import io.trino.connector.InMemoryCatalogStore;
import io.trino.connector.LazyCatalogFactory;
import io.trino.connector.WorkerDynamicCatalogManager;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.CatalogManager;
import io.trino.server.ServerConfig;
import io.trino.spi.catalog.CatalogStore;
import java.util.Locale;

public class DynamicCatalogManagerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        if (((ServerConfig)this.buildConfigObject(ServerConfig.class)).isCoordinator()) {
            binder.bind(CoordinatorDynamicCatalogManager.class).in(Scopes.SINGLETON);
            CatalogStoreConfig config = (CatalogStoreConfig)this.buildConfigObject(CatalogStoreConfig.class);
            switch (config.getCatalogStoreKind().toLowerCase(Locale.ROOT)) {
                case "memory": {
                    binder.bind(CatalogStore.class).to(InMemoryCatalogStore.class).in(Scopes.SINGLETON);
                    break;
                }
                case "file": {
                    ConfigBinder.configBinder((Binder)binder).bindConfig(FileCatalogStoreConfig.class);
                    binder.bind(CatalogStore.class).to(FileCatalogStore.class).in(Scopes.SINGLETON);
                    break;
                }
                default: {
                    binder.bind(CatalogStoreManager.class).in(Scopes.SINGLETON);
                    OptionalBinder.newOptionalBinder((Binder)binder, CatalogStoreManager.class).setBinding().to(CatalogStoreManager.class).in(Scopes.SINGLETON);
                    binder.bind(CatalogStore.class).to(CatalogStoreManager.class).in(Scopes.SINGLETON);
                }
            }
            binder.bind(ConnectorServicesProvider.class).to(CoordinatorDynamicCatalogManager.class).in(Scopes.SINGLETON);
            binder.bind(CatalogManager.class).to(CoordinatorDynamicCatalogManager.class).in(Scopes.SINGLETON);
            binder.bind(CoordinatorLazyRegister.class).asEagerSingleton();
            ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogPruneTaskConfig.class);
            binder.bind(CatalogPruneTask.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(WorkerDynamicCatalogManager.class).in(Scopes.SINGLETON);
            binder.bind(ConnectorServicesProvider.class).to(WorkerDynamicCatalogManager.class).in(Scopes.SINGLETON);
            binder.bind(WorkerLazyRegister.class).asEagerSingleton();
        }
    }

    private static class CoordinatorLazyRegister {
        @Inject
        public CoordinatorLazyRegister(DefaultCatalogFactory defaultCatalogFactory, LazyCatalogFactory lazyCatalogFactory, CoordinatorDynamicCatalogManager catalogManager, GlobalSystemConnector globalSystemConnector) {
            lazyCatalogFactory.setCatalogFactory(defaultCatalogFactory);
            catalogManager.registerGlobalSystemConnector(globalSystemConnector);
        }
    }

    private static class WorkerLazyRegister {
        @Inject
        public WorkerLazyRegister(DefaultCatalogFactory defaultCatalogFactory, LazyCatalogFactory lazyCatalogFactory, WorkerDynamicCatalogManager catalogManager, GlobalSystemConnector globalSystemConnector) {
            lazyCatalogFactory.setCatalogFactory(defaultCatalogFactory);
            catalogManager.registerGlobalSystemConnector(globalSystemConnector);
        }
    }
}

