/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.jdbc;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.connector.system.jdbc.JdbcTable;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.TypeUtils;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ColumnJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "columns");
    private static final int MAX_DOMAIN_SIZE = 100;
    private static final int MAX_TIMEZONE_LENGTH = ZoneId.getAvailableZoneIds().stream().map(String::length).max(Integer::compareTo).get();
    private static final ColumnHandle TABLE_CATALOG_COLUMN = new SystemColumnHandle("table_cat");
    private static final ColumnHandle TABLE_SCHEMA_COLUMN = new SystemColumnHandle("table_schem");
    private static final ColumnHandle TABLE_NAME_COLUMN = new SystemColumnHandle("table_name");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.VARCHAR).column("table_schem", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("column_name", (Type)VarcharType.VARCHAR).column("data_type", (Type)BigintType.BIGINT).column("type_name", (Type)VarcharType.VARCHAR).column("column_size", (Type)BigintType.BIGINT).column("buffer_length", (Type)BigintType.BIGINT).column("decimal_digits", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).column("nullable", (Type)BigintType.BIGINT).column("remarks", (Type)VarcharType.VARCHAR).column("column_def", (Type)VarcharType.VARCHAR).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("char_octet_length", (Type)BigintType.BIGINT).column("ordinal_position", (Type)BigintType.BIGINT).column("is_nullable", (Type)VarcharType.VARCHAR).column("scope_catalog", (Type)VarcharType.VARCHAR).column("scope_schema", (Type)VarcharType.VARCHAR).column("scope_table", (Type)VarcharType.VARCHAR).column("source_data_type", (Type)BigintType.BIGINT).column("is_autoincrement", (Type)VarcharType.VARCHAR).column("is_generatedcolumn", (Type)VarcharType.VARCHAR).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public ColumnJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    @Override
    public TupleDomain<ColumnHandle> applyFilter(ConnectorSession connectorSession, Constraint constraint) {
        TupleDomain tupleDomain = constraint.getSummary();
        if (tupleDomain.isNone() || constraint.predicate().isEmpty()) {
            return tupleDomain;
        }
        Predicate predicate = (Predicate)constraint.predicate().get();
        Set predicateColumns = (Set)constraint.getPredicateColumns().orElseThrow(() -> new VerifyException("columns not present for a predicate"));
        boolean hasSchemaPredicate = predicateColumns.contains(TABLE_SCHEMA_COLUMN);
        boolean hasTablePredicate = predicateColumns.contains(TABLE_NAME_COLUMN);
        if (!hasSchemaPredicate && !hasTablePredicate) {
            return tupleDomain;
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Domain catalogDomain = tupleDomain.getDomain((Object)TABLE_CATALOG_COLUMN, (Type)VarcharType.VARCHAR);
        Domain schemaDomain = tupleDomain.getDomain((Object)TABLE_SCHEMA_COLUMN, (Type)VarcharType.VARCHAR);
        Domain tableDomain = tupleDomain.getDomain((Object)TABLE_NAME_COLUMN, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(catalogDomain) || FilterUtil.isImpossibleObjectName(schemaDomain) || FilterUtil.isImpossibleObjectName(tableDomain)) {
            return TupleDomain.none();
        }
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(schemaDomain);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tableDomain);
        if (schemaFilter.isPresent() && tableFilter.isPresent()) {
            return tupleDomain;
        }
        List catalogs = (List)MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogDomain).stream().filter(catalogName -> predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(catalogName)))).collect(ImmutableList.toImmutableList());
        List schemas = (List)catalogs.stream().flatMap(catalogName -> MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalogName, schemaFilter).stream().filter(schemaName -> !hasSchemaPredicate || predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(catalogName), (Object)TABLE_SCHEMA_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaName)))).map(schemaName -> new CatalogSchemaName(catalogName, schemaName))).collect(ImmutableList.toImmutableList());
        if (!hasTablePredicate) {
            return TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)TABLE_CATALOG_COLUMN, (Object)schemas.stream().map(CatalogSchemaName::getCatalogName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_SCHEMA_COLUMN, (Object)schemas.stream().map(CatalogSchemaName::getSchemaName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).buildOrThrow());
        }
        List tables = (List)schemas.stream().flatMap(schema -> {
            QualifiedTablePrefix tablePrefix = tableFilter.isPresent() ? new QualifiedTablePrefix(schema.getCatalogName(), schema.getSchemaName(), (String)tableFilter.get()) : new QualifiedTablePrefix(schema.getCatalogName(), schema.getSchemaName());
            return MetadataListing.listTables(session, this.metadata, this.accessControl, tablePrefix).stream().filter(schemaTableName -> predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schema.getCatalogName()), (Object)TABLE_SCHEMA_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaTableName.getSchemaName()), (Object)TABLE_NAME_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaTableName.getTableName())))).map(schemaTableName -> new CatalogSchemaTableName(schema.getCatalogName(), schemaTableName.getSchemaName(), schemaTableName.getTableName()));
        }).collect(ImmutableList.toImmutableList());
        return TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)TABLE_CATALOG_COLUMN, (Object)tables.stream().map(CatalogSchemaTableName::getCatalogName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_SCHEMA_COLUMN, (Object)tables.stream().map(catalogSchemaTableName -> catalogSchemaTableName.getSchemaTableName().getSchemaName()).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_NAME_COLUMN, (Object)tables.stream().map(catalogSchemaTableName -> catalogSchemaTableName.getSchemaTableName().getTableName()).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).buildOrThrow());
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        if (constraint.isNone()) {
            return table.build().cursor();
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        boolean omitDateTimeTypePrecision = SystemSessionProperties.isOmitDateTimeTypePrecision(session);
        Domain catalogDomain = constraint.getDomain((Object)0, (Type)VarcharType.VARCHAR);
        Domain schemaDomain = constraint.getDomain((Object)1, (Type)VarcharType.VARCHAR);
        Domain tableDomain = constraint.getDomain((Object)2, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(catalogDomain) || FilterUtil.isImpossibleObjectName(schemaDomain) || FilterUtil.isImpossibleObjectName(tableDomain)) {
            return table.build().cursor();
        }
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(schemaDomain);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tableDomain);
        for (String catalog : MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogDomain)) {
            if (!catalogDomain.includesNullableValue((Object)Slices.utf8Slice((String)catalog))) continue;
            if (schemaDomain.isAll() && tableDomain.isAll() || schemaFilter.isPresent()) {
                QualifiedTablePrefix tablePrefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
                Map<SchemaTableName, List<ColumnMetadata>> tableColumns = MetadataListing.listTableColumns(session, this.metadata, this.accessControl, tablePrefix);
                ColumnJdbcTable.addColumnsRow(table, catalog, tableColumns, omitDateTimeTypePrecision);
                continue;
            }
            SortedSet<String> schemas = MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalog, schemaFilter);
            for (String schema : schemas) {
                if (!schemaDomain.includesNullableValue((Object)Slices.utf8Slice((String)schema))) continue;
                QualifiedTablePrefix tablePrefix = tableFilter.isPresent() ? new QualifiedTablePrefix(catalog, schema, tableFilter.get()) : new QualifiedTablePrefix(catalog, schema);
                Set<SchemaTableName> tables = MetadataListing.listTables(session, this.metadata, this.accessControl, tablePrefix);
                for (SchemaTableName schemaTableName : tables) {
                    String tableName = schemaTableName.getTableName();
                    if (!tableDomain.includesNullableValue((Object)Slices.utf8Slice((String)tableName))) continue;
                    Map<SchemaTableName, List<ColumnMetadata>> tableColumns = MetadataListing.listTableColumns(session, this.metadata, this.accessControl, new QualifiedTablePrefix(catalog, schema, tableName));
                    ColumnJdbcTable.addColumnsRow(table, catalog, tableColumns, omitDateTimeTypePrecision);
                }
            }
        }
        return table.build().cursor();
    }

    private static void addColumnsRow(InMemoryRecordSet.Builder builder, String catalog, Map<SchemaTableName, List<ColumnMetadata>> columns, boolean isOmitTimestampPrecision) {
        for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : columns.entrySet()) {
            ColumnJdbcTable.addColumnRows(builder, catalog, entry.getKey(), entry.getValue(), isOmitTimestampPrecision);
        }
    }

    private static void addColumnRows(InMemoryRecordSet.Builder builder, String catalog, SchemaTableName tableName, List<ColumnMetadata> columns, boolean isOmitTimestampPrecision) {
        int ordinalPosition = 1;
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            builder.addRow(new Object[]{catalog, tableName.getSchemaName(), tableName.getTableName(), column.getName(), ColumnJdbcTable.jdbcDataType(column.getType()), TypeUtils.getDisplayLabel(column.getType(), isOmitTimestampPrecision), ColumnJdbcTable.columnSize(column.getType()), 0, ColumnJdbcTable.decimalDigits(column.getType()), ColumnJdbcTable.numPrecRadix(column.getType()), column.isNullable() ? 1 : 0, column.getComment(), null, null, null, ColumnJdbcTable.charOctetLength(column.getType()), ordinalPosition, column.isNullable() ? "YES" : "NO", null, null, null, null, null, null});
            ++ordinalPosition;
        }
    }

    static int jdbcDataType(Type type) {
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return 16;
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return 4;
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return -6;
        }
        if (type.equals((Object)RealType.REAL)) {
            return 7;
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return 8;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (type instanceof VarcharType) {
            return 12;
        }
        if (type instanceof CharType) {
            return 1;
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return -3;
        }
        if (type.equals((Object)DateType.DATE)) {
            return 91;
        }
        if (type instanceof TimeType) {
            return 92;
        }
        if (type instanceof TimeWithTimeZoneType) {
            return 2013;
        }
        if (type instanceof TimestampType) {
            return 93;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return 2014;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        return 2000;
    }

    static Integer columnSize(Type type) {
        if (type.equals((Object)BigintType.BIGINT)) {
            return 19;
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return 10;
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return 3;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getPrecision();
        }
        if (type.equals((Object)RealType.REAL)) {
            return 24;
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return 53;
        }
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (type instanceof CharType) {
            return ((CharType)type).getLength();
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        if (type instanceof TimeType) {
            int precision = ((TimeType)type).getPrecision();
            return 8 + Math.min(precision, 1) + precision;
        }
        if (type instanceof TimeWithTimeZoneType) {
            int precision = ((TimeWithTimeZoneType)type).getPrecision();
            return 8 + Math.min(precision, 1) + precision + 6;
        }
        if (type.equals((Object)DateType.DATE)) {
            return 14;
        }
        if (type instanceof TimestampType) {
            int precision = ((TimestampType)type).getPrecision();
            return 21 + Math.min(precision, 1) + precision;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            int precision = ((TimestampWithTimeZoneType)type).getPrecision();
            return 22 + Math.min(precision, 1) + precision + 1 + MAX_TIMEZONE_LENGTH;
        }
        return null;
    }

    private static Integer decimalDigits(Type type) {
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getScale();
        }
        if (type instanceof TimeType) {
            return ((TimeType)type).getPrecision();
        }
        if (type instanceof TimeWithTimeZoneType) {
            return ((TimeWithTimeZoneType)type).getPrecision();
        }
        if (type instanceof TimestampType) {
            return ((TimestampType)type).getPrecision();
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return ((TimestampWithTimeZoneType)type).getPrecision();
        }
        return null;
    }

    private static Integer charOctetLength(Type type) {
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (type instanceof CharType) {
            return ((CharType)type).getLength();
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }

    static Integer numPrecRadix(Type type) {
        if (type.equals((Object)BigintType.BIGINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)TinyintType.TINYINT) || type instanceof DecimalType) {
            return 10;
        }
        if (type.equals((Object)RealType.REAL) || type.equals((Object)DoubleType.DOUBLE)) {
            return 2;
        }
        return null;
    }

    private static NullableValue toNullableValue(String varcharValue) {
        return NullableValue.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)varcharValue));
    }

    private static Collector<String, ?, Domain> toVarcharDomain() {
        return Collectors.collectingAndThen(ImmutableSet.toImmutableSet(), set -> {
            if (set.isEmpty()) {
                return Domain.none((Type)VarcharType.VARCHAR);
            }
            return Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)set.stream().map(Slices::utf8Slice).collect(ImmutableList.toImmutableList())));
        });
    }
}

