/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"dynamic-filtering-max-per-driver-row-count", "dynamic-filtering-max-per-driver-size", "dynamic-filtering-range-row-limit-per-driver", "dynamic-filtering.service-thread-count", "experimental.dynamic-filtering-max-per-driver-row-count", "experimental.dynamic-filtering-max-per-driver-size", "experimental.dynamic-filtering-refresh-interval", "experimental.enable-dynamic-filtering", "enable-coordinator-dynamic-filters-distribution"})
public class DynamicFilterConfig {
    private boolean enableDynamicFiltering = true;
    private boolean enableLargeDynamicFilters;
    private int smallMaxDistinctValuesPerDriver = 1000;
    private DataSize smallMaxSizePerDriver = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int smallRangeRowLimitPerDriver = 2000;
    private DataSize smallMaxSizePerOperator = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int smallPartitionedMaxDistinctValuesPerDriver = 100;
    private DataSize smallPartitionedMaxSizePerDriver = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int smallPartitionedRangeRowLimitPerDriver = 500;
    private DataSize smallPartitionedMaxSizePerOperator = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize smallMaxSizePerFilter = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int largeMaxDistinctValuesPerDriver = 10000;
    private DataSize largeMaxSizePerDriver = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int largeRangeRowLimitPerDriver = 20000;
    private DataSize largeMaxSizePerOperator = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int largePartitionedMaxDistinctValuesPerDriver = 1000;
    private DataSize largePartitionedMaxSizePerDriver = DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private int largePartitionedRangeRowLimitPerDriver = 2000;
    private DataSize largePartitionedMaxSizePerOperator = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize largeMaxSizePerFilter = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);

    public boolean isEnableDynamicFiltering() {
        return this.enableDynamicFiltering;
    }

    @Config(value="enable-dynamic-filtering")
    public DynamicFilterConfig setEnableDynamicFiltering(boolean enableDynamicFiltering) {
        this.enableDynamicFiltering = enableDynamicFiltering;
        return this;
    }

    public boolean isEnableLargeDynamicFilters() {
        return this.enableLargeDynamicFilters;
    }

    @Config(value="enable-large-dynamic-filters")
    public DynamicFilterConfig setEnableLargeDynamicFilters(boolean enableLargeDynamicFilters) {
        this.enableLargeDynamicFilters = enableLargeDynamicFilters;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallMaxDistinctValuesPerDriver() {
        return this.smallMaxDistinctValuesPerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.small-broadcast.max-distinct-values-per-driver"})
    @Config(value="dynamic-filtering.small.max-distinct-values-per-driver")
    public DynamicFilterConfig setSmallMaxDistinctValuesPerDriver(int smallMaxDistinctValuesPerDriver) {
        this.smallMaxDistinctValuesPerDriver = smallMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getSmallMaxSizePerDriver() {
        return this.smallMaxSizePerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.small-broadcast.max-size-per-driver"})
    @Config(value="dynamic-filtering.small.max-size-per-driver")
    public DynamicFilterConfig setSmallMaxSizePerDriver(DataSize smallMaxSizePerDriver) {
        this.smallMaxSizePerDriver = smallMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallRangeRowLimitPerDriver() {
        return this.smallRangeRowLimitPerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.small-broadcast.range-row-limit-per-driver"})
    @Config(value="dynamic-filtering.small.range-row-limit-per-driver")
    public DynamicFilterConfig setSmallRangeRowLimitPerDriver(int smallRangeRowLimitPerDriver) {
        this.smallRangeRowLimitPerDriver = smallRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="10MB")
    public @MaxDataSize(value="10MB") DataSize getSmallMaxSizePerOperator() {
        return this.smallMaxSizePerOperator;
    }

    @LegacyConfig(value={"dynamic-filtering.small-broadcast.max-size-per-operator"})
    @Config(value="dynamic-filtering.small.max-size-per-operator")
    public DynamicFilterConfig setSmallMaxSizePerOperator(DataSize smallMaxSizePerOperator) {
        this.smallMaxSizePerOperator = smallMaxSizePerOperator;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallPartitionedMaxDistinctValuesPerDriver() {
        return this.smallPartitionedMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-distinct-values-per-driver")
    public DynamicFilterConfig setSmallPartitionedMaxDistinctValuesPerDriver(int smallPartitionedMaxDistinctValuesPerDriver) {
        this.smallPartitionedMaxDistinctValuesPerDriver = smallPartitionedMaxDistinctValuesPerDriver;
        return this;
    }

    @MaxDataSize(value="1MB")
    public @MaxDataSize(value="1MB") DataSize getSmallPartitionedMaxSizePerDriver() {
        return this.smallPartitionedMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-size-per-driver")
    public DynamicFilterConfig setSmallPartitionedMaxSizePerDriver(DataSize smallPartitionedMaxSizePerDriver) {
        this.smallPartitionedMaxSizePerDriver = smallPartitionedMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getSmallPartitionedRangeRowLimitPerDriver() {
        return this.smallPartitionedRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.small-partitioned.range-row-limit-per-driver")
    public DynamicFilterConfig setSmallPartitionedRangeRowLimitPerDriver(int smallPartitionedRangeRowLimitPerDriver) {
        this.smallPartitionedRangeRowLimitPerDriver = smallPartitionedRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="10MB")
    public @MaxDataSize(value="10MB") DataSize getSmallPartitionedMaxSizePerOperator() {
        return this.smallPartitionedMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.small-partitioned.max-size-per-operator")
    public DynamicFilterConfig setSmallPartitionedMaxSizePerOperator(DataSize smallPartitionedMaxSizePerOperator) {
        this.smallPartitionedMaxSizePerOperator = smallPartitionedMaxSizePerOperator;
        return this;
    }

    @NotNull
    @MaxDataSize(value="10MB")
    public @NotNull @MaxDataSize(value="10MB") DataSize getSmallMaxSizePerFilter() {
        return this.smallMaxSizePerFilter;
    }

    @Config(value="dynamic-filtering.small.max-size-per-filter")
    public DynamicFilterConfig setSmallMaxSizePerFilter(DataSize smallMaxSizePerFilter) {
        this.smallMaxSizePerFilter = smallMaxSizePerFilter;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargeMaxDistinctValuesPerDriver() {
        return this.largeMaxDistinctValuesPerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.large-broadcast.max-distinct-values-per-driver"})
    @Config(value="dynamic-filtering.large.max-distinct-values-per-driver")
    public DynamicFilterConfig setLargeMaxDistinctValuesPerDriver(int largeMaxDistinctValuesPerDriver) {
        this.largeMaxDistinctValuesPerDriver = largeMaxDistinctValuesPerDriver;
        return this;
    }

    public DataSize getLargeMaxSizePerDriver() {
        return this.largeMaxSizePerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.large-broadcast.max-size-per-driver"})
    @Config(value="dynamic-filtering.large.max-size-per-driver")
    public DynamicFilterConfig setLargeMaxSizePerDriver(DataSize largeMaxSizePerDriver) {
        this.largeMaxSizePerDriver = largeMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargeRangeRowLimitPerDriver() {
        return this.largeRangeRowLimitPerDriver;
    }

    @LegacyConfig(value={"dynamic-filtering.large-broadcast.range-row-limit-per-driver"})
    @Config(value="dynamic-filtering.large.range-row-limit-per-driver")
    public DynamicFilterConfig setLargeRangeRowLimitPerDriver(int largeRangeRowLimitPerDriver) {
        this.largeRangeRowLimitPerDriver = largeRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="100MB")
    public @MaxDataSize(value="100MB") DataSize getLargeMaxSizePerOperator() {
        return this.largeMaxSizePerOperator;
    }

    @LegacyConfig(value={"dynamic-filtering.large-broadcast.max-size-per-operator"})
    @Config(value="dynamic-filtering.large.max-size-per-operator")
    public DynamicFilterConfig setLargeMaxSizePerOperator(DataSize largeMaxSizePerOperator) {
        this.largeMaxSizePerOperator = largeMaxSizePerOperator;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargePartitionedMaxDistinctValuesPerDriver() {
        return this.largePartitionedMaxDistinctValuesPerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-distinct-values-per-driver")
    public DynamicFilterConfig setLargePartitionedMaxDistinctValuesPerDriver(int largePartitionedMaxDistinctValuesPerDriver) {
        this.largePartitionedMaxDistinctValuesPerDriver = largePartitionedMaxDistinctValuesPerDriver;
        return this;
    }

    public DataSize getLargePartitionedMaxSizePerDriver() {
        return this.largePartitionedMaxSizePerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-size-per-driver")
    public DynamicFilterConfig setLargePartitionedMaxSizePerDriver(DataSize largePartitionedMaxSizePerDriver) {
        this.largePartitionedMaxSizePerDriver = largePartitionedMaxSizePerDriver;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getLargePartitionedRangeRowLimitPerDriver() {
        return this.largePartitionedRangeRowLimitPerDriver;
    }

    @Config(value="dynamic-filtering.large-partitioned.range-row-limit-per-driver")
    public DynamicFilterConfig setLargePartitionedRangeRowLimitPerDriver(int largePartitionedRangeRowLimitPerDriver) {
        this.largePartitionedRangeRowLimitPerDriver = largePartitionedRangeRowLimitPerDriver;
        return this;
    }

    @MaxDataSize(value="50MB")
    public @MaxDataSize(value="50MB") DataSize getLargePartitionedMaxSizePerOperator() {
        return this.largePartitionedMaxSizePerOperator;
    }

    @Config(value="dynamic-filtering.large-partitioned.max-size-per-operator")
    public DynamicFilterConfig setLargePartitionedMaxSizePerOperator(DataSize largePartitionedMaxSizePerOperator) {
        this.largePartitionedMaxSizePerOperator = largePartitionedMaxSizePerOperator;
        return this;
    }

    @NotNull
    @MaxDataSize(value="10MB")
    public @NotNull @MaxDataSize(value="10MB") DataSize getLargeMaxSizePerFilter() {
        return this.largeMaxSizePerFilter;
    }

    @Config(value="dynamic-filtering.large.max-size-per-filter")
    public DynamicFilterConfig setLargeMaxSizePerFilter(DataSize largeMaxSizePerFilter) {
        this.largeMaxSizePerFilter = largeMaxSizePerFilter;
        return this;
    }
}

