/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogFunctionMetadata;
import io.trino.metadata.FunctionBinder;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SignatureBinder;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCodeSupplier;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class FunctionResolver {
    private final Metadata metadata;
    private final TypeManager typeManager;
    private final LanguageFunctionManager languageFunctionManager;
    private final WarningCollector warningCollector;
    private final FunctionBinder functionBinder;

    public FunctionResolver(Metadata metadata, TypeManager typeManager, LanguageFunctionManager languageFunctionManager, WarningCollector warningCollector) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.languageFunctionManager = Objects.requireNonNull(languageFunctionManager, "languageFunctionManager is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.functionBinder = new FunctionBinder(metadata, typeManager);
    }

    public boolean isAggregationFunction(Session session, QualifiedName name, AccessControl accessControl) {
        return this.isFunctionKind(session, name, FunctionKind.AGGREGATE, accessControl);
    }

    public boolean isWindowFunction(Session session, QualifiedName name, AccessControl accessControl) {
        return this.isFunctionKind(session, name, FunctionKind.WINDOW, accessControl);
    }

    private boolean isFunctionKind(Session session, QualifiedName name, FunctionKind functionKind, AccessControl accessControl) {
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name, accessControl)) {
            Collection<CatalogFunctionMetadata> candidates = this.metadata.getFunctions(session, catalogSchemaFunctionName);
            if (candidates.isEmpty()) continue;
            return candidates.stream().map(CatalogFunctionMetadata::functionMetadata).map(FunctionMetadata::getKind).anyMatch(arg_0 -> functionKind.equals(arg_0));
        }
        return false;
    }

    public ResolvedFunction resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes, AccessControl accessControl) {
        FunctionBinder.CatalogFunctionBinding catalogFunctionBinding = this.bindFunction(session, name, parameterTypes, catalogSchemaFunctionName -> this.metadata.getFunctions(session, (CatalogSchemaFunctionName)catalogSchemaFunctionName), accessControl);
        FunctionMetadata functionMetadata = catalogFunctionBinding.boundFunctionMetadata();
        if (functionMetadata.isDeprecated()) {
            this.warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.DEPRECATED_FUNCTION, "Use of deprecated function: %s: %s".formatted(name, functionMetadata.getDescription())));
        }
        return this.resolve(session, catalogFunctionBinding, accessControl);
    }

    private ResolvedFunction resolve(Session session, FunctionBinder.CatalogFunctionBinding functionBinding, AccessControl accessControl) {
        if (LanguageFunctionManager.isTrinoSqlLanguageFunction(functionBinding.functionBinding().getFunctionId())) {
            FunctionId resolvedFunctionId = this.languageFunctionManager.analyzeAndPlan(session, functionBinding.functionBinding().getFunctionId(), accessControl);
            return new ResolvedFunction(functionBinding.functionBinding().getBoundSignature(), functionBinding.catalogHandle(), resolvedFunctionId, functionBinding.boundFunctionMetadata().getKind(), functionBinding.boundFunctionMetadata().isDeterministic(), functionBinding.boundFunctionMetadata().getFunctionNullability(), (Map<TypeSignature, Type>)ImmutableMap.of(), (Set<ResolvedFunction>)ImmutableSet.of());
        }
        FunctionDependencyDeclaration dependencies = this.metadata.getFunctionDependencies(session, functionBinding.catalogHandle(), functionBinding.functionBinding().getFunctionId(), functionBinding.functionBinding().getBoundSignature());
        return FunctionResolver.resolveFunctionBinding(this.metadata, this.typeManager, this.functionBinder, functionBinding.catalogHandle(), functionBinding.functionBinding(), functionBinding.boundFunctionMetadata(), dependencies, catalogSchemaFunctionName -> this.metadata.getFunctions(session, (CatalogSchemaFunctionName)catalogSchemaFunctionName), catalogFunctionBinding -> this.resolve(session, (FunctionBinder.CatalogFunctionBinding)catalogFunctionBinding, accessControl));
    }

    private FunctionBinder.CatalogFunctionBinding bindFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader, AccessControl accessControl) {
        ImmutableList.Builder allCandidates = ImmutableList.builder();
        List<CatalogSchemaFunctionName> fullPath = FunctionResolver.toPath(session, name, accessControl);
        List authorizedPath = (List)fullPath.stream().filter(catalogSchemaFunctionName -> FunctionResolver.canExecuteFunction(session, accessControl, catalogSchemaFunctionName)).collect(ImmutableList.toImmutableList());
        for (CatalogSchemaFunctionName catalogSchemaFunctionName2 : authorizedPath) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName2);
            Optional<FunctionBinder.CatalogFunctionBinding> match = this.functionBinder.tryBindFunction(parameterTypes, candidates);
            if (match.isPresent()) {
                return match.get();
            }
            allCandidates.addAll(candidates);
        }
        Sets.SetView unauthorizedPath = Sets.difference((Set)ImmutableSet.copyOf(fullPath), (Set)ImmutableSet.copyOf((Collection)authorizedPath));
        if (unauthorizedPath.stream().anyMatch(functionName -> !((Collection)candidateLoader.apply((CatalogSchemaFunctionName)functionName)).isEmpty())) {
            AccessDeniedException.denyExecuteFunction((String)name.toString());
        }
        ImmutableList candidates = allCandidates.build();
        throw FunctionBinder.functionNotFound(name.toString(), parameterTypes, (Collection<CatalogFunctionMetadata>)candidates);
    }

    static ResolvedFunction resolveFunctionBinding(Metadata metadata, TypeManager typeManager, FunctionBinder functionBinder, CatalogHandle catalogHandle, FunctionBinding functionBinding, FunctionMetadata functionMetadata, FunctionDependencyDeclaration dependencies, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader, Function<FunctionBinder.CatalogFunctionBinding, ResolvedFunction> resolver) {
        Map dependentTypes = (Map)dependencies.getTypeDependencies().stream().map(typeSignature -> SignatureBinder.applyBoundVariables(typeSignature, functionBinding)).collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((TypeManager)typeManager).getType(arg_0), (left, right) -> left));
        ImmutableSet.Builder functions = ImmutableSet.builder();
        for (FunctionDependencyDeclaration.FunctionDependency functionDependency : dependencies.getFunctionDependencies()) {
            try {
                CatalogSchemaFunctionName name = functionDependency.getName();
                FunctionBinder.CatalogFunctionBinding catalogFunctionBinding = functionBinder.bindFunction(TypeSignatureProvider.fromTypeSignatures(SignatureBinder.applyBoundVariables((List<TypeSignature>)functionDependency.getArgumentTypes(), functionBinding)), candidateLoader.apply(name), name.toString());
                functions.add((Object)resolver.apply(catalogFunctionBinding));
            }
            catch (TrinoException e) {
                if (functionDependency.isOptional()) continue;
                throw e;
            }
        }
        for (FunctionDependencyDeclaration.OperatorDependency operatorDependency : dependencies.getOperatorDependencies()) {
            try {
                List argumentTypes = (List)SignatureBinder.applyBoundVariables((List<TypeSignature>)operatorDependency.getArgumentTypes(), functionBinding).stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
                functions.add((Object)metadata.resolveOperator(operatorDependency.getOperatorType(), argumentTypes));
            }
            catch (TrinoException e) {
                if (operatorDependency.isOptional()) continue;
                throw e;
            }
        }
        for (FunctionDependencyDeclaration.CastDependency castDependency : dependencies.getCastDependencies()) {
            try {
                Type fromType = typeManager.getType(SignatureBinder.applyBoundVariables(castDependency.getFromType(), functionBinding));
                Type toType = typeManager.getType(SignatureBinder.applyBoundVariables(castDependency.getToType(), functionBinding));
                functions.add((Object)metadata.getCoercion(fromType, toType));
            }
            catch (TrinoException e) {
                if (castDependency.isOptional()) continue;
                throw e;
            }
        }
        return new ResolvedFunction(functionBinding.getBoundSignature(), catalogHandle, functionBinding.getFunctionId(), functionMetadata.getKind(), functionMetadata.isDeterministic(), functionMetadata.getFunctionNullability(), dependentTypes, (Set<ResolvedFunction>)functions.build());
    }

    public static List<CatalogSchemaFunctionName> toPath(Session session, QualifiedName name, AccessControl accessControl) {
        List parts = name.getParts();
        if (parts.size() > 3) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "Invalid function name: " + String.valueOf(name));
        }
        if (parts.size() == 3) {
            return ImmutableList.of((Object)new CatalogSchemaFunctionName((String)parts.get(0), (String)parts.get(1), (String)parts.get(2)));
        }
        if (parts.size() == 2) {
            String currentCatalog = session.getCatalog().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, "Session default catalog must be set to resolve a partial function name: " + String.valueOf(name)));
            return ImmutableList.of((Object)new CatalogSchemaFunctionName(currentCatalog, (String)parts.get(0), (String)parts.get(1)));
        }
        ImmutableList.Builder names = ImmutableList.builder();
        for (CatalogSchemaName element : session.getPath().getPath()) {
            names.add((Object)new CatalogSchemaFunctionName(element.getCatalogName(), element.getSchemaName(), (String)parts.get(0)));
        }
        return names.build();
    }

    private static boolean canExecuteFunction(Session session, AccessControl accessControl, CatalogSchemaFunctionName functionName) {
        if (LanguageFunctionManager.isInlineFunction(functionName) || GlobalFunctionCatalog.isBuiltinFunctionName(functionName)) {
            return true;
        }
        return accessControl.canExecuteFunction(SecurityContext.of(session), new QualifiedObjectName(functionName.getCatalogName(), functionName.getSchemaName(), functionName.getFunctionName()));
    }
}

