/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.index.TuplePageFilter;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.PageFilterEvaluator;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.Expressions;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DynamicTupleFilterFactory {
    private final int filterOperatorId;
    private final PlanNodeId planNodeId;
    private final int[] tupleFilterChannels;
    private final List<Integer> outputFilterChannels;
    private final List<BlockTypeOperators.BlockPositionEqual> filterEqualOperators;
    private final List<Type> outputTypes;
    private final List<Supplier<PageProjection>> outputProjections;

    public DynamicTupleFilterFactory(int filterOperatorId, PlanNodeId planNodeId, int[] tupleFilterChannels, int[] outputFilterChannels, List<Type> outputTypes, PageFunctionCompiler pageFunctionCompiler, BlockTypeOperators blockTypeOperators) {
        Objects.requireNonNull(planNodeId, "planNodeId is null");
        Objects.requireNonNull(tupleFilterChannels, "tupleFilterChannels is null");
        Preconditions.checkArgument((tupleFilterChannels.length > 0 ? 1 : 0) != 0, (Object)"Must have at least one tupleFilterChannel");
        Objects.requireNonNull(outputFilterChannels, "outputFilterChannels is null");
        Preconditions.checkArgument((outputFilterChannels.length == tupleFilterChannels.length ? 1 : 0) != 0, (Object)"outputFilterChannels must have same length as tupleFilterChannels");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Preconditions.checkArgument((outputTypes.size() >= outputFilterChannels.length ? 1 : 0) != 0, (Object)"Must have at least as many output channels as those used for filtering");
        Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.filterOperatorId = filterOperatorId;
        this.planNodeId = planNodeId;
        this.tupleFilterChannels = (int[])tupleFilterChannels.clone();
        this.outputFilterChannels = ImmutableList.copyOf((Collection)Ints.asList((int[])outputFilterChannels));
        this.filterEqualOperators = (List)IntStream.of(outputFilterChannels).mapToObj(outputTypes::get).map(blockTypeOperators::getEqualOperator).collect(ImmutableList.toImmutableList());
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.outputProjections = (List)IntStream.range(0, outputTypes.size()).mapToObj(field -> pageFunctionCompiler.compileProjection(Expressions.field(field, (Type)outputTypes.get(field)), Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public OperatorFactory filterWithTuple(Page tuplePage) {
        Supplier<PageProcessor> processor = this.createPageProcessor(tuplePage.getColumns(this.tupleFilterChannels), OptionalInt.empty());
        return FilterAndProjectOperator.createOperatorFactory(this.filterOperatorId, this.planNodeId, processor, this.outputTypes, DataSize.ofBytes((long)0L), 0);
    }

    @VisibleForTesting
    public Supplier<PageProcessor> createPageProcessor(Page filterTuple, OptionalInt initialBatchSize) {
        TuplePageFilter filter = new TuplePageFilter(filterTuple, this.filterEqualOperators, this.outputFilterChannels);
        return () -> new PageProcessor(Optional.of(new PageFilterEvaluator(filter)), (List)this.outputProjections.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()), initialBatchSize);
    }
}

