/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.gen.lambda.BinaryFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ZipWithFunction
extends SqlScalarFunction {
    public static final ZipWithFunction ZIP_WITH_FUNCTION = new ZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ZipWithFunction.class, "zipWith", Type.class, Type.class, ArrayType.class, Object.class, Block.class, Block.class, BinaryFunctionInterface.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ZipWithFunction.class, "createState", ArrayType.class);

    private ZipWithFunction() {
        super(FunctionMetadata.scalarBuilder((String)"zip_with").signature(Signature.builder().typeVariable("T").typeVariable("U").typeVariable("R").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("R", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("U", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("U", new TypeSignatureParameter[0]), new TypeSignature("R", new TypeSignatureParameter[0])})).build()).nondeterministic().description("Merge two arrays, element-wise, into a single array using the lambda function").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type leftElementType = ((ArrayType)boundSignature.getArgumentType(0)).getElementType();
        Type rightElementType = ((ArrayType)boundSignature.getArgumentType(1)).getElementType();
        Type outputElementType = ((ArrayType)boundSignature.getReturnType()).getElementType();
        ArrayType outputArrayType = new ArrayType(outputElementType);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class), METHOD_HANDLE.bindTo(leftElementType).bindTo(rightElementType).bindTo(outputArrayType), Optional.of(STATE_FACTORY.bindTo(outputArrayType)));
    }

    public static Object createState(ArrayType arrayType) {
        return BufferedArrayValueBuilder.createBuffered((ArrayType)arrayType);
    }

    public static Block zipWith(Type leftElementType, Type rightElementType, ArrayType outputArrayType, Object state, Block leftBlock, Block rightBlock, BinaryFunctionInterface function) {
        Type outputElementType = outputArrayType.getElementType();
        int leftPositionCount = leftBlock.getPositionCount();
        int rightPositionCount = rightBlock.getPositionCount();
        int outputPositionCount = Math.max(leftPositionCount, rightPositionCount);
        BufferedArrayValueBuilder arrayValueBuilder = (BufferedArrayValueBuilder)state;
        return arrayValueBuilder.build(outputPositionCount, valueBuilder -> {
            for (int position = 0; position < outputPositionCount; ++position) {
                Object left = position < leftPositionCount ? TypeUtils.readNativeValue((Type)leftElementType, (Block)leftBlock, (int)position) : null;
                Object right = position < rightPositionCount ? TypeUtils.readNativeValue((Type)rightElementType, (Block)rightBlock, (int)position) : null;
                Object output = function.apply(left, right);
                TypeUtils.writeNativeValue((Type)outputElementType, (BlockBuilder)valueBuilder, (Object)output);
            }
        });
    }
}

