/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.Iterables;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ValueWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import java.util.List;

@WindowFunctionSignature(name="last_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class LastValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;
    private final boolean ignoreNulls;
    private int recordedFrameEnd = -1;
    private int recordedValuePosition = -1;
    private int recordedNullPosition = -1;

    public LastValueFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
        this.ignoreNulls = ignoreNulls;
    }

    public void reset() {
        this.recordedFrameEnd = -1;
        this.recordedValuePosition = -1;
        this.recordedNullPosition = -1;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        int valuePosition;
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        if (!this.ignoreNulls) {
            this.windowIndex.appendTo(this.argumentChannel, frameEnd, output);
            return;
        }
        if (this.recordedFrameEnd >= 0 && frameEnd <= this.recordedFrameEnd) {
            if (this.recordedValuePosition >= 0 && frameEnd >= this.recordedValuePosition) {
                if (frameStart > this.recordedValuePosition) {
                    output.appendNull();
                    return;
                }
                this.windowIndex.appendTo(this.argumentChannel, this.recordedValuePosition, output);
                return;
            }
            if (this.recordedNullPosition >= 0 && frameEnd >= this.recordedNullPosition && frameStart >= this.recordedNullPosition) {
                output.appendNull();
                return;
            }
        }
        this.recordedFrameEnd = frameEnd;
        this.recordedValuePosition = -1;
        this.recordedNullPosition = -1;
        for (valuePosition = this.recordedFrameEnd >= 0 && this.recordedNullPosition >= 0 && frameEnd <= this.recordedFrameEnd && frameEnd >= this.recordedNullPosition ? this.recordedNullPosition : frameEnd; valuePosition >= frameStart && this.windowIndex.isNull(this.argumentChannel, valuePosition); --valuePosition) {
        }
        if (valuePosition < frameStart) {
            this.recordedNullPosition = frameStart;
            output.appendNull();
            return;
        }
        this.recordedValuePosition = valuePosition;
        this.windowIndex.appendTo(this.argumentChannel, valuePosition, output);
    }
}

