/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.SecurityContext;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface AccessControl {
    @Deprecated
    public void checkCanSetUser(Optional<Principal> var1, String var2);

    public void checkCanImpersonateUser(Identity var1, String var2);

    public void checkCanReadSystemInformation(Identity var1);

    public void checkCanWriteSystemInformation(Identity var1);

    public void checkCanExecuteQuery(Identity var1, QueryId var2);

    public void checkCanViewQueryOwnedBy(Identity var1, Identity var2);

    public Collection<Identity> filterQueriesOwnedBy(Identity var1, Collection<Identity> var2);

    public void checkCanKillQueryOwnedBy(Identity var1, Identity var2);

    public void checkCanCreateCatalog(SecurityContext var1, String var2);

    public void checkCanDropCatalog(SecurityContext var1, String var2);

    public Set<String> filterCatalogs(SecurityContext var1, Set<String> var2);

    public void checkCanCreateSchema(SecurityContext var1, CatalogSchemaName var2, Map<String, Object> var3);

    public void checkCanDropSchema(SecurityContext var1, CatalogSchemaName var2);

    public void checkCanRenameSchema(SecurityContext var1, CatalogSchemaName var2, String var3);

    public void checkCanSetSchemaAuthorization(SecurityContext var1, CatalogSchemaName var2, TrinoPrincipal var3);

    public void checkCanShowSchemas(SecurityContext var1, String var2);

    public Set<String> filterSchemas(SecurityContext var1, String var2, Set<String> var3);

    public void checkCanShowCreateSchema(SecurityContext var1, CatalogSchemaName var2);

    public void checkCanShowCreateTable(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanCreateTable(SecurityContext var1, QualifiedObjectName var2, Map<String, Object> var3);

    public void checkCanDropTable(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanRenameTable(SecurityContext var1, QualifiedObjectName var2, QualifiedObjectName var3);

    public void checkCanSetTableProperties(SecurityContext var1, QualifiedObjectName var2, Map<String, Optional<Object>> var3);

    public void checkCanSetTableComment(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanSetViewComment(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanSetColumnComment(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanShowTables(SecurityContext var1, CatalogSchemaName var2);

    public Set<SchemaTableName> filterTables(SecurityContext var1, String var2, Set<SchemaTableName> var3);

    public void checkCanShowColumns(SecurityContext var1, CatalogSchemaTableName var2);

    public Map<SchemaTableName, Set<String>> filterColumns(SecurityContext var1, String var2, Map<SchemaTableName, Set<String>> var3);

    public void checkCanAddColumns(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanDropColumn(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanAlterColumn(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanSetTableAuthorization(SecurityContext var1, QualifiedObjectName var2, TrinoPrincipal var3);

    public void checkCanRenameColumn(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanInsertIntoTable(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanDeleteFromTable(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanTruncateTable(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanUpdateTableColumns(SecurityContext var1, QualifiedObjectName var2, Set<String> var3);

    public void checkCanCreateView(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanRenameView(SecurityContext var1, QualifiedObjectName var2, QualifiedObjectName var3);

    default public void checkCanSetViewAuthorization(SecurityContext context, QualifiedObjectName view, TrinoPrincipal principal) {
        AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
    }

    public void checkCanDropView(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanCreateViewWithSelectFromColumns(SecurityContext var1, QualifiedObjectName var2, Set<String> var3);

    public void checkCanCreateMaterializedView(SecurityContext var1, QualifiedObjectName var2, Map<String, Object> var3);

    public void checkCanRefreshMaterializedView(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanDropMaterializedView(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanRenameMaterializedView(SecurityContext var1, QualifiedObjectName var2, QualifiedObjectName var3);

    public void checkCanSetMaterializedViewProperties(SecurityContext var1, QualifiedObjectName var2, Map<String, Optional<Object>> var3);

    public void checkCanGrantSchemaPrivilege(SecurityContext var1, Privilege var2, CatalogSchemaName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanDenySchemaPrivilege(SecurityContext var1, Privilege var2, CatalogSchemaName var3, TrinoPrincipal var4);

    public void checkCanRevokeSchemaPrivilege(SecurityContext var1, Privilege var2, CatalogSchemaName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanGrantTablePrivilege(SecurityContext var1, Privilege var2, QualifiedObjectName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanDenyTablePrivilege(SecurityContext var1, Privilege var2, QualifiedObjectName var3, TrinoPrincipal var4);

    public void checkCanRevokeTablePrivilege(SecurityContext var1, Privilege var2, QualifiedObjectName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanGrantEntityPrivilege(SecurityContext var1, EntityPrivilege var2, EntityKindAndName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanDenyEntityPrivilege(SecurityContext var1, EntityPrivilege var2, EntityKindAndName var3, TrinoPrincipal var4);

    public void checkCanRevokeEntityPrivilege(SecurityContext var1, EntityPrivilege var2, EntityKindAndName var3, TrinoPrincipal var4, boolean var5);

    public void checkCanSetSystemSessionProperty(Identity var1, QueryId var2, String var3);

    public void checkCanSetCatalogSessionProperty(SecurityContext var1, String var2, String var3);

    public void checkCanSelectFromColumns(SecurityContext var1, QualifiedObjectName var2, Set<String> var3);

    public void checkCanCreateRole(SecurityContext var1, String var2, Optional<TrinoPrincipal> var3, Optional<String> var4);

    public void checkCanDropRole(SecurityContext var1, String var2, Optional<String> var3);

    public void checkCanGrantRoles(SecurityContext var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5, Optional<String> var6);

    public void checkCanRevokeRoles(SecurityContext var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5, Optional<String> var6);

    public void checkCanSetCatalogRole(SecurityContext var1, String var2, String var3);

    public void checkCanShowRoles(SecurityContext var1, Optional<String> var2);

    public void checkCanShowCurrentRoles(SecurityContext var1, Optional<String> var2);

    public void checkCanShowRoleGrants(SecurityContext var1, Optional<String> var2);

    public void checkCanExecuteProcedure(SecurityContext var1, QualifiedObjectName var2);

    public boolean canExecuteFunction(SecurityContext var1, QualifiedObjectName var2);

    public boolean canCreateViewWithExecuteFunction(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanExecuteTableProcedure(SecurityContext var1, QualifiedObjectName var2, String var3);

    public void checkCanShowFunctions(SecurityContext var1, CatalogSchemaName var2);

    public Set<SchemaFunctionName> filterFunctions(SecurityContext var1, String var2, Set<SchemaFunctionName> var3);

    public void checkCanCreateFunction(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanDropFunction(SecurityContext var1, QualifiedObjectName var2);

    public void checkCanShowCreateFunction(SecurityContext var1, QualifiedObjectName var2);

    default public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return ImmutableList.of();
    }

    default public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return Optional.empty();
    }
}

