/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.trino.operator.ForExchange;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ExchangeExecutionMBean {
    private final ThreadPoolExecutorMBean executorMBean;

    @Inject
    public ExchangeExecutionMBean(@ForExchange ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor is null");
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)executor));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }
}

