/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record OrderingScheme(List<Symbol> orderBy, Map<Symbol, SortOrder> orderings) {
    public OrderingScheme {
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(orderings, "orderings is null");
        Preconditions.checkArgument((!orderBy.isEmpty() ? 1 : 0) != 0, (Object)"orderBy is empty");
        Preconditions.checkArgument((boolean)orderings.keySet().equals(ImmutableSet.copyOf(orderBy)), (Object)"orderBy keys and orderings don't match");
        orderBy = ImmutableList.copyOf(orderBy);
        orderings = ImmutableMap.copyOf(orderings);
    }

    public List<SortOrder> orderingList() {
        return (List)this.orderBy.stream().map(this.orderings::get).collect(ImmutableList.toImmutableList());
    }

    public SortOrder ordering(Symbol symbol) {
        Preconditions.checkArgument((boolean)this.orderings.containsKey(symbol), (String)"No ordering for symbol: %s", (Object)symbol);
        return this.orderings.get(symbol);
    }

    public List<SortItem> toSortItems() {
        return (List)this.orderBy().stream().map(symbol -> new SortItem(symbol.name(), SortOrder.valueOf((String)this.ordering((Symbol)symbol).name()))).collect(ImmutableList.toImmutableList());
    }

    public List<LocalProperty<Symbol>> toLocalProperties() {
        return (List)this.orderBy().stream().map(symbol -> new SortingProperty(symbol, this.ordering((Symbol)symbol))).collect(ImmutableList.toImmutableList());
    }
}

