/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.HashMap;
import java.util.Objects;

public class NoDuplicatePlanNodeIdsChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        HashMap planNodeIds = new HashMap();
        PlanNodeSearcher.searchFrom(planNode).findAll().forEach(node -> planNodeIds.merge(node.getId(), node, this::reportDuplicateId));
    }

    private PlanNode reportDuplicateId(PlanNode first, PlanNode second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        Preconditions.checkArgument((boolean)first.getId().equals(second.getId()));
        throw new IllegalStateException(String.format("Generated plan contains nodes with duplicated id %s: %s and %s", first.getId(), first, second));
    }
}

