/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.StandardFunctionResolution;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.type.TypeCoercion;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, Map<Symbol, Integer> layout, Metadata metadata, TypeManager typeManager) {
        Visitor visitor = new Visitor(metadata, typeManager, layout);
        RowExpression result = (RowExpression)visitor.process(expression, null);
        Objects.requireNonNull(result, "result is null");
        return result;
    }

    public static class Visitor
    extends IrVisitor<RowExpression, Void> {
        private final Metadata metadata;
        private final TypeCoercion typeCoercion;
        private final Map<Symbol, Integer> layout;
        private final StandardFunctionResolution standardFunctionResolution;

        protected Visitor(Metadata metadata, TypeManager typeManager, Map<Symbol, Integer> layout) {
            this.metadata = metadata;
            this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
            this.layout = layout;
            this.standardFunctionResolution = new StandardFunctionResolution(metadata);
        }

        @Override
        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        @Override
        protected RowExpression visitConstant(Constant node, Void context) {
            return Expressions.constant(node.value(), node.type());
        }

        @Override
        protected RowExpression visitComparison(Comparison node, Void context) {
            RowExpression left = (RowExpression)this.process(node.left(), context);
            RowExpression right = (RowExpression)this.process(node.right(), context);
            Comparison.Operator operator = node.operator();
            return switch (node.operator()) {
                case Comparison.Operator.NOT_EQUAL -> new CallExpression(this.metadata.resolveBuiltinFunction("$not", TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN})), (List<RowExpression>)ImmutableList.of((Object)this.visitComparisonExpression(Comparison.Operator.EQUAL, left, right)));
                case Comparison.Operator.GREATER_THAN -> this.visitComparisonExpression(Comparison.Operator.LESS_THAN, right, left);
                case Comparison.Operator.GREATER_THAN_OR_EQUAL -> this.visitComparisonExpression(Comparison.Operator.LESS_THAN_OR_EQUAL, right, left);
                default -> this.visitComparisonExpression(operator, left, right);
            };
        }

        private RowExpression visitComparisonExpression(Comparison.Operator operator, RowExpression left, RowExpression right) {
            return Expressions.call(this.standardFunctionResolution.comparisonFunction(operator, left.type(), right.type()), left, right);
        }

        @Override
        protected RowExpression visitCall(Call node, Void context) {
            List arguments = (List)node.arguments().stream().map(value -> (RowExpression)this.process((Expression)value, context)).collect(ImmutableList.toImmutableList());
            return new CallExpression(node.function(), arguments);
        }

        @Override
        protected RowExpression visitReference(Reference node, Void context) {
            Integer field = this.layout.get(Symbol.from(node));
            if (field != null) {
                return Expressions.field(field, node.type());
            }
            return new VariableReferenceExpression(node.name(), node.type());
        }

        @Override
        protected RowExpression visitLambda(Lambda node, Void context) {
            return new LambdaDefinitionExpression(node.arguments(), (RowExpression)this.process(node.body(), context));
        }

        @Override
        protected RowExpression visitBind(Bind node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.values()) {
                RowExpression valueRowExpression = (RowExpression)this.process(value, context);
                valueTypesBuilder.add((Object)valueRowExpression.type());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process(node.function(), context);
            argumentsBuilder.add((Object)function);
            return new SpecialForm(SpecialForm.Form.BIND, node.type(), (List<RowExpression>)argumentsBuilder.build(), (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitLogical(Logical node, Void context) {
            SpecialForm.Form form = switch (node.operator()) {
                default -> throw new MatchException(null, null);
                case Logical.Operator.AND -> SpecialForm.Form.AND;
                case Logical.Operator.OR -> SpecialForm.Form.OR;
            };
            return new SpecialForm(form, (Type)BooleanType.BOOLEAN, (List)node.terms().stream().map(term -> (RowExpression)this.process((Expression)term, context)).collect(ImmutableList.toImmutableList()), (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process(node.expression(), context);
            Type returnType = node.type();
            if (this.typeCoercion.isTypeOnlyCoercion(value.type(), returnType)) {
                return Visitor.changeType(value, returnType);
            }
            return Expressions.call(this.metadata.getCoercion(value.type(), returnType), value);
        }

        private static RowExpression changeType(RowExpression value, Type targetType) {
            ChangeTypeVisitor visitor = new ChangeTypeVisitor(targetType);
            return value.accept(visitor, null);
        }

        @Override
        protected RowExpression visitCoalesce(Coalesce node, Void context) {
            List arguments = (List)node.operands().stream().map(value -> (RowExpression)this.process((Expression)value, context)).collect(ImmutableList.toImmutableList());
            return new SpecialForm(SpecialForm.Form.COALESCE, node.type(), arguments, (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitSwitch(Switch node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            RowExpression value = (RowExpression)this.process(node.operand(), context);
            arguments.add((Object)value);
            ImmutableList.Builder functionDependencies = ImmutableList.builder();
            for (WhenClause clause : node.whenClauses()) {
                RowExpression operand = (RowExpression)this.process(clause.getOperand(), context);
                RowExpression result = (RowExpression)this.process(clause.getResult(), context);
                functionDependencies.add((Object)this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.type(), (Object)operand.type())));
                arguments.add((Object)new SpecialForm(SpecialForm.Form.WHEN, clause.getResult().type(), (List<RowExpression>)ImmutableList.of((Object)operand, (Object)result), (List<ResolvedFunction>)ImmutableList.of()));
            }
            Type returnType = node.type();
            arguments.add((Object)((RowExpression)this.process(node.defaultValue(), context)));
            return new SpecialForm(SpecialForm.Form.SWITCH, returnType, (List<RowExpression>)arguments.build(), (List<ResolvedFunction>)functionDependencies.build());
        }

        @Override
        protected RowExpression visitCase(Case node, Void context) {
            RowExpression expression = (RowExpression)this.process(node.defaultValue(), context);
            for (WhenClause clause : node.whenClauses().reversed()) {
                expression = new SpecialForm(SpecialForm.Form.IF, node.type(), (List<RowExpression>)ImmutableList.of((Object)((RowExpression)this.process(clause.getOperand(), context)), (Object)((RowExpression)this.process(clause.getResult(), context)), (Object)expression), (List<ResolvedFunction>)ImmutableList.of());
            }
            return expression;
        }

        @Override
        protected RowExpression visitIn(In node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            RowExpression value = (RowExpression)this.process(node.value(), context);
            arguments.add((Object)value);
            for (Expression testValue : node.valueList()) {
                arguments.add((Object)((RowExpression)this.process(testValue, context)));
            }
            ImmutableList functionDependencies = ImmutableList.builder().add((Object)this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.type(), (Object)value.type()))).add((Object)this.metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)value.type()))).add((Object)this.metadata.resolveOperator(OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)value.type()))).build();
            return new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build(), (List<ResolvedFunction>)functionDependencies);
        }

        @Override
        protected RowExpression visitIsNull(IsNull node, Void context) {
            RowExpression expression = (RowExpression)this.process(node.value(), context);
            return new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression), (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitNullIf(NullIf node, Void context) {
            RowExpression first = (RowExpression)this.process(node.first(), context);
            RowExpression second = (RowExpression)this.process(node.second(), context);
            ResolvedFunction resolvedFunction = this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)first.type(), (Object)second.type()));
            ImmutableList functionDependencies = ImmutableList.builder().add((Object)resolvedFunction).add((Object)this.metadata.getCoercion(first.type(), (Type)resolvedFunction.signature().getArgumentTypes().get(0))).add((Object)this.metadata.getCoercion(second.type(), (Type)resolvedFunction.signature().getArgumentTypes().get(0))).build();
            return new SpecialForm(SpecialForm.Form.NULL_IF, node.type(), (List<RowExpression>)ImmutableList.of((Object)first, (Object)second), (List<ResolvedFunction>)functionDependencies);
        }

        @Override
        protected RowExpression visitBetween(Between node, Void context) {
            RowExpression value = (RowExpression)this.process(node.value(), context);
            RowExpression min = (RowExpression)this.process(node.min(), context);
            RowExpression max = (RowExpression)this.process(node.max(), context);
            ImmutableList functionDependencies = ImmutableList.of((Object)this.metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.type(), (Object)max.type())));
            return new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)value, (Object)min, (Object)max), (List<ResolvedFunction>)functionDependencies);
        }

        @Override
        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            RowExpression base = (RowExpression)this.process(node.base(), context);
            return new SpecialForm(SpecialForm.Form.DEREFERENCE, node.type(), (List<RowExpression>)ImmutableList.of((Object)base, (Object)Expressions.constant(node.field(), (Type)IntegerType.INTEGER)), (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.items().stream().map(value -> (RowExpression)this.process((Expression)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = node.type();
            return new SpecialForm(SpecialForm.Form.ROW_CONSTRUCTOR, returnType, arguments, (List<ResolvedFunction>)ImmutableList.of());
        }

        @Override
        protected RowExpression visitArray(Array node, Void context) {
            return new SpecialForm(SpecialForm.Form.ARRAY_CONSTRUCTOR, node.type(), (List)node.elements().stream().map(value -> (RowExpression)this.process((Expression)value, context)).collect(ImmutableList.toImmutableList()), (List<ResolvedFunction>)ImmutableList.of());
        }

        private static class ChangeTypeVisitor
        implements RowExpressionVisitor<RowExpression, Void> {
            private final Type targetType;

            private ChangeTypeVisitor(Type targetType) {
                this.targetType = targetType;
            }

            @Override
            public RowExpression visitCall(CallExpression call, Void context) {
                return new CallExpression(call.resolvedFunction(), call.arguments());
            }

            @Override
            public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
                return new SpecialForm(specialForm.form(), this.targetType, specialForm.arguments(), specialForm.functionDependencies());
            }

            @Override
            public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
                return Expressions.field(reference.field(), this.targetType);
            }

            @Override
            public RowExpression visitConstant(ConstantExpression literal, Void context) {
                return Expressions.constant(literal.value(), this.targetType);
            }

            @Override
            public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
                return new VariableReferenceExpression(reference.name(), this.targetType);
            }
        }
    }
}

