/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Preconditions;
import io.trino.client.IntervalDayTime;
import io.trino.client.IntervalYearMonth;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.util.DateTimeZoneIndex;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.util.VisibleForTesting;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;

public final class DateTimeUtils {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date().withZoneUTC();
    private static final DateTimeFormatter TIMESTAMP_WITH_OR_WITHOUT_TIME_ZONE_FORMATTER;
    private static final int YEAR_FIELD = 0;
    private static final int MONTH_FIELD = 1;
    private static final int DAY_FIELD = 3;
    private static final int HOUR_FIELD = 4;
    private static final int MINUTE_FIELD = 5;
    private static final int SECOND_FIELD = 6;
    private static final int MILLIS_FIELD = 7;
    private static final PeriodFormatter INTERVAL_DAY_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_HOUR_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_FORMATTER;
    private static final PeriodFormatter INTERVAL_MINUTE_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_YEAR_MONTH_FORMATTER;
    private static final PeriodFormatter INTERVAL_YEAR_FORMATTER;
    private static final PeriodFormatter INTERVAL_MONTH_FORMATTER;

    private DateTimeUtils() {
    }

    public static int parseDate(String value) {
        OptionalInt days = DateTimeUtils.parseIfIso8601DateFormat(value);
        if (days.isPresent()) {
            return days.getAsInt();
        }
        return Math.toIntExact(TimeUnit.MILLISECONDS.toDays(DATE_FORMATTER.parseMillis(value)));
    }

    @VisibleForTesting
    static OptionalInt parseIfIso8601DateFormat(String value) {
        if (value.length() != 10 || value.charAt(4) != '-' || value.charAt(7) != '-') {
            return OptionalInt.empty();
        }
        OptionalInt year = DateTimeUtils.parseIntSimple(value, 0, 4);
        if (year.isEmpty()) {
            return OptionalInt.empty();
        }
        OptionalInt month = DateTimeUtils.parseIntSimple(value, 5, 2);
        if (month.isEmpty()) {
            return OptionalInt.empty();
        }
        OptionalInt day = DateTimeUtils.parseIntSimple(value, 8, 2);
        if (day.isEmpty()) {
            return OptionalInt.empty();
        }
        LocalDate date = LocalDate.of(year.getAsInt(), month.getAsInt(), day.getAsInt());
        return OptionalInt.of(Math.toIntExact(date.toEpochDay()));
    }

    private static OptionalInt parseIntSimple(String input, int offset, int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String)"Invalid length %s", (int)length);
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int digit = input.charAt(offset + i) - 48;
            if (digit < 0 || digit > 9) {
                return OptionalInt.empty();
            }
            result = result * 10 + digit;
        }
        return OptionalInt.of(result);
    }

    public static String printDate(int days) {
        return DATE_FORMATTER.print(TimeUnit.DAYS.toMillis(days));
    }

    public static long convertToTimestampWithTimeZone(TimeZoneKey timeZoneKey, String timestampWithTimeZone) {
        DateTime dateTime = TIMESTAMP_WITH_OR_WITHOUT_TIME_ZONE_FORMATTER.withChronology((Chronology)DateTimeZoneIndex.getChronology(timeZoneKey)).withOffsetParsed().parseDateTime(timestampWithTimeZone);
        return DateTimeZoneIndex.packDateTimeWithZone(dateTime);
    }

    public static long parseDayTimeInterval(String value, IntervalLiteral.IntervalField startField, Optional<IntervalLiteral.IntervalField> endField) {
        IntervalLiteral.IntervalField end = endField.orElse(startField);
        try {
            if (startField == IntervalLiteral.IntervalField.DAY && end == IntervalLiteral.IntervalField.SECOND) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_SECOND_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.DAY && end == IntervalLiteral.IntervalField.MINUTE) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_MINUTE_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.DAY && end == IntervalLiteral.IntervalField.HOUR) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_HOUR_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.DAY && end == IntervalLiteral.IntervalField.DAY) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.HOUR && end == IntervalLiteral.IntervalField.SECOND) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_SECOND_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.HOUR && end == IntervalLiteral.IntervalField.MINUTE) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_MINUTE_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.HOUR && end == IntervalLiteral.IntervalField.HOUR) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.MINUTE && end == IntervalLiteral.IntervalField.SECOND) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_MINUTE_SECOND_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.MINUTE && end == IntervalLiteral.IntervalField.MINUTE) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_MINUTE_FORMATTER, value);
            }
            if (startField == IntervalLiteral.IntervalField.SECOND && end == IntervalLiteral.IntervalField.SECOND) {
                return DateTimeUtils.parsePeriodMillis(INTERVAL_SECOND_FORMATTER, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw DateTimeUtils.invalidInterval(e, value, startField, end);
        }
        throw new IllegalArgumentException("Invalid day second interval qualifier: " + String.valueOf(startField) + " to " + String.valueOf(end));
    }

    private static long parsePeriodMillis(PeriodFormatter periodFormatter, String value) {
        Period period = DateTimeUtils.parsePeriod(periodFormatter, value);
        return IntervalDayTime.toMillis((long)period.getValue(3), (long)period.getValue(4), (long)period.getValue(5), (long)period.getValue(6), (long)period.getValue(7));
    }

    public static long parseYearMonthInterval(String value, IntervalLiteral.IntervalField startField, Optional<IntervalLiteral.IntervalField> endField) {
        IntervalLiteral.IntervalField end = endField.orElse(startField);
        try {
            if (startField == IntervalLiteral.IntervalField.YEAR && end == IntervalLiteral.IntervalField.MONTH) {
                return DateTimeUtils.parsePeriodMonths(value, INTERVAL_YEAR_MONTH_FORMATTER);
            }
            if (startField == IntervalLiteral.IntervalField.YEAR && end == IntervalLiteral.IntervalField.YEAR) {
                return DateTimeUtils.parsePeriodMonths(value, INTERVAL_YEAR_FORMATTER);
            }
            if (startField == IntervalLiteral.IntervalField.MONTH && end == IntervalLiteral.IntervalField.MONTH) {
                return DateTimeUtils.parsePeriodMonths(value, INTERVAL_MONTH_FORMATTER);
            }
        }
        catch (IllegalArgumentException e) {
            throw DateTimeUtils.invalidInterval(e, value, startField, end);
        }
        throw new IllegalArgumentException("Invalid year month interval qualifier: " + String.valueOf(startField) + " to " + String.valueOf(end));
    }

    private static long parsePeriodMonths(String value, PeriodFormatter periodFormatter) {
        Period period = DateTimeUtils.parsePeriod(periodFormatter, value);
        return IntervalYearMonth.toMonths((int)period.getValue(0), (int)period.getValue(1));
    }

    private static Period parsePeriod(PeriodFormatter periodFormatter, String value) {
        boolean negative = value.startsWith("-");
        if (negative) {
            value = value.substring(1);
        }
        Period period = periodFormatter.parsePeriod(value);
        for (DurationFieldType type : period.getFieldTypes()) {
            Preconditions.checkArgument((period.get(type) >= 0 ? 1 : 0) != 0, (String)"Period field %s is negative", (Object)type);
        }
        if (negative) {
            period = period.negated();
        }
        return period;
    }

    private static TrinoException invalidInterval(Throwable throwable, String value, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        String message = startField == endField ? String.format("Invalid INTERVAL %s value: %s", startField, value) : String.format("Invalid INTERVAL %s TO %s value: %s", startField, endField, value);
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, message, throwable);
    }

    private static PeriodFormatter cretePeriodFormatter(IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        if (endField == null) {
            endField = startField;
        }
        ArrayList<PeriodParser> parsers = new ArrayList<PeriodParser>();
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        switch (startField) {
            case YEAR: {
                builder.appendYears();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.YEAR) break;
                builder.appendLiteral("-");
            }
            case MONTH: {
                builder.appendMonths();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.MONTH) break;
                throw new IllegalArgumentException("Invalid interval qualifier: " + String.valueOf(startField) + " to " + String.valueOf(endField));
            }
            case DAY: {
                builder.appendDays();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.DAY) break;
                builder.appendLiteral(" ");
            }
            case HOUR: {
                builder.appendHours();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.HOUR) break;
                builder.appendLiteral(":");
            }
            case MINUTE: {
                builder.appendMinutes();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.MINUTE) break;
                builder.appendLiteral(":");
            }
            case SECOND: {
                builder.appendSecondsWithOptionalMillis();
                parsers.add(builder.toParser());
            }
        }
        return new PeriodFormatter(builder.toPrinter(), (PeriodParser)new OrderedPeriodParser(parsers));
    }

    static {
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s.SSS").getParser()};
        DateTimeParser[] timestampWithTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyyyy-M-dZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d Z").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:mZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m Z").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:sZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s Z").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s.SSS Z").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-dZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:mZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:sZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s.SSSZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyyyy-M-d H:m:s.SSS ZZZ").getParser()};
        DateTimePrinter timestampWithTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS ZZZ").getPrinter();
        DateTimeParser[] timestampWithOrWithoutTimeZoneParser = (DateTimeParser[])Stream.concat(Stream.of(timestampWithoutTimeZoneParser), Stream.of(timestampWithTimeZoneParser)).toArray(DateTimeParser[]::new);
        TIMESTAMP_WITH_OR_WITHOUT_TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().append(timestampWithTimeZonePrinter, timestampWithOrWithoutTimeZoneParser).toFormatter().withOffsetParsed();
        INTERVAL_DAY_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_DAY_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_DAY_HOUR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.HOUR);
        INTERVAL_DAY_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.DAY);
        INTERVAL_HOUR_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_HOUR_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_HOUR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.HOUR);
        INTERVAL_MINUTE_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MINUTE, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MINUTE, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.SECOND, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_YEAR_MONTH_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.YEAR, IntervalLiteral.IntervalField.MONTH);
        INTERVAL_YEAR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.YEAR, IntervalLiteral.IntervalField.YEAR);
        INTERVAL_MONTH_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MONTH, IntervalLiteral.IntervalField.MONTH);
    }

    private static class OrderedPeriodParser
    implements PeriodParser {
        private final List<PeriodParser> parsers;

        private OrderedPeriodParser(List<PeriodParser> parsers) {
            this.parsers = parsers;
        }

        public int parseInto(ReadWritablePeriod period, String text, int position, Locale locale) {
            int bestValidPos = position;
            MutablePeriod bestValidPeriod = null;
            int bestInvalidPos = position;
            for (PeriodParser parser : this.parsers) {
                MutablePeriod parsedPeriod;
                int parsePos = parser.parseInto((ReadWritablePeriod)(parsedPeriod = new MutablePeriod()), text, position, locale);
                if (parsePos >= position) {
                    if (parsePos <= bestValidPos) continue;
                    bestValidPos = parsePos;
                    bestValidPeriod = parsedPeriod;
                    if (parsePos < text.length()) continue;
                    break;
                }
                if (parsePos >= 0 || (parsePos ^= 0xFFFFFFFF) <= bestInvalidPos) continue;
                bestInvalidPos = parsePos;
            }
            if (bestValidPos > position || bestValidPos == position) {
                if (bestValidPeriod != null) {
                    period.setPeriod(bestValidPeriod);
                }
                return bestValidPos;
            }
            return ~bestInvalidPos;
        }
    }
}

