/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.PlanNodeStatsEstimateMath;
import io.trino.cost.StatisticRange;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.type.UnknownType;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPlanNodeStatsEstimateMath {
    private static final Symbol SYMBOL = new Symbol((Type)UnknownType.UNKNOWN, "symbol");
    private static final StatisticRange NON_EMPTY_RANGE = TestPlanNodeStatsEstimateMath.openRange(1.0);

    @Test
    public void testAddRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, StatisticRange.empty());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)unknownStats)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownStats)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)second)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount()).isEqualTo(30.0);
    }

    @Test
    public void testAddNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, 0.3, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(unknownNullsFraction, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(unknownRowCount, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(first, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(unknownRowCount, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(first, second).isEqualTo(0.16666666666666666);
        TestPlanNodeStatsEstimateMath.assertThatAddNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond).isEqualTo(0.2333333333333333);
    }

    private static AbstractDoubleAssert<?> assertThatAddNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getNullsFraction());
    }

    @Test
    public void testAddAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 0.1, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(10.0, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, 0.1, 15.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, 0.2, 20.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, 0.1, 0.3, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, 0.3, 0.4, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(unknownNullsFraction, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(unknownAverageRowSize, unknownAverageRowSize).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(first, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(unknownNullsFraction, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(first, unknownAverageRowSize).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(first, second).isEqualTo(18.2);
        TestPlanNodeStatsEstimateMath.assertThatAddAverageRowSize(fractionalRowCountFirst, fractionalRowCountSecond).isEqualTo(0.3608695652173913);
    }

    private static AbstractDoubleAssert<?> assertThatAddAverageRowSize(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getAverageRowSize());
    }

    @Test
    public void testSumNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertThatSumNumberOfDistinctValues(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSumNumberOfDistinctValues(unknownRowCount, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSumNumberOfDistinctValues(first, emptyRange).isEqualTo(2.0);
        TestPlanNodeStatsEstimateMath.assertThatSumNumberOfDistinctValues(first, unknownRange).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSumNumberOfDistinctValues(first, second).isEqualTo(5.0);
    }

    private static AbstractDoubleAssert<?> assertThatSumNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.addStatsAndSumDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getDistinctValuesCount());
    }

    @Test
    public void testMaxNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertThatMaxNumberOfDistinctValues(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatMaxNumberOfDistinctValues(unknownRowCount, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatMaxNumberOfDistinctValues(first, emptyRange).isEqualTo(2.0);
        TestPlanNodeStatsEstimateMath.assertThatMaxNumberOfDistinctValues(first, unknownRange).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatMaxNumberOfDistinctValues(first, second).isEqualTo(3.0);
    }

    private static AbstractDoubleAssert<?> assertThatMaxNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getDistinctValuesCount());
    }

    @Test
    public void testAddRange() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, 2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, new StatisticRange(101.0, 200.0, 3.0));
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRange, unknownRange, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRowCount, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(unknownRange, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertAddRange(emptyRange, second, 101.0, 200.0);
        TestPlanNodeStatsEstimateMath.assertAddRange(first, second, 12.0, 200.0);
    }

    private static void assertAddRange(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expectedLow, double expectedHigh) {
        SymbolStatsEstimate statistics = PlanNodeStatsEstimateMath.addStatsAndMaxDistinctValues((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL);
        Assertions.assertThat((double)statistics.getLowValue()).isEqualTo(expectedLow);
        Assertions.assertThat((double)statistics.getHighValue()).isEqualTo(expectedHigh);
    }

    @Test
    public void testSubtractRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(40.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)unknownStats)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownStats)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((Object)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)unknownStats, (PlanNodeStatsEstimate)second)).isEqualTo((Object)PlanNodeStatsEstimate.unknown());
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount()).isEqualTo(30.0);
    }

    @Test
    public void testSubtractNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(50.0, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.7, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, 0.3, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(unknownRowCount, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(first, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(unknownRowCount, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(first, second).isEqualTo(0.03333333333333333);
        TestPlanNodeStatsEstimateMath.assertThatSubtractNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond).isEqualTo(0.019999999999999993);
    }

    private static AbstractDoubleAssert<?> assertThatSubtractNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getNullsFraction());
    }

    @Test
    public void testSubtractNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownDistinctValues = TestPlanNodeStatsEstimateMath.statistics(100.0, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate zero = TestPlanNodeStatsEstimateMath.statistics(0.0, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(0.0));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(10.0, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(unknownRowCount, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(unknownDistinctValues, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(first, zero).isEqualTo(10.0);
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(zero, zero).isEqualTo(0.0);
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(first, second).isEqualTo(5.0);
        TestPlanNodeStatsEstimateMath.assertThatSubtractNumberOfDistinctValues(second, third).isEqualTo(5.0);
    }

    private static AbstractDoubleAssert<?> assertThatSubtractNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL).getDistinctValuesCount());
    }

    @Test
    public void testSubtractRange() {
        TestPlanNodeStatsEstimateMath.assertSubtractRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 1.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(Double.NaN, Double.NaN, 0.0, 1.0, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 1.0, Double.NaN, Double.NaN, 0.0, 1.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 0.0, 1.0, 0.0, 2.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 1.0, 2.0, 0.0, 2.0);
        TestPlanNodeStatsEstimateMath.assertSubtractRange(0.0, 2.0, 0.5, 1.0, 0.0, 2.0);
    }

    private static void assertSubtractRange(double supersetLow, double supersetHigh, double subsetLow, double subsetHigh, double expectedLow, double expectedHigh) {
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, Double.NaN, Double.NaN, new StatisticRange(supersetLow, supersetHigh, 10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, new StatisticRange(subsetLow, subsetHigh, 5.0));
        SymbolStatsEstimate statistics = PlanNodeStatsEstimateMath.subtractSubsetStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getSymbolStatistics(SYMBOL);
        Assertions.assertThat((double)statistics.getLowValue()).isEqualByComparingTo((Comparable)Double.valueOf(expectedLow));
        Assertions.assertThat((double)statistics.getHighValue()).isEqualByComparingTo((Comparable)Double.valueOf(expectedHigh));
    }

    @Test
    public void testCapRowCount() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)unknownRowCount, (PlanNodeStatsEstimate)unknownRowCount).getOutputRowCount()).isNaN();
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)unknownRowCount).getOutputRowCount()).isNaN();
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)unknownRowCount, (PlanNodeStatsEstimate)second).getOutputRowCount()).isNaN();
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)first, (PlanNodeStatsEstimate)second).getOutputRowCount()).isEqualTo(10.0);
        Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)second, (PlanNodeStatsEstimate)first).getOutputRowCount()).isEqualTo(10.0);
    }

    @Test
    public void testCapAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 5.0, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertThatcapAverageRowSize(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapAverageRowSize(unknownAverageRowSize, unknownAverageRowSize).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapAverageRowSize(first, unknownAverageRowSize).isEqualTo(10.0);
        TestPlanNodeStatsEstimateMath.assertThatcapAverageRowSize(unknownAverageRowSize, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapAverageRowSize(first, second).isEqualTo(10.0);
    }

    private static AbstractDoubleAssert<?> assertThatcapAverageRowSize(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getSymbolStatistics(SYMBOL).getAverageRowSize());
    }

    @Test
    public void testCapNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNumberOfDistinctValues = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        TestPlanNodeStatsEstimateMath.assertThatcapNumberOfDistinctValues(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapNumberOfDistinctValues(unknownNumberOfDistinctValues, unknownNumberOfDistinctValues).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapNumberOfDistinctValues(first, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapNumberOfDistinctValues(unknownNumberOfDistinctValues, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatcapNumberOfDistinctValues(first, second).isEqualTo(5.0);
    }

    private static AbstractDoubleAssert<?> assertThatcapNumberOfDistinctValues(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getSymbolStatistics(SYMBOL).getDistinctValuesCount());
    }

    @Test
    public void testCapRange() {
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate openRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, Double.NaN));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, new StatisticRange(13.0, 99.0, Double.NaN));
        TestPlanNodeStatsEstimateMath.assertCapRange(emptyRange, emptyRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(emptyRange, openRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(openRange, emptyRange, Double.NaN, Double.NaN);
        TestPlanNodeStatsEstimateMath.assertCapRange(first, openRange, 12.0, 100.0);
        TestPlanNodeStatsEstimateMath.assertCapRange(openRange, second, 13.0, 99.0);
        TestPlanNodeStatsEstimateMath.assertCapRange(first, second, 13.0, 99.0);
    }

    private static void assertCapRange(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expectedLow, double expectedHigh) {
        SymbolStatsEstimate symbolStats = PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getSymbolStatistics(SYMBOL);
        Assertions.assertThat((double)symbolStats.getLowValue()).isEqualByComparingTo((Comparable)Double.valueOf(expectedLow));
        Assertions.assertThat((double)symbolStats.getHighValue()).isEqualByComparingTo((Comparable)Double.valueOf(expectedHigh));
    }

    @Test
    public void testCapNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, 0.25, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, 0.6, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(0.0, 0.6, Double.NaN, NON_EMPTY_RANGE);
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(unknownRowCount, unknownRowCount).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(unknownNullsFraction, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(first, unknownNullsFraction).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(unknownNullsFraction, second).isNaN();
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(first, second).isEqualTo(0.5);
        TestPlanNodeStatsEstimateMath.assertThatCapNullsFraction(first, third).isEqualTo(1.0);
    }

    private static AbstractDoubleAssert<?> assertThatCapNullsFraction(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap) {
        return Assertions.assertThat((double)PlanNodeStatsEstimateMath.capStats((PlanNodeStatsEstimate)stats, (PlanNodeStatsEstimate)cap).getSymbolStatistics(SYMBOL).getNullsFraction());
    }

    private static PlanNodeStatsEstimate statistics(double rowCount, double nullsFraction, double averageRowSize, StatisticRange range) {
        return PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount).addSymbolStatistics(SYMBOL, SymbolStatsEstimate.builder().setNullsFraction(nullsFraction).setAverageRowSize(averageRowSize).setStatisticsRange(range).build()).build();
    }

    private static StatisticRange openRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }
}

