/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogManagerConfig;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.failuredetector.FailureDetector;
import io.trino.failuredetector.NoOpFailureDetector;
import io.trino.metadata.AllNodes;
import io.trino.metadata.DiscoveryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.NodeState;
import io.trino.server.InternalCommunicationConfig;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestDiscoveryNodeManager {
    private final NodeInfo nodeInfo = new NodeInfo("test");
    private final InternalCommunicationConfig internalCommunicationConfig = new InternalCommunicationConfig();
    private NodeVersion expectedVersion;
    private Set<InternalNode> activeNodes;
    private Set<InternalNode> inactiveNodes;
    private InternalNode coordinator;
    private InternalNode currentNode;
    private final TrinoNodeServiceSelector selector = new TrinoNodeServiceSelector();
    private HttpClient testHttpClient;

    @BeforeEach
    public void setup() {
        this.testHttpClient = new TestingHttpClient(input -> new TestingResponse(HttpStatus.OK, (ListMultimap)ArrayListMultimap.create(), NodeState.ACTIVE.name().getBytes(StandardCharsets.UTF_8)));
        this.expectedVersion = new NodeVersion("1");
        this.coordinator = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.2.8"), this.expectedVersion, true);
        this.currentNode = new InternalNode(this.nodeInfo.getNodeId(), URI.create("http://192.0.1.1"), this.expectedVersion, false);
        this.activeNodes = ImmutableSet.of((Object)this.currentNode, (Object)new InternalNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.1:8080"), this.expectedVersion, false), (Object)new InternalNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.3"), this.expectedVersion, false), (Object)this.coordinator);
        this.inactiveNodes = ImmutableSet.of((Object)new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.3.9"), NodeVersion.UNKNOWN, false), (Object)new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.4.9"), new NodeVersion("2"), false));
        this.selector.announceNodes(this.activeNodes, this.inactiveNodes);
    }

    @AfterEach
    public void tearDown() {
        this.testHttpClient.close();
        this.testHttpClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllNodes() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion, this.testHttpClient, this.internalCommunicationConfig, new CatalogManagerConfig());
        try {
            AllNodes allNodes = manager.getAllNodes();
            Set connectorNodes = manager.getActiveCatalogNodes(GlobalSystemConnector.CATALOG_HANDLE);
            Assertions.assertThat((int)connectorNodes.size()).isEqualTo(4);
            Assertions.assertThat((boolean)connectorNodes.stream().anyMatch(InternalNode::isCoordinator)).isTrue();
            Set activeNodes = allNodes.getActiveNodes();
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, this.activeNodes);
            for (InternalNode actual : activeNodes) {
                for (InternalNode expected : this.activeNodes) {
                    Assertions.assertThat((Object)actual).isNotSameAs((Object)expected);
                }
            }
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, (Iterable)manager.getNodes(NodeState.ACTIVE));
            Set inactiveNodes = allNodes.getInactiveNodes();
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, this.inactiveNodes);
            for (InternalNode actual : inactiveNodes) {
                for (InternalNode expected : this.inactiveNodes) {
                    Assertions.assertThat((Object)actual).isNotSameAs((Object)expected);
                }
            }
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, (Iterable)manager.getNodes(NodeState.INACTIVE));
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCurrentNode() {
        NodeInfo nodeInfo = new NodeInfo(new NodeConfig().setEnvironment("test").setNodeId(this.currentNode.getNodeIdentifier()));
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion, this.testHttpClient, this.internalCommunicationConfig, new CatalogManagerConfig());
        try {
            Assertions.assertThat((Object)manager.getCurrentNode()).isEqualTo((Object)this.currentNode);
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCoordinators() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion, this.testHttpClient, this.internalCommunicationConfig, new CatalogManagerConfig());
        try {
            Assertions.assertThat((Collection)manager.getCoordinators()).isEqualTo((Object)ImmutableSet.of((Object)this.coordinator));
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCurrentNodeRequired() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DiscoveryNodeManager((ServiceSelector)this.selector, new NodeInfo("test"), (FailureDetector)new NoOpFailureDetector(), this.expectedVersion, this.testHttpClient, this.internalCommunicationConfig, new CatalogManagerConfig())).isInstanceOf(IllegalStateException.class)).hasMessageContaining("current node not returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testNodeChangeListener() throws Exception {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.nodeInfo, (FailureDetector)new NoOpFailureDetector(), this.expectedVersion, this.testHttpClient, this.internalCommunicationConfig, new CatalogManagerConfig());
        try {
            manager.startPollingNodeStates();
            ArrayBlockingQueue notifications = new ArrayBlockingQueue(100);
            manager.addNodeChangeListener(notifications::add);
            AllNodes allNodes = (AllNodes)notifications.take();
            Assertions.assertThat((Collection)allNodes.getActiveNodes()).isEqualTo(this.activeNodes);
            Assertions.assertThat((Collection)allNodes.getInactiveNodes()).isEqualTo(this.inactiveNodes);
            this.selector.announceNodes((Set<InternalNode>)ImmutableSet.of((Object)this.currentNode), (Set<InternalNode>)ImmutableSet.of((Object)this.coordinator));
            allNodes = (AllNodes)notifications.take();
            Assertions.assertThat((Collection)allNodes.getActiveNodes()).isEqualTo((Object)ImmutableSet.of((Object)this.currentNode, (Object)this.coordinator));
            Assertions.assertThat((Collection)allNodes.getActiveCoordinators()).isEqualTo((Object)ImmutableSet.of((Object)this.coordinator));
            this.selector.announceNodes(this.activeNodes, this.inactiveNodes);
            allNodes = (AllNodes)notifications.take();
            Assertions.assertThat((Collection)allNodes.getActiveNodes()).isEqualTo(this.activeNodes);
            Assertions.assertThat((Collection)allNodes.getInactiveNodes()).isEqualTo(this.inactiveNodes);
        }
        finally {
            manager.stop();
        }
    }

    public static class TrinoNodeServiceSelector
    implements ServiceSelector {
        @GuardedBy(value="this")
        private List<ServiceDescriptor> descriptors = ImmutableList.of();

        private synchronized void announceNodes(Set<InternalNode> activeNodes, Set<InternalNode> inactiveNodes) {
            ImmutableList.Builder descriptors = ImmutableList.builder();
            for (InternalNode node : Iterables.concat(activeNodes, inactiveNodes)) {
                descriptors.add((Object)ServiceDescriptor.serviceDescriptor((String)"trino").setNodeId(node.getNodeIdentifier()).addProperty("http", node.getInternalUri().toString()).addProperty("node_version", node.getNodeVersion().toString()).addProperty("coordinator", String.valueOf(node.isCoordinator())).build());
            }
            this.descriptors = descriptors.build();
        }

        public String getType() {
            return "trino";
        }

        public String getPool() {
            return "general";
        }

        public synchronized List<ServiceDescriptor> selectAllServices() {
            return this.descriptors;
        }

        public ListenableFuture<List<ServiceDescriptor>> refresh() {
            throw new UnsupportedOperationException();
        }
    }
}

