/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SetExpressionMatcher;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.optimizations.AddLocalExchanges;
import io.trino.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrQuantified;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.SortItem;
import io.trino.tests.QueryTemplate;
import io.trino.type.Reals;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLogicalPlanner
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction SUBTRACT_BIGINT = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction FAIL = FUNCTIONS.resolveFunction("fail", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}));
    private static final ResolvedFunction LOWER = FUNCTIONS.resolveFunction("lower", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
    private static final ResolvedFunction COMBINE_HASH = FUNCTIONS.resolveFunction("combine_hash", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
    private static final ResolvedFunction HASH_CODE = MetadataManager.createTestMetadataManager().resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)BigintType.BIGINT));
    private static final WindowNode.Frame ROWS_FROM_CURRENT = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());

    @Test
    public void testAnalyze() {
        this.assertDistributedPlan("ANALYZE orders", PlanMatchPattern.anyTree(PlanMatchPattern.node(StatisticsWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of()))))))))));
    }

    @Test
    public void testLikePredicate() {
        this.assertPlan("SELECT type FROM part WHERE type LIKE 'LARGE PLATED %'", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan(tableHandle -> {
            Map domains = (Map)((TpchTableHandle)tableHandle).constraint().getDomains().orElseThrow(() -> new AssertionError((Object)"Unexpected none TupleDomain"));
            Domain domain = (Domain)((Optional)domains.entrySet().stream().filter(entry -> ((TpchColumnHandle)entry.getKey()).columnName().equals("type")).map(Map.Entry::getValue).collect(MoreCollectors.toOptional())).orElseThrow(() -> new AssertionError((Object)"No domain for 'type'"));
            Assertions.assertThat((Object)domain).isEqualTo((Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)25), (List)((List)ImmutableList.of((Object)"LARGE PLATED BRASS", (Object)"LARGE PLATED COPPER", (Object)"LARGE PLATED NICKEL", (Object)"LARGE PLATED STEEL", (Object)"LARGE PLATED TIN").stream().map(Slices::utf8Slice).collect(ImmutableList.toImmutableList()))));
            return true;
        }, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of(tableHandle -> ((TpchColumnHandle)tableHandle).columnName().equals("type"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]), (boolean)false))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of())));
    }

    @Test
    public void testAggregation() {
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"))))))));
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders WHERE orderstatus='O' GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice"))))))));
    }

    @Test
    public void testAllFieldsDereferenceOnSubquery() {
        this.assertPlan("SELECT (SELECT (min(regionkey), max(name)) FROM nation).*", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "row"), 0)), (Object)"output_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "row"), 1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row", (Object)PlanMatchPattern.expression((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "min"), (Object)new Reference((Type)BigintType.BIGINT, "max"))))), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"min", PlanMatchPattern.aggregationFunction("min", (List<String>)ImmutableList.of((Object)"min_regionkey")), (Object)"max", PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"max_name"))), AggregationNode.Step.FINAL, PlanMatchPattern.any(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"min_regionkey", PlanMatchPattern.aggregationFunction("min", (List<String>)ImmutableList.of((Object)"REGIONKEY")), (Object)"max_name", PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"NAME"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name", (Object)"REGIONKEY", (Object)"regionkey")))))))));
    }

    @Test
    public void testAllFieldsDereferenceFromNonDeterministic() {
        Call randomFunction = new Call(this.getPlanTester().getPlannerContext().getMetadata().resolveBuiltinFunction("rand", (List)ImmutableList.of()), (List)ImmutableList.of());
        this.assertPlan("SELECT (x, x).* FROM (SELECT rand()) T(x)", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "row"), 0)), (Object)"output_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "row"), 1))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row", (Object)PlanMatchPattern.expression((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "rand"), (Object)new Reference((Type)DoubleType.DOUBLE, "rand"))))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rand"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)randomFunction)))))));
        this.assertPlan("SELECT (rand(), rand()).* FROM (VALUES 1) t(x)", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "r"), 0)), (Object)"output_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "r"), 1))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))))))));
        this.assertPlan("SELECT (rand(), rand()).* FROM (VALUES 1, 2) t(x) ORDER BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "row"), 0)), (Object)"output_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), "row"), 1))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"row"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))), (Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))))))))));
    }

    @Test
    public void testTrivialFilterOverDuplicateSymbol() {
        this.assertPlan("WITH t AS (SELECT DISTINCT cast(null AS varchar), cast(null AS varchar)) SELECT * FROM t WHERE 1 = 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr", (Object)"expr"), PlanMatchPattern.values("expr")));
        this.assertPlan("SELECT * FROM (SELECT DISTINCT 1, 1) WHERE 1 = 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr", (Object)"expr"), PlanMatchPattern.values("expr")));
    }

    @Test
    public void testDistinctLimitOverInequalityJoin() {
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.LESS_THAN, "L_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY", (Object)"L_ORDERKEY")))))));
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey LIMIT 1", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("O_SHIPPRIORITY", "L_LINENUMBER").filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"))).left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey"))))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY"))))));
    }

    @Test
    public void testDistinctOverConstants() {
        this.assertPlan("SELECT count(*), count(distinct orderstatus) FROM (SELECT * FROM orders WHERE orderstatus = 'F')", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("distinct_aggregations_strategy", "mark_distinct").build(), PlanMatchPattern.anyTree(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"orderstatus"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))))));
    }

    @Test
    public void testInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), Comparison.Operator.LESS_THAN, "L_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_LINENUMBER", "O_SHIPPRIORITY").filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"))).dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)IntegerType.INTEGER, "L_LINENUMBER"), Comparison.Operator.EQUAL, "O_SHIPPRIORITY"), (Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"), Comparison.Operator.GREATER_THAN, "O_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testLeftConvertedToInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o LEFT JOIN lineitem l ON o.orderkey < l.orderkey WHERE l.orderkey IS NOT NULL", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "O_ORDERKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.any(PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "L_ORDERKEY"))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LINEITEM_OK", "ORDERS_OK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey")))))));
    }

    @Test
    public void testInequalityPredicatePushdownWithOuterJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o LEFT JOIN lineitem l ON o.orderkey = l.orderkey AND o.custkey + 42 < l.partkey + 42 WHERE o.custkey - 24 < COALESCE(l.partkey - 24, 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Call(SUBTRACT_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "O_CUSTKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)24L))), (Expression)new Coalesce((Expression)new Call(SUBTRACT_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_PARTKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)24L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0])), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("O_ORDERKEY", "L_ORDERKEY").filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "O_CUSTKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)42L))), (Expression)new Reference((Type)BigintType.BIGINT, "EXPR"))).left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey", (Object)"O_CUSTKEY", (Object)"custkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"EXPR", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_PARTKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)42L))))), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey")))))))));
    }

    @Test
    public void testTopNPushdownToJoinSource() {
        this.assertPlan("SELECT n.name, r.name FROM nation n LEFT JOIN region r ON n.regionkey = r.regionkey ORDER BY n.comment LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("N_COMM", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("N_KEY", "R_KEY").left(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("N_COMM", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"N_NAME", (Object)"name", (Object)"N_KEY", (Object)"regionkey", (Object)"N_COMM", (Object)"comment")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"R_NAME", (Object)"name", (Object)"R_KEY", (Object)"regionkey"))))))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("X", "Y").left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))).right(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "S"), PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey")))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "S")), PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey")))))));
    }

    @Test
    public void testPushDownJoinConditionConjunctsToInnerSideBasedOnInheritedPredicate() {
        this.assertPlan("SELECT nationkey FROM nation LEFT OUTER JOIN region ON nation.regionkey = region.regionkey and nation.name = region.name WHERE nation.name = 'blah'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATION_NAME", "REGION_NAME"), PlanMatchPattern.equiJoinClause("NATION_REGIONKEY", "REGION_REGIONKEY"))).left(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.createVarcharType((int)25), "NATION_NAME"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"blah"))), PlanMatchPattern.constrainedTableScan("nation", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"NATION_NAME", (Object)"name", (Object)"NATION_REGIONKEY", (Object)"regionkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)VarcharType.createVarcharType((int)25), "REGION_NAME"), (Expression)new Constant((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"blah"))), PlanMatchPattern.constrainedTableScan("region", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"REGION_NAME", (Object)"name", (Object)"REGION_REGIONKEY", (Object)"regionkey"))))))));
    }

    @Test
    public void testSameScalarSubqueryIsAppliedOnlyOnce() {
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders WHERE CAST(orderkey AS INTEGER) = (SELECT 1 FROM orders LIMIT 1) AND custkey = (SELECT 2 FROM orders LIMIT 1) AND CAST(custkey as REAL) != (SELECT 1 FROM orders LIMIT 1)"), TableScanNode.class::isInstance)).isEqualTo(3);
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON   o1.orderkey = (SELECT 1 FROM orders LIMIT 1)   AND o2.orderkey = (SELECT 1 FROM orders LIMIT 1)   AND o1.orderkey + o2.orderkey > (SELECT 1 FROM orders LIMIT 1)"), TableScanNode.class::isInstance)).isEqualTo(3);
    }

    @Test
    public void testSameInSubqueryIsAppliedOnlyOnce() {
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey NOT IN (SELECT 1) AND (o1.orderkey NOT IN (SELECT 1) OR o1.orderkey NOT IN (SELECT 1))"), SemiJoinNode.class::isInstance)).isEqualTo(1);
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 NOT IN (SELECT 1), 2 NOT IN (SELECT 1) WHERE 1 NOT IN (SELECT 1)"), SemiJoinNode.class::isInstance)).isEqualTo(2);
    }

    @Test
    public void testSameQualifiedSubqueryIsAppliedOnlyOnce() {
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey <= ALL(SELECT 1) AND (o1.orderkey <= ALL(SELECT 1) OR o1.orderkey <= ALL(SELECT 1))"), AggregationNode.class::isInstance)).isEqualTo(1);
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 <= ALL(SELECT 1), 2 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)"), AggregationNode.class::isInstance)).isEqualTo(2);
    }

    @Test
    public void testSameExistsAppliedOnlyOnce() {
        this.assertPlan("SELECT EXISTS (SELECT 1 FROM orders), EXISTS (SELECT 1 FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquerytrue", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testReferenceToSameFieldAppliedOnlyOnce() {
        Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT (SELECT 1 FROM orders WHERE orderkey = x) + (SELECT 1 FROM orders WHERE orderkey = t.x) + (SELECT 1 FROM orders WHERE orderkey = T.x) + (SELECT 1 FROM orders WHERE orderkey = t.X) + (SELECT 1 FROM orders WHERE orderkey = T.X)FROM (VALUES 1, 2) t(x)"), JoinNode.class::isInstance)).isEqualTo(1);
    }

    private static int countOfMatchingNodes(Plan plan, Predicate<PlanNode> predicate) {
        return PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(predicate).count();
    }

    @Test
    public void testRemoveUnreferencedScalarInputApplyNodes() {
        this.assertPlanContainsNoApplyOrAnyJoin("SELECT (SELECT 1)");
    }

    @Test
    public void testSubqueryPruning() {
        List<QueryTemplate.Parameter> subqueries = QueryTemplate.parameter("subquery").of("orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "EXISTS(SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "0 = (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)");
        QueryTemplate.queryTemplate("SELECT COUNT(*) FROM (SELECT %subquery% FROM orders)", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
        QueryTemplate.queryTemplate("SELECT * FROM orders WHERE true OR %subquery%", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
    }

    @Test
    public void testJoinOutputPruning() {
        this.assertPlan("SELECT nationkey FROM nation JOIN region ON nation.regionkey = region.regionkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("REGIONKEY_LEFT", "REGIONKEY_RIGHT").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_LEFT", (Object)"regionkey", (Object)"NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_RIGHT", (Object)"regionkey")))))).withNumberOfOutputColumns(1).withOutputs((List<String>)ImmutableList.of((Object)"NATIONKEY")));
    }

    private void assertPlanContainsNoApplyOrAnyJoin(String sql) {
        this.assertPlanDoesNotContain(sql, ApplyNode.class, JoinNode.class, IndexJoinNode.class, SemiJoinNode.class, CorrelatedJoinNode.class);
    }

    @SafeVarargs
    private void assertPlanDoesNotContain(String sql, Class<? extends PlanNode> ... classes) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(sql, LogicalPlanner.Stage.OPTIMIZED).getRoot()).whereIsInstanceOfAny((Class[])classes).matches()).describedAs("Unexpected node for query: " + sql, new Object[0])).isFalse();
    }

    @Test
    public void testCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders WHERE 3 = (SELECT orderkey)", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.any(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))));
    }

    @Test
    public void testCorrelatedJoinWithLimit() {
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("region_regionkey", "nation_regionkey").left(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))).right(PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"nation_regionkey")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey")))))))));
        this.assertPlan("SELECT regionkey, n.nationkey FROM region LEFT JOIN LATERAL (SELECT nationkey FROM nation WHERE region.regionkey = 3 LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "region_regionkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L))).left(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))).right(PlanMatchPattern.limit(2L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_nationkey", (Object)"nationkey"))))))));
    }

    @Test
    public void testCorrelatedJoinWithTopN() {
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey ORDER BY name LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("region_regionkey", "nation_regionkey").left(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))).right(PlanMatchPattern.any(PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of((Object)"nation_regionkey"), (List<String>)ImmutableList.of((Object)"nation_name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"nation_name", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.ROW_NUMBER).maxRankingPerPartition(2).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey")))))))));
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey ORDER BY regionkey LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("region_regionkey", "nation_regionkey").left(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))).right(PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"nation_regionkey")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey")))))))));
    }

    @Test
    public void testCorrelatedJoinWithNullCondition() {
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation) n ON NULL", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.correlatedJoin(List.of("r_row_number", "r_regionkey", "r_name", "r_comment"), (Expression)new Constant((Type)BooleanType.BOOLEAN, null), PlanMatchPattern.tableScan("region", Map.of("r_row_number", "row_number", "r_regionkey", "regionkey", "r_name", "name", "r_comment", "comment")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))));
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation) n ON NULL", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria(List.of()).left(PlanMatchPattern.tableScan("region")).right(PlanMatchPattern.values("name")))));
    }

    @Test
    public void testCorrelatedScalarSubqueryInSelect() {
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Switch((Expression)new Reference((Type)BooleanType.BOOLEAN, "is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)Booleans.TRUE)), (Expression)new Cast((Expression)new Call(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("n_regionkey", "r_regionkey").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey"))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey"))))))))));
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", this.automaticJoinDistribution(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Switch((Expression)new Reference((Type)BooleanType.BOOLEAN, "is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)Booleans.TRUE)), (Expression)new Cast((Expression)new Call(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("n_regionkey", "r_regionkey").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey", (Object)"n_name", (Object)"name")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey"))))))))));
    }

    @Test
    public void testStreamingAggregationForCorrelatedSubquery() {
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey = nation.regionkey AND length(name) > length(nation.name)) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name"))))))));
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey > nation.regionkey) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name"))))))));
    }

    @Test
    public void testStreamingAggregationOverJoin() {
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l WHERE o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("l_orderkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"l_orderkey"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("l_orderkey", "o_orderkey").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o LEFT JOIN lineitem l ON o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("o_orderkey", "l_orderkey").left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey"))))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testCorrelatedInUncorrelatedFiltersPushDown() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)7L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))))));
    }

    @Test
    public void testSymbolsPrunedInCorrelatedInPredicateSource() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"comment", (Object)"comment"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testDoubleNestedCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders o WHERE 3 IN (SELECT o.custkey FROM lineitem l WHERE (SELECT l.orderkey = o.orderkey))", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Reference((Type)BooleanType.BOOLEAN, "OUTER_FILTER"), PlanMatchPattern.project(PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"O", (Object)"C"), (Map<String, SetExpressionMatcher>)ImmutableMap.of((Object)"OUTER_FILTER", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol((Type)UnknownType.UNKNOWN, "THREE"), new Symbol((Type)UnknownType.UNKNOWN, "C")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"THREE", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)BigintType.BIGINT, (Object)3L))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O", (Object)"orderkey", (Object)"C", (Object)"custkey"))), PlanMatchPattern.project(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L", (Object)"orderkey")))))))), (PlanOptimizer optimizer) -> !(optimizer instanceof AddLocalExchanges) && !(optimizer instanceof CheckSubqueryNodesAreRewritten) && !this.isPushPredicateIntoTableScanWithPrunePredicateOperation((PlanOptimizer)optimizer));
    }

    private boolean isPushPredicateIntoTableScanWithPrunePredicateOperation(PlanOptimizer optimizer) {
        if (optimizer instanceof IterativeOptimizer) {
            IterativeOptimizer iterativeOptimizer = (IterativeOptimizer)optimizer;
            return iterativeOptimizer.getRules().stream().anyMatch(rule -> {
                if (rule instanceof PushPredicateIntoTableScan) {
                    PushPredicateIntoTableScan pushPredicateIntoTableScan = (PushPredicateIntoTableScan)rule;
                    return pushPredicateIntoTableScan.getPruneWithPredicateExpression();
                }
                return false;
            });
        }
        return false;
    }

    @Test
    public void testCorrelatedExistsRewriteToInnerJoin() {
        this.assertPlan("SELECT suppkey FROM lineitem l1 WHERE EXISTS (SELECT * FROM lineitem l2 WHERE l2.orderkey = l1.orderkey AND l2.suppkey <> l1.suppkey)", PlanMatchPattern.output(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"SUPPKEY", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "L_SUPPKEY"))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("L_ORDERKEY", "L_SUPPKEY", "UNIQUE"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), (List<String>)ImmutableList.of((Object)"L_ORDERKEY", (Object)"L_SUPPKEY", (Object)"UNIQUE"), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.maySkipOutputDuplicates(true).equiCriteria("L_ORDERKEY", "R_ORDERKEY").filter((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "R_SUPPKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_SUPPKEY"))).dynamicFilter((Type)BigintType.BIGINT, "L_ORDERKEY", "R_ORDERKEY").left(PlanMatchPattern.assignUniqueId("UNIQUE", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_SUPPKEY", (Object)"suppkey", (Object)"L_ORDERKEY", (Object)"orderkey"))))).right(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"R_SUPPKEY", (Object)"suppkey", (Object)"R_ORDERKEY", (Object)"orderkey")))))))));
    }

    @Test
    public void testCorrelatedScalarAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT orderkey, EXISTS(SELECT 1 WHERE orderkey = 3) FROM orders", PlanMatchPattern.output(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ORDERKEY", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ORDERKEY")), (Object)"exists", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BooleanType.BOOLEAN, "AGGR_BOOL"), (Expression)Booleans.FALSE, new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("ORDERKEY", "UNIQUE"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("AGGR_BOOL"), PlanMatchPattern.aggregationFunction("bool_or", (List<String>)ImmutableList.of((Object)"SUBQUERY"))), (List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"UNIQUE"), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.LEFT, builder -> builder.maySkipOutputDuplicates(false).filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)3L), (Expression)new Reference((Type)BigintType.BIGINT, "ORDERKEY"))).left(PlanMatchPattern.assignUniqueId("UNIQUE", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"SUBQUERY", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testCorrelatedDistinctAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT (SELECT count(DISTINCT o.orderkey) FROM orders o WHERE c.custkey = o.custkey), c.custkey FROM customer c", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("c_custkey", "o_custkey").left(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey"))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_custkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"o_orderkey"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey", "o_custkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey", (Object)"o_custkey", (Object)"custkey"))))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testCorrelatedDistinctGroupedAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT (SELECT count(DISTINCT o.orderkey) FROM orders o WHERE c.custkey = o.custkey GROUP BY o.orderstatus), c.custkey FROM customer c", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Switch((Expression)new Reference((Type)BooleanType.BOOLEAN, "is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)Booleans.TRUE, (Expression)Booleans.TRUE)), (Expression)new Cast((Expression)new Call(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("c_custkey", "o_custkey").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"c_custkey", (Object)"custkey")))).right(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderstatus", "o_custkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("count"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"o_orderkey"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderstatus", "o_orderkey", "o_custkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderstatus", "o_orderkey", "o_custkey"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey", (Object)"o_orderstatus", (Object)"orderstatus", (Object)"o_custkey", (Object)"custkey")))))))))))))));
    }

    @Test
    public void testRemovesTrivialFilters() {
        this.assertPlan("SELECT * FROM nation WHERE 1 = 1", PlanMatchPattern.output(PlanMatchPattern.tableScan("nation")));
        this.assertPlan("SELECT * FROM nation WHERE 1 = 0", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testRemovesNullFilter() {
        this.assertPlan("SELECT * FROM nation WHERE null", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE NOT null", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE CAST(null AS BOOLEAN)", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE NOT CAST(null AS BOOLEAN)", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE nationkey = null", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE nationkey = CAST(null AS BIGINT)", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE nationkey < null OR nationkey > null", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
        this.assertPlan("SELECT * FROM nation WHERE nationkey = 19 AND CAST(null AS BOOLEAN)", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testRemovesFalseFilter() {
        this.assertPlan("SELECT * FROM nation WHERE CAST(name AS varchar(1)) = 'PO'", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testPruneCountAggregationOverScalar() {
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"_col0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))));
        this.assertPlan("SELECT count(s) FROM (SELECT sum(orderkey) AS s FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders GROUP BY custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
    }

    @Test
    public void testInlineCountOverLiteral() {
        this.assertPlan("SELECT regionkey, count(1) FROM nation GROUP BY regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count_0", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")))));
    }

    @Test
    public void testInlineCountOverEffectivelyLiteral() {
        this.assertPlan("SELECT regionkey, count(CAST(DECIMAL '1' AS decimal(8,4))) FROM nation GROUP BY regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count_0", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")))));
    }

    @Test
    public void testPickTableLayoutWithFilter() {
        this.assertPlan("SELECT orderkey FROM orders WHERE orderkey=5", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("SELECT orderkey FROM orders WHERE orderstatus='F'", PlanMatchPattern.output(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))));
    }

    @Test
    public void testBroadcastCorrelatedSubqueryAvoidsRemoteExchangeBeforeAggregation() {
        Session broadcastJoin = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).build();
        PlanMatchPattern joinBuildSideWithRemoteExchange = PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        Consumer<Plan> validateSingleRemoteExchange = plan -> Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE)).isEqualTo(1);
        Consumer<Plan> validateSingleStreamingAggregation = plan -> Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof AggregationNode && ((AggregationNode)node).getGroupingKeys().contains(new Symbol((Type)BigintType.BIGINT, "unique")) && ((AggregationNode)node).isStreamable())).isEqualTo(1);
        this.assertPlanWithSession("SELECT (SELECT count(*) FROM region r2 WHERE r2.regionkey > r1.regionkey) FROM region r1", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
        this.assertPlanWithSession("SELECT count(count) FROM (SELECT o1.orderkey orderkey, (SELECT count(*) FROM orders o2 WHERE o2.orderkey > o1.orderkey) count FROM orders o1) GROUP BY orderkey", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
    }

    @Test
    public void testUsesDistributedJoinIfNaturallyPartitionedOnProbeSymbols() {
        Session broadcastJoin = Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("optimize_hash_generation", Boolean.toString(false)).build();
        this.assertPlanWithSession("SELECT r1.regionkey FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey = r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("LEFT_REGIONKEY", "RIGHT_REGIONKEY").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"LEFT_REGIONKEY", (Object)"regionkey"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"RIGHT_REGIONKEY", (Object)"regionkey"))))))), plan -> Assertions.assertThat((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE)).isEqualTo(2));
        this.assertPlanWithSession("SELECT * FROM (VALUES 1, 2, 3) t(a), region r WHERE r.regionkey = t.a", Session.builder((Session)broadcastJoin).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).build(), false, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        this.assertPlanWithSession("SELECT * FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey > r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))).right(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testDistributedSort() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))))));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("distributed_sort", Boolean.toString(false)).build(), PlanMatchPattern.output(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveAggregationInSemiJoin() {
        this.assertPlanDoesNotContain("SELECT custkey FROM orders WHERE custkey NOT IN (SELECT distinct custkey FROM customer)", AggregationNode.class);
    }

    @Test
    public void testRemoveEmptyGlobalAggregation() {
        this.assertPlan("SELECT count(*) FROM (SELECT count(*) FROM nation)", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)BigintType.BIGINT, (Object)1L))))));
        this.assertPlan("SELECT count(*) FROM (SELECT count(*) FROM (VALUES 1,2,3,4,5,6,7))", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)BigintType.BIGINT, (Object)1L))))));
        this.assertPlan("SELECT count(*) FROM (SELECT count(*) FROM UNNEST(sequence(1, 10)))", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)BigintType.BIGINT, (Object)1L))))));
        this.assertPlan("SELECT 1 FROM nation GROUP BY GROUPING SETS (())", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))))));
        this.assertPlan("SELECT 1 FROM (VALUES 1,2,3,4,5,6,7) GROUP BY GROUPING SETS (())", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))))));
        this.assertPlan("SELECT 1 FROM UNNEST(sequence(1, 10)) GROUP BY GROUPING SETS (())", PlanMatchPattern.output(PlanMatchPattern.values(List.of("c"), List.of(List.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))))));
    }

    @Test
    public void testFilteringSemiJoinRewriteToInnerJoin() {
        this.assertPlan("SELECT custkey FROM orders WHERE custkey IN (SELECT custkey FROM customer)", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDER_CUSTKEY", "CUSTOMER_CUSTKEY").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_CUSTKEY", (Object)"custkey")))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("CUSTOMER_CUSTKEY"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"CUSTOMER_CUSTKEY", (Object)"custkey"))))))));
    }

    @Test
    public void testCorrelatedIn() {
        this.assertPlan("SELECT name FROM region r WHERE regionkey IN (SELECT regionkey FROM nation WHERE name < r.name)", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"region_name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "region_name"))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("region_regionkey", "region_name", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"region_regionkey", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "region_regionkey")), (Object)"region_name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "region_name")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "unique"))), PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "region_regionkey")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "region_regionkey"), (Expression)new Reference((Type)BigintType.BIGINT, "nation_regionkey")), (Object)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "nation_regionkey")))), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "nation_name"), (Expression)new Reference((Type)VarcharType.VARCHAR, "region_name")))), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)VarcharType.VARCHAR, "region_name"), Comparison.Operator.GREATER_THAN, "nation_name"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "region_regionkey"))), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey", (Object)"region_name", (Object)"name"))))).right(PlanMatchPattern.any(PlanMatchPattern.filter(IrExpressions.not((Metadata)this.getPlanTester().getPlannerContext().getMetadata(), (Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "nation_regionkey"))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey"))))))))))));
    }

    @Test
    public void testCorrelatedExists() {
        this.assertPlan("SELECT regionkey, name FROM region r WHERE EXISTS(SELECT regionkey FROM nation WHERE name < r.name)", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("region_regionkey", "region_name", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "nation_name"), (Expression)new Reference((Type)VarcharType.VARCHAR, "region_name")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern((Expression)new Reference((Type)VarcharType.VARCHAR, "region_name"), Comparison.Operator.GREATER_THAN, "nation_name"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey", (Object)"region_name", (Object)"name"))))).right(PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name")))))))))));
    }

    @Test
    public void testOrderByFetch() {
        this.assertPlan("SELECT * FROM nation ORDER BY name FETCH FIRST 2 ROWS ONLY", PlanMatchPattern.anyTree(PlanMatchPattern.topN(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("NAME", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))));
    }

    @Test
    public void testFetch() {
        this.assertPlan("SELECT * FROM nation FETCH FIRST 2 ROWS ONLY", PlanMatchPattern.anyTree(PlanMatchPattern.limit(2L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testOffset() {
        this.assertPlan("SELECT name FROM nation OFFSET 2 ROWS", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey OFFSET 2 ROWS", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.any(PlanMatchPattern.topN(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.limit(7L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name"))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testWithTies() {
        this.assertPlan("SELECT name, regionkey FROM nation ORDER BY regionkey FETCH FIRST 6 ROWS WITH TIES", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name")), (Object)"regionkey", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "regionkey"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"regionkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"regionkey", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.RANK).maxRankingPerPartition(6).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))));
        this.assertPlan("SELECT name, regionkey FROM nation ORDER BY regionkey OFFSET 10 ROWS FETCH FIRST 6 ROWS WITH TIES", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name")), (Object)"regionkey", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "regionkey"))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "row_num"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)), PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "name")), (Object)"regionkey", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "regionkey"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"regionkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"regionkey", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.RANK).maxRankingPerPartition(16).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testRedundantLimitNodeRemoval() {
        String query = "SELECT count(*) FROM orders LIMIT 10";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(LimitNode.class::isInstance).matches()).describedAs(String.format("Unexpected limit node for query: '%s'", query), new Object[0])).isFalse();
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"))));
    }

    @Test
    public void testLimitPushdownThroughUnionNesting() {
        this.assertPlan("SELECT col FROM (\n    SELECT nationkey FROM nation\n    UNION ALL\n    SELECT nationkey FROM nation\n    UNION ALL\n    SELECT nationkey FROM nation\n) AS t(col)\nLIMIT 2", PlanMatchPattern.output(PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")), PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")), PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, PlanMatchPattern.tableScan("nation")))))));
    }

    @Test
    public void testRemoveSingleRowSort() {
        String query = "SELECT count(*) FROM orders ORDER BY 1";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).whereIsInstanceOfAny(new Class[]{SortNode.class}).matches()).describedAs(String.format("Unexpected sort node for query: '%s'", query), new Object[0])).isFalse();
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testRedundantTopNNodeRemoval() {
        String query = "SELECT count(*) FROM orders ORDER BY 1 LIMIT 10";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).whereIsInstanceOfAny(new Class[]{TopNNode.class, SortNode.class}).matches()).describedAs(String.format("Unexpected TopN node for query: '%s'", query), new Object[0])).isFalse();
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.assertPlan("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 ORDER BY 1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.node(SortNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x")))))));
    }

    @Test
    public void testRedundantDistinctLimitNodeRemoval() {
        String query = "SELECT distinct(c) FROM (SELECT count(*) as c FROM orders) LIMIT 10";
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).whereIsInstanceOfAny(new Class[]{DistinctLimitNode.class}).matches()).describedAs(String.format("Unexpected DistinctLimit node for query: '%s'", query), new Object[0])).isFalse();
        this.assertPlan("SELECT distinct(c) FROM (SELECT count(*) as c FROM orders GROUP BY orderkey) LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT distinct(id) FROM (VALUES 1, 2, 3, 4, 5, 6) as t1 (id) LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x")))));
    }

    @Test
    public void testRedundantHashRemovalForUnionAll() {
        this.assertPlan("SELECT count(*) FROM ((SELECT nationkey FROM customer) UNION ALL (SELECT nationkey FROM customer)) GROUP BY nationkey", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("optimize_hash_generation", "true").build(), PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "nationkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))))), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_1", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "nationkey_6"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))))), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_6", (Object)"nationkey")))))))));
    }

    @Test
    public void testRedundantHashRemovalForMarkDistinct() {
        this.assertDistributedPlan("select count(*), count(distinct orderkey), count(distinct partkey), count(distinct suppkey) from lineitem", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("optimize_hash_generation", "true").setSystemProperty("task_concurrency", "16").setSystemProperty("distinct_aggregations_strategy", "mark_distinct").build(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.identityProject(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_1", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "suppkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0])))), (Object)"hash_2", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "partkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))))), PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"suppkey", (Object)"suppkey", (Object)"partkey", (Object)"partkey"))))))))));
    }

    @Test
    public void testRedundantHashRemovalForUnionAllAndMarkDistinct() {
        this.assertDistributedPlan("SELECT count(distinct(custkey)), count(distinct(nationkey)) FROM ((SELECT custkey, nationkey FROM customer) UNION ALL ( SELECT custkey, custkey FROM customer))", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("distinct_aggregations_strategy", "mark_distinct").setSystemProperty("optimize_hash_generation", "true").build(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_custkey", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "custkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0])))), (Object)"hash_nationkey", (Object)PlanMatchPattern.expression((Expression)new Call(COMBINE_HASH, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)0L), (Object)new Coalesce((Expression)new Call(HASH_CODE, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "nationkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))))), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))))));
    }

    @Test
    public void testRemoveRedundantFilter() {
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (VALUES CAST('' || 'O' AS varchar(1)), CAST('' || 'F' AS varchar(1))) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.any(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDER_STATUS", "expr").left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)1), (List)ImmutableList.of((Object)Slices.utf8Slice((String)"F"), (Object)Slices.utf8Slice((String)"O"))))))).right(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"O"))), (Object)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")))))))));
    }

    @Test
    public void testRemoveRedundantCrossJoin() {
        this.assertPlan("SELECT regionkey FROM nation, (SELECT 1 as a) temp WHERE regionkey = temp.a", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "REGIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey")))));
        this.assertPlan("SELECT regionkey FROM (SELECT 1 as a) temp, nation WHERE regionkey > temp.a", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "REGIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey")))));
        this.assertPlan("SELECT * FROM nation, (SELECT 1 as a) temp WHERE regionkey = a", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "REGIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey"))))));
    }

    @Test
    public void testRemoveRedundantInnerJoin() {
        this.assertPlan("SELECT regionkey FROM nation INNER JOIN (SELECT nationkey FROM customer LIMIT 0) USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
        this.assertPlan("SELECT regionkey FROM (SELECT * FROM nation LIMIT 0) INNER JOIN customer USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testRemoveRedundantLeftJoin() {
        this.assertPlan("SELECT regionkey FROM (SELECT * FROM nation LIMIT 0) LEFT JOIN customer USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testRemoveRedundantRightJoin() {
        this.assertPlan("SELECT regionkey FROM nation RIGHT JOIN (SELECT nationkey FROM customer LIMIT 0) USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testMergeProjectWithValues() {
        this.assertPlan("SELECT * FROM nation, (SELECT a * 2 FROM (VALUES 1, 2, 3) t(a))", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.tableScan("nation")).right(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)6L))))))));
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (SELECT '' || x FROM (VALUES 'F') t(x)) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)VarcharType.createVarcharType((int)1), "ORDER_STATUS"), (Type)VarcharType.VARCHAR))), PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")))))));
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (SELECT CAST('' || x AS varchar(1)) FROM (VALUES 'O', 'F') t(x)) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDER_STATUS", "expr").left(PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)1), (List)ImmutableList.of((Object)Slices.utf8Slice((String)"F"), (Object)Slices.utf8Slice((String)"O"))))))).right(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"O"))), (Object)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")))))))));
        this.assertPlan("SELECT orderstatus, t2.s FROM orders JOIN (SELECT x * 1 FROM (VALUES BIGINT '1', BIGINT '3') t(x)) t2(s) ON orders.orderkey = t2.s", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("ORDER_KEY", "expr").left(PlanMatchPattern.filter((Expression)new In((Expression)new Reference((Type)BigintType.BIGINT, "ORDER_KEY"), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)3L))), PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of()))).right(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)3L))))))));
    }

    @Test
    public void testReplaceJoinWithProject() {
        this.assertPlan("SELECT * FROM nation, (SELECT a * 2 FROM (VALUES 1) t(a))", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), PlanMatchPattern.tableScan("nation"))));
        this.assertPlan("SELECT * FROM nation, (SELECT b * 3 FROM (SELECT a * 2 FROM (VALUES 1) t1(a)) t2(b))", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L))), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testGroupingSetsWithDefaultValue() {
        this.assertDistributedPlan("SELECT orderkey, COUNT(DISTINCT k) FROM (SELECT orderkey, 1 k FROM orders) GROUP BY GROUPING SETS ((), orderkey)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"final_count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"partial_count"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"partial_count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"CONSTANT"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONSTANT", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), PlanMatchPattern.tableScan("orders"))))))))));
    }

    @Test
    public void testSizeBasedJoin() {
        this.assertDistributedPlan("SELECT custkey FROM \"test_catalog\".\"sf42.5\".nation, \"test_catalog\".\"sf42.5\".orders WHERE nation.nationkey = orders.custkey", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("NATIONKEY", "CUSTKEY").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a), \"test_catalog\".\"sf42.5\".orders WHERE t.a = orders.custkey", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("CUSTKEY", "T_A").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testSizeBasedSemiJoin() {
        this.assertDistributedPlan("SELECT custkey FROM \"test_catalog\".\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT nationkey FROM \"test_catalog\".\"sf42.5\".nation)", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "NATIONKEY", "OUT", Optional.of(SemiJoinNode.DistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM \"test_catalog\".\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT t.a FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a))", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "T_A", "OUT", Optional.of(SemiJoinNode.DistributionType.REPLICATED), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey")), PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testExplainAnalyze() {
        this.assertPlan("EXPLAIN ANALYZE SELECT regionkey FROM nation", PlanMatchPattern.output(PlanMatchPattern.node(ExplainAnalyzeNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.strictTableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))));
    }

    @Test
    public void testValuesCoercions() {
        this.assertPlan("VALUES TINYINT '1', REAL '1'", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)1L), (Type)RealType.REAL)), (Object)ImmutableList.of((Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)))))));
        this.assertPlan("VALUES (TINYINT '1', REAL '1'), (DOUBLE '2', SMALLINT '2')", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"field0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)1L), (Type)DoubleType.DOUBLE), (Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f))), (Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.0), (Object)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)2L), (Type)RealType.REAL))))));
        this.assertPlan("VALUES DOUBLE '1', CAST(ROW(2) AS row(bigint))", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values(PlanMatchPattern.aliasToIndex((List<String>)ImmutableList.of((Object)"field")), Optional.of(1), Optional.of(ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))), (Object)new Cast((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))), (Type)RowType.anonymous((List)ImmutableList.of((Object)DoubleType.DOUBLE))))))));
    }

    @Test
    public void testDoNotPlanUnreferencedRowPatternMeasures() {
        this.assertPlan("SELECT val OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", (Expression)new Reference((Type)IntegerType.INTEGER, "val"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"val", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "value"))), (Type)IntegerType.INTEGER).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)90L))))))));
        this.assertPlan("SELECT min(value) OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("min", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"value"), ROWS_FROM_CURRENT)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)90L))))))));
    }

    @Test
    public void testPruneUnreferencedRowPatternWindowFunctions() {
        this.assertPlan("SELECT id, min FROM        (SELECT id, min(value) OVER w min, row_number() OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )       )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("min", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"value"), ROWS_FROM_CURRENT)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)90L))))))));
    }

    @Test
    public void testPruneUnreferencedRowPatternMeasures() {
        this.assertPlan("SELECT id, val FROM        (SELECT id, val OVER w val, label OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )       )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", (Expression)new Reference((Type)IntegerType.INTEGER, "val"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"val", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "value"))), (Type)IntegerType.INTEGER).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)90L))))))));
    }

    @Test
    public void testMergePatternRecognitionNodes() {
        this.assertPlan("SELECT id, val OVER w, label OVER w, row_number() OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", (Expression)new Reference((Type)IntegerType.INTEGER, "val"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"val", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "value"))), (Type)IntegerType.INTEGER).addMeasure("label", (Expression)new Reference((Type)VarcharType.VARCHAR, "classy"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"classy", (Object)new ClassifierValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0))), (Type)VarcharType.VARCHAR).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), ROWS_FROM_CURRENT)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)90L))))))));
    }

    @Test
    public void testMergePatternRecognitionNodesWithProjections() {
        this.assertPlan("SELECT id, 2 * value OVER w, lower(label OVER w), 1 + min(input1) OVER w           FROM (VALUES (1, 2, 3)) t(id, input1, input2)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(input2) AS value,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "id")), (Object)"output2", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (Object)"output3", (Object)PlanMatchPattern.expression((Expression)new Call(LOWER, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "label")))), (Object)"output4", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "min"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"id", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "id")), (Object)"value", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "value")), (Object)"label", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)VarcharType.VARCHAR, "label")), (Object)"min", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "min"))), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("value", (Expression)new Reference((Type)IntegerType.INTEGER, "value"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"value", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "input2"))), (Type)IntegerType.INTEGER).addMeasure("label", (Expression)new Reference((Type)VarcharType.VARCHAR, "classy"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"classy", (Object)new ClassifierValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0))), (Type)VarcharType.VARCHAR).addFunction("min", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"input1"), ROWS_FROM_CURRENT)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_FROM_CURRENT).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), (Expression)Booleans.TRUE), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"input1", (Object)"input2"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L)))))))));
    }

    @Test
    public void testDifferentOuterParentScopeSubqueries() {
        this.assertPlan("SELECT customer.custkey AS custkey,(SELECT COUNT(*) FROM orders WHERE customer.custkey = orders.custkey) AS count1,(SELECT COUNT(*) FROM orders WHERE orders.custkey = customer.custkey) AS count2 FROM customer", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.join(JoinType.LEFT, leftJoinBuilder -> leftJoinBuilder.equiCriteria("CUSTOMER_CUSTKEY", "ORDERS2_CUSTKEY").left(PlanMatchPattern.project(PlanMatchPattern.join(JoinType.INNER, leftInnerJoinBuilder -> leftInnerJoinBuilder.left(PlanMatchPattern.join(JoinType.LEFT, innerBuilder -> innerBuilder.equiCriteria("CUSTOMER_CUSTKEY", "ORDERS_CUSTKEY").left(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"CUSTOMER_CUSTKEY", (Object)"custkey"))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_CUSTKEY", (Object)"custkey"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS2_CUSTKEY", (Object)"custkey")))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testDecorrelateSingleRowSubquery() {
        this.assertPlan("SELECT * FROM (VALUES 1, 2, 3) t(a), LATERAL (VALUES a * 3)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)9L))))));
    }

    @Test
    public void testPruneWindow() {
        this.assertPlan("SELECT count() OVER() c FROM (SELECT 1 WHERE false)", PlanMatchPattern.output(PlanMatchPattern.values("c")));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    private Session automaticJoinDistribution() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).build();
    }

    private Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

