/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;

public class ThreadCountParser {
    private static final String PER_CORE_SUFFIX = "C";
    private static final Supplier<Integer> AVAILABLE_PROCESSORS = Runtime.getRuntime()::availableProcessors;
    public static final ThreadCountParser DEFAULT = new ThreadCountParser(AVAILABLE_PROCESSORS);
    private final Supplier<Integer> coreCount;

    @VisibleForTesting
    ThreadCountParser(Supplier<Integer> coreCount) {
        this.coreCount = Objects.requireNonNull(coreCount, "coreCount is null");
    }

    public int parse(String value) {
        long threads;
        int coreCount = this.coreCount.get();
        Preconditions.checkState((coreCount > 0 ? 1 : 0) != 0, (Object)"coreCount must be positive");
        if (value.endsWith(PER_CORE_SUFFIX)) {
            long multiplier = Long.parseLong(value.substring(0, value.length() - PER_CORE_SUFFIX.length()).trim());
            Preconditions.checkArgument((multiplier > 0L ? 1 : 0) != 0, (Object)"Thread multiplier cannot be negative");
            threads = Math.multiplyExact(multiplier, coreCount);
        } else {
            threads = Long.parseLong(value);
        }
        Preconditions.checkArgument((threads <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Thread count is greater than 2^32 - 1");
        Preconditions.checkArgument((0L <= threads ? 1 : 0) != 0, (Object)"Thread count cannot be negative");
        return Math.toIntExact(threads);
    }
}

