/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.airlift.slice.SizeOf;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class SplitsMapping {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SplitsMapping.class);
    public static final SplitsMapping EMPTY = SplitsMapping.builder().build();
    private final Map<PlanNodeId, Map<Integer, List<Split>>> splits;

    private SplitsMapping(ImmutableMap<PlanNodeId, Map<Integer, List<Split>>> splits) {
        this.splits = splits;
    }

    public Set<PlanNodeId> getPlanNodeIds() {
        return this.splits.keySet();
    }

    public ListMultimap<PlanNodeId, Split> getSplitsFlat() {
        ImmutableListMultimap.Builder splitsFlat = ImmutableListMultimap.builder();
        for (Map.Entry<PlanNodeId, Map<Integer, List<Split>>> entry : this.splits.entrySet()) {
            splitsFlat.putAll((Object)entry.getKey(), (Iterable)entry.getValue().values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
        }
        return splitsFlat.build();
    }

    public List<Split> getSplitsFlat(PlanNodeId planNodeId) {
        Map<Integer, List<Split>> splits = this.splits.get(planNodeId);
        if (splits == null) {
            return ImmutableList.of();
        }
        Verify.verify((!splits.isEmpty() ? 1 : 0) != 0, (String)"expected not empty splits list %s", splits);
        if (splits.size() == 1) {
            return (List)Iterables.getOnlyElement(splits.values());
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (List<Split> partitionSplits : splits.values()) {
            result.addAll(partitionSplits);
        }
        return result.build();
    }

    @VisibleForTesting
    ListMultimap<Integer, Split> getSplits(PlanNodeId planNodeId) {
        Map<Integer, List<Split>> splits = this.splits.get(planNodeId);
        if (splits == null) {
            return ImmutableListMultimap.of();
        }
        Verify.verify((!splits.isEmpty() ? 1 : 0) != 0, (String)"expected not empty splits list %s", splits);
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry<Integer, List<Split>> entry : splits.entrySet()) {
            result.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        return result.build();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.splits, PlanNodeId::getRetainedSizeInBytes, planNodeSplits -> SizeOf.estimatedSizeOf((Map)planNodeSplits, partitionId -> SizeOf.INTEGER_INSTANCE_SIZE, splitList -> SizeOf.estimatedSizeOf((List)splitList, Split::getRetainedSizeInBytes)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitsMapping that = (SplitsMapping)o;
        return Objects.equals(this.splits, that.splits);
    }

    public int hashCode() {
        return Objects.hash(this.splits);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splits", this.splits).toString();
    }

    public static Builder builder() {
        return new NewBuilder();
    }

    public static Builder builder(SplitsMapping mapping) {
        return new UpdatingBuilder(mapping);
    }

    public long size() {
        return this.splits.values().stream().flatMap(sourcePartitionToSplits -> sourcePartitionToSplits.values().stream()).mapToLong(List::size).sum();
    }

    private static class NewBuilder
    extends Builder {
        private final Map<PlanNodeId, Map<Integer, ImmutableList.Builder<Split>>> splitsBuilder = new HashMap<PlanNodeId, Map<Integer, ImmutableList.Builder<Split>>>();

        private NewBuilder() {
        }

        @Override
        public Builder addSplits(PlanNodeId planNodeId2, int partitionId, List<Split> splits) {
            if (splits.isEmpty()) {
                return this;
            }
            this.splitsBuilder.computeIfAbsent(planNodeId2, planNodeId -> new HashMap()).computeIfAbsent(partitionId, n -> ImmutableList.builder()).addAll(splits);
            return this;
        }

        @Override
        public SplitsMapping build() {
            return new SplitsMapping((ImmutableMap<PlanNodeId, Map<Integer, List<Split>>>)((ImmutableMap)this.splitsBuilder.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, planNodeMapping -> (Map)((Map)planNodeMapping.getValue()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, sourcePartitionMapping -> ((ImmutableList.Builder)sourcePartitionMapping.getValue()).build()))))));
        }
    }

    private static class UpdatingBuilder
    extends Builder {
        private final SplitsMapping originalMapping;
        private final Map<PlanNodeId, Map<Integer, ImmutableList.Builder<Split>>> updates = new HashMap<PlanNodeId, Map<Integer, ImmutableList.Builder<Split>>>();

        public UpdatingBuilder(SplitsMapping originalMapping) {
            this.originalMapping = Objects.requireNonNull(originalMapping, "sourceMapping is null");
        }

        @Override
        public Builder addSplits(PlanNodeId planNodeId2, int partitionId, List<Split> splits) {
            if (splits.isEmpty()) {
                return this;
            }
            this.updates.computeIfAbsent(planNodeId2, planNodeId -> new HashMap()).computeIfAbsent(partitionId, key -> ImmutableList.builder()).addAll(splits);
            return this;
        }

        @Override
        public SplitsMapping build() {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (PlanNodeId planNodeId : Sets.union(this.originalMapping.splits.keySet(), this.updates.keySet())) {
                Map<Integer, List<Split>> planNodeOriginalMapping = this.originalMapping.splits.getOrDefault(planNodeId, (Map<Integer, List<Split>>)ImmutableMap.of());
                Map<Integer, ImmutableList.Builder<Split>> planNodeUpdates = this.updates.getOrDefault(planNodeId, (Map<Integer, ImmutableList.Builder<Split>>)ImmutableMap.of());
                if (planNodeUpdates.isEmpty()) {
                    result.put((Object)planNodeId, planNodeOriginalMapping);
                    continue;
                }
                ImmutableMap.Builder targetSplitsMapBuilder = ImmutableMap.builder();
                for (Integer sourcePartitionId : Sets.union(planNodeOriginalMapping.keySet(), planNodeUpdates.keySet())) {
                    List<Split> originalSplits = planNodeOriginalMapping.get(sourcePartitionId);
                    ImmutableList.Builder<Split> splitUpdates = planNodeUpdates.get(sourcePartitionId);
                    targetSplitsMapBuilder.put((Object)sourcePartitionId, UpdatingBuilder.mergeIfPresent(originalSplits, splitUpdates));
                }
                result.put((Object)planNodeId, (Object)targetSplitsMapBuilder.buildOrThrow());
            }
            return new SplitsMapping((ImmutableMap<PlanNodeId, Map<Integer, List<Split>>>)result.buildOrThrow());
        }

        private static <T> List<T> mergeIfPresent(@Nullable List<T> list, @Nullable ImmutableList.Builder<T> additionalElements) {
            if (additionalElements == null) {
                return Objects.requireNonNull(list, "list is null");
            }
            if (list == null) {
                return additionalElements.build();
            }
            return ImmutableList.builder().addAll(list).addAll((Iterable)additionalElements.build()).build();
        }
    }

    public static abstract class Builder {
        private Builder() {
        }

        public Builder addSplit(PlanNodeId planNodeId, int partitionId, Split split) {
            return this.addSplits(planNodeId, partitionId, (List<Split>)ImmutableList.of((Object)split));
        }

        public Builder addSplits(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits) {
            Multimaps.asMap(splits).forEach((partitionId, partitionSplits) -> this.addSplits(planNodeId, (int)partitionId, (List<Split>)partitionSplits));
            return this;
        }

        public Builder addMapping(SplitsMapping updatingMapping) {
            for (Map.Entry<PlanNodeId, Map<Integer, List<Split>>> entry : updatingMapping.splits.entrySet()) {
                PlanNodeId planNodeId = entry.getKey();
                entry.getValue().forEach((partitionId, partitionSplits) -> this.addSplits(planNodeId, (int)partitionId, (List<Split>)partitionSplits));
            }
            return this;
        }

        public abstract Builder addSplits(PlanNodeId var1, int var2, List<Split> var3);

        public abstract SplitsMapping build();
    }
}

