/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.spi.block.ArrayBlockEncoding;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.ByteArrayBlockEncoding;
import io.trino.spi.block.DictionaryBlockEncoding;
import io.trino.spi.block.Fixed12BlockEncoding;
import io.trino.spi.block.Int128ArrayBlockEncoding;
import io.trino.spi.block.IntArrayBlockEncoding;
import io.trino.spi.block.LazyBlockEncoding;
import io.trino.spi.block.LongArrayBlockEncoding;
import io.trino.spi.block.MapBlockEncoding;
import io.trino.spi.block.RowBlockEncoding;
import io.trino.spi.block.RunLengthBlockEncoding;
import io.trino.spi.block.ShortArrayBlockEncoding;
import io.trino.spi.block.VariableWidthBlockEncoding;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class BlockEncodingManager {
    private final Map<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();

    public BlockEncodingManager() {
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Fixed12BlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new MapBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
    }

    public BlockEncoding getBlockEncoding(String encodingName) {
        BlockEncoding blockEncoding = this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding: %s", (Object)encodingName);
        return blockEncoding;
    }

    public void addBlockEncoding(BlockEncoding blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncoding existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding already registered: %s", (Object)blockEncoding.getName());
    }
}

