/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class TypedHeap {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TypedHeap.class);
    private final boolean min;
    private final MethodHandle readFlat;
    private final MethodHandle writeFlat;
    private final MethodHandle compareFlatFlat;
    private final MethodHandle compareFlatBlock;
    private final Type elementType;
    private final int capacity;
    private final int recordElementOffset;
    private final int recordSize;
    private final byte[] fixedChunk;
    private VariableWidthData variableWidthData;
    private int positionCount;
    private static final double MAX_FREE_RATIO = 0.66;

    public TypedHeap(boolean min, MethodHandle readFlat, MethodHandle writeFlat, MethodHandle compareFlatFlat, MethodHandle compareFlatBlock, Type elementType, int capacity) {
        this.min = min;
        this.readFlat = Objects.requireNonNull(readFlat, "readFlat is null");
        this.writeFlat = Objects.requireNonNull(writeFlat, "writeFlat is null");
        this.compareFlatFlat = Objects.requireNonNull(compareFlatFlat, "compareFlatFlat is null");
        this.compareFlatBlock = Objects.requireNonNull(compareFlatBlock, "compareFlatBlock is null");
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        this.capacity = capacity;
        boolean variableWidth = elementType.isFlatVariableWidth();
        this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        this.recordElementOffset = variableWidth ? 12 : 0;
        this.recordSize = this.recordElementOffset + elementType.getFlatFixedSize();
        this.fixedChunk = new byte[this.recordSize * (capacity + 1)];
    }

    public TypedHeap(TypedHeap typedHeap) {
        this.min = typedHeap.min;
        this.readFlat = typedHeap.readFlat;
        this.writeFlat = typedHeap.writeFlat;
        this.compareFlatFlat = typedHeap.compareFlatFlat;
        this.compareFlatBlock = typedHeap.compareFlatBlock;
        this.elementType = typedHeap.elementType;
        this.capacity = typedHeap.capacity;
        this.positionCount = typedHeap.positionCount;
        this.recordElementOffset = typedHeap.recordElementOffset;
        this.recordSize = typedHeap.recordSize;
        this.fixedChunk = Arrays.copyOf(typedHeap.fixedChunk, typedHeap.fixedChunk.length);
        this.variableWidthData = typedHeap.variableWidthData != null ? new VariableWidthData(typedHeap.variableWidthData) : null;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.fixedChunk) + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes());
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void writeAllSorted(BlockBuilder resultBlockBuilder) {
        int[] indexes = new int[this.positionCount];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        IntArrays.quickSort((int[])indexes, this::compare);
        for (int index : indexes) {
            this.write(index, resultBlockBuilder);
        }
    }

    public void writeAllUnsorted(BlockBuilder elementBuilder) {
        for (int i = 0; i < this.positionCount; ++i) {
            this.write(i, elementBuilder);
        }
    }

    private void write(int index, BlockBuilder blockBuilder) {
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            variableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, recordOffset);
        }
        try {
            this.readFlat.invokeExact(this.fixedChunk, recordOffset + this.recordElementOffset, variableWidthChunk, blockBuilder);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public void add(ValueBlock block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (!this.shouldConsiderValue(block, position)) {
                return;
            }
            this.clear(0);
            this.set(0, block, position);
            this.siftDown();
        } else {
            this.set(this.positionCount, block, position);
            ++this.positionCount;
            this.siftUp();
        }
    }

    private void clear(int index) {
        if (this.variableWidthData == null) {
            return;
        }
        this.variableWidthData.free(this.fixedChunk, this.getRecordOffset(index));
        this.variableWidthData = TypedHeap.compactIfNecessary(this.variableWidthData, this.fixedChunk, this.recordSize, 0, this.positionCount, (fixedSizeOffset, variableWidthChunk, variableWidthChunkOffset) -> this.elementType.relocateFlatVariableWidthOffsets(this.fixedChunk, fixedSizeOffset + this.recordElementOffset, variableWidthChunk, variableWidthChunkOffset));
    }

    private void set(int index, ValueBlock block, int position) {
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.variableWidthData != null) {
            int variableWidthLength = this.elementType.getFlatVariableWidthSize((Block)block, position);
            variableWidthChunk = this.variableWidthData.allocate(this.fixedChunk, recordOffset, variableWidthLength);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(this.fixedChunk, recordOffset);
        }
        try {
            this.writeFlat.invokeExact(block, position, this.fixedChunk, recordOffset + this.recordElementOffset, variableWidthChunk, variableWidthChunkOffset);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.compare(leftPosition, rightPosition) < 0 ? rightPosition : leftPosition;
            }
            if (this.compare(smallerChildPosition, position) < 0) break;
            this.swap(position, smallerChildPosition);
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && this.compare(position, parentPosition = (position - 1) / 2) >= 0) {
            this.swap(position, parentPosition);
            position = parentPosition;
        }
    }

    private void swap(int leftPosition, int rightPosition) {
        int leftOffset = this.getRecordOffset(leftPosition);
        int rightOffset = this.getRecordOffset(rightPosition);
        int tempOffset = this.getRecordOffset(this.capacity);
        System.arraycopy(this.fixedChunk, leftOffset, this.fixedChunk, tempOffset, this.recordSize);
        System.arraycopy(this.fixedChunk, rightOffset, this.fixedChunk, leftOffset, this.recordSize);
        System.arraycopy(this.fixedChunk, tempOffset, this.fixedChunk, rightOffset, this.recordSize);
    }

    private int compare(int leftPosition, int rightPosition) {
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        int rightRecordOffset = this.getRecordOffset(rightPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        byte[] rightVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, leftRecordOffset);
            rightVariableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, rightRecordOffset);
        }
        try {
            long result = this.compareFlatFlat.invokeExact(this.fixedChunk, leftRecordOffset + this.recordElementOffset, leftVariableWidthChunk, this.fixedChunk, rightRecordOffset + this.recordElementOffset, rightVariableWidthChunk);
            return (int)(this.min ? result : -result);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean shouldConsiderValue(ValueBlock right, int rightPosition) {
        byte[] leftFixedRecordChunk = this.fixedChunk;
        int leftRecordOffset = this.getRecordOffset(0);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(leftFixedRecordChunk, leftRecordOffset);
        }
        try {
            long result = this.compareFlatBlock.invokeExact(leftFixedRecordChunk, leftRecordOffset + this.recordElementOffset, leftVariableWidthChunk, right, rightPosition);
            return this.min ? result > 0L : result < 0L;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private int getRecordOffset(int index) {
        return index * this.recordSize;
    }

    public static VariableWidthData compactIfNecessary(VariableWidthData data, byte[] fixedSizeChunk, int fixedRecordSize, int fixedRecordPointerOffset, int recordCount, RelocateVariableWidthOffsets relocateVariableWidthOffsets) {
        int openChunkOffset;
        List<byte[]> chunks = data.getAllChunks();
        double freeRatio = 1.0 * (double)data.getFreeBytes() / (double)data.getAllocatedBytes();
        if (chunks.size() <= 1 || freeRatio < 0.66) {
            return data;
        }
        ArrayList<byte[]> newSlices = new ArrayList<byte[]>();
        int newSize = 0;
        int indexStart = 0;
        for (int i = 0; i < recordCount; ++i) {
            int valueLength = VariableWidthData.getValueLength(fixedSizeChunk, i * fixedRecordSize + fixedRecordPointerOffset);
            if (newSize + valueLength > 0x800000) {
                TypedHeap.moveVariableWidthToNewSlice(data, fixedSizeChunk, fixedRecordSize, fixedRecordPointerOffset, indexStart, i, newSlices, newSize, relocateVariableWidthOffsets);
                indexStart = i;
                newSize = 0;
            }
            newSize += valueLength;
        }
        if (newSize > 0) {
            int openSliceSize = newSize;
            if (newSize < 0x800000) {
                openSliceSize = Math.clamp((long)openSliceSize * 2L, 1024, 0x800000);
            }
            TypedHeap.moveVariableWidthToNewSlice(data, fixedSizeChunk, fixedRecordSize, fixedRecordPointerOffset, indexStart, recordCount, newSlices, openSliceSize, relocateVariableWidthOffsets);
            openChunkOffset = newSize;
        } else {
            openChunkOffset = ((byte[])newSlices.getLast()).length;
        }
        return new VariableWidthData(newSlices, openChunkOffset);
    }

    private static void moveVariableWidthToNewSlice(VariableWidthData sourceData, byte[] fixedSizeChunk, int fixedRecordSize, int fixedRecordPointerOffset, int indexStart, int indexEnd, List<byte[]> newSlices, int newSliceSize, RelocateVariableWidthOffsets relocateVariableWidthOffsets) {
        int newSliceIndex = newSlices.size();
        byte[] newSlice = new byte[newSliceSize];
        newSlices.add(newSlice);
        int newSliceOffset = 0;
        for (int index = indexStart; index < indexEnd; ++index) {
            int fixedChunkOffset = index * fixedRecordSize;
            int pointerOffset = fixedChunkOffset + fixedRecordPointerOffset;
            int variableWidthOffset = VariableWidthData.getChunkOffset(fixedSizeChunk, pointerOffset);
            byte[] variableWidthChunk = sourceData.getChunk(fixedSizeChunk, pointerOffset);
            int variableWidthLength = VariableWidthData.getValueLength(fixedSizeChunk, pointerOffset);
            System.arraycopy(variableWidthChunk, variableWidthOffset, newSlice, newSliceOffset, variableWidthLength);
            VariableWidthData.writePointer(fixedSizeChunk, pointerOffset, newSliceIndex, newSliceOffset, variableWidthLength);
            relocateVariableWidthOffsets.relocate(fixedChunkOffset, newSlice, newSliceOffset);
            newSliceOffset += variableWidthLength;
        }
    }

    public static interface RelocateVariableWidthOffsets {
        public void relocate(int var1, byte[] var2, int var3);
    }
}

