/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OutputFactory;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.PagePartitioner;
import io.trino.operator.output.PagePartitionerPool;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.SkewedPartitionFunction;
import io.trino.operator.output.SkewedPartitionRebalancer;
import io.trino.spi.Mergeable;
import io.trino.spi.Page;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Function<Page, Page> pagePreprocessor;
    private final PagePartitionerPool pagePartitionerPool;
    private final PagePartitioner pagePartitioner;
    private final Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer;
    private final OutputBuffer outputBuffer;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, Function<Page, Page> pagePreprocessor, OutputBuffer outputBuffer, PagePartitionerPool pagePartitionerPool, Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.pagePartitionerPool = Objects.requireNonNull(pagePartitionerPool, "pagePartitionerPool is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.pagePartitioner = Objects.requireNonNull(pagePartitionerPool.poll(), "pagePartitioner is null");
        this.skewedPartitionRebalancer = Objects.requireNonNull(skewedPartitionRebalancer, "skewedPartitionRebalancer is null");
        operatorContext.setInfoSupplier(new PartitionedOutputInfoSupplier(outputBuffer));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.pagePartitioner.prepareForRelease(this.operatorContext);
            this.pagePartitionerPool.release(this.pagePartitioner);
            this.finished = true;
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public void close() throws Exception {
        this.finish();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.outputBuffer.isFull();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0);
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.pagePartitioner.partitionPage(page, this.operatorContext);
        if (this.skewedPartitionRebalancer.isPresent()) {
            SkewedPartitionRebalancer rebalancer = this.skewedPartitionRebalancer.get();
            rebalancer.addDataProcessed(page.getSizeInBytes());
            ((SkewedPartitionFunction)this.pagePartitioner.getPartitionFunction()).flushPartitionRowCountToRebalancer();
            if (!this.outputBuffer.isFull().isDone()) {
                rebalancer.rebalance();
            }
        }
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class PartitionedOutputInfoSupplier
    implements Supplier<PartitionedOutputInfo> {
        private final OutputBuffer outputBuffer;

        PartitionedOutputInfoSupplier(OutputBuffer outputBuffer) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        }

        @Override
        public PartitionedOutputInfo get() {
            return new PartitionedOutputInfo(this.outputBuffer.getPeakMemoryUsage());
        }
    }

    public static class PartitionedOutputInfo
    implements Mergeable<PartitionedOutputInfo>,
    OperatorInfo {
        private final long outputBufferPeakMemoryUsage;

        @JsonCreator
        public PartitionedOutputInfo(@JsonProperty(value="outputBufferPeakMemoryUsage") long outputBufferPeakMemoryUsage) {
            this.outputBufferPeakMemoryUsage = outputBufferPeakMemoryUsage;
        }

        @JsonProperty
        public long getOutputBufferPeakMemoryUsage() {
            return this.outputBufferPeakMemoryUsage;
        }

        public PartitionedOutputInfo mergeWith(PartitionedOutputInfo other) {
            return new PartitionedOutputInfo(Math.max(this.outputBufferPeakMemoryUsage, other.outputBufferPeakMemoryUsage));
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("outputBufferPeakMemoryUsage", this.outputBufferPeakMemoryUsage).toString();
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<NullableValue>> partitionConstants;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final OutputBuffer outputBuffer;
        private final PagesSerdeFactory serdeFactory;
        private final DataSize maxMemory;
        private final PositionsAppenderFactory positionsAppenderFactory;
        private final Optional<Slice> exchangeEncryptionKey;
        private final AggregatedMemoryContext memoryContext;
        private final int pagePartitionerPoolSize;
        private final Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer;
        private final PagePartitionerPool pagePartitionerPool;

        public PartitionedOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory, Optional<Slice> exchangeEncryptionKey, AggregatedMemoryContext memoryContext, int pagePartitionerPoolSize, Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
            this.positionsAppenderFactory = Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
            this.exchangeEncryptionKey = Objects.requireNonNull(exchangeEncryptionKey, "exchangeEncryptionKey is null");
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
            this.pagePartitionerPoolSize = pagePartitionerPoolSize;
            this.skewedPartitionRebalancer = Objects.requireNonNull(skewedPartitionRebalancer, "skewedPartitionRebalancer is null");
            this.pagePartitionerPool = new PagePartitionerPool(pagePartitionerPoolSize, () -> {
                boolean partitionProcessRleAndDictionaryBlocks = true;
                PartitionFunction function = partitionFunction;
                if (skewedPartitionRebalancer.isPresent()) {
                    function = new SkewedPartitionFunction(partitionFunction, (SkewedPartitionRebalancer)skewedPartitionRebalancer.get());
                    partitionProcessRleAndDictionaryBlocks = false;
                }
                return new PagePartitioner(function, partitionChannels, partitionConstants, replicatesAnyRow, nullChannel, outputBuffer, serdeFactory, sourceTypes, maxMemory, positionsAppenderFactory, exchangeEncryptionKey, memoryContext, partitionProcessRleAndDictionaryBlocks);
            });
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.pagePreprocessor, this.outputBuffer, this.pagePartitionerPool, this.skewedPartitionRebalancer);
        }

        @Override
        public void noMoreOperators() {
            this.pagePartitionerPool.close();
        }

        @Override
        public OperatorFactory duplicate() {
            return new PartitionedOutputOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory, this.positionsAppenderFactory, this.exchangeEncryptionKey, this.memoryContext, this.pagePartitionerPoolSize, this.skewedPartitionRebalancer);
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<NullableValue>> partitionConstants;
        private final OutputBuffer outputBuffer;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final DataSize maxMemory;
        private final PositionsAppenderFactory positionsAppenderFactory;
        private final Optional<Slice> exchangeEncryptionKey;
        private final AggregatedMemoryContext memoryContext;
        private final int pagePartitionerPoolSize;
        private final Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer;

        public PartitionedOutputFactory(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory, Optional<Slice> exchangeEncryptionKey, AggregatedMemoryContext memoryContext, int pagePartitionerPoolSize, Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
            this.positionsAppenderFactory = Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
            this.exchangeEncryptionKey = Objects.requireNonNull(exchangeEncryptionKey, "exchangeEncryptionKey is null");
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
            this.pagePartitionerPoolSize = pagePartitionerPoolSize;
            this.skewedPartitionRebalancer = Objects.requireNonNull(skewedPartitionRebalancer, "skewedPartitionRebalancer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new PartitionedOutputOperatorFactory(operatorId, planNodeId, types, pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, serdeFactory, this.maxMemory, this.positionsAppenderFactory, this.exchangeEncryptionKey, this.memoryContext, this.pagePartitionerPoolSize, this.skewedPartitionRebalancer);
        }
    }
}

