/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;
import io.trino.util.Failures;

public final class ArrayVectorFunctions {
    private ArrayVectorFunctions() {
    }

    @Description(value="Calculates the euclidean distance between two vectors")
    @ScalarFunction
    @SqlType(value="double")
    public static double euclideanDistance(@SqlType(value="array(double)") Block first, @SqlType(value="array(double)") Block second) {
        Failures.checkCondition(first.getPositionCount() == second.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "The arguments must have the same length", new Object[0]);
        double sum = 0.0;
        for (int i = 0; i < first.getPositionCount(); ++i) {
            double diff = DoubleType.DOUBLE.getDouble(first, i) - DoubleType.DOUBLE.getDouble(second, i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    @Description(value="Calculates the dot product between two vectors")
    @ScalarFunction
    @SqlType(value="double")
    public static double dotProduct(@SqlType(value="array(double)") Block first, @SqlType(value="array(double)") Block second) {
        Failures.checkCondition(first.getPositionCount() == second.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "The arguments must have the same length", new Object[0]);
        double dotProduct = 0.0;
        for (int i = 0; i < first.getPositionCount(); ++i) {
            dotProduct += DoubleType.DOUBLE.getDouble(first, i) * DoubleType.DOUBLE.getDouble(second, i);
        }
        return dotProduct;
    }

    @Description(value="Calculates the cosine distance between two vectors")
    @ScalarFunction
    @SqlType(value="double")
    public static double cosineDistance(@SqlType(value="array(double)") Block first, @SqlType(value="array(double)") Block second) {
        Failures.checkCondition(first.getPositionCount() == second.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "The arguments must have the same length", new Object[0]);
        double firstMagnitude = 0.0;
        double secondMagnitude = 0.0;
        double dotProduct = 0.0;
        for (int i = 0; i < first.getPositionCount(); ++i) {
            double firstValue = DoubleType.DOUBLE.getDouble(first, i);
            double secondValue = DoubleType.DOUBLE.getDouble(second, i);
            firstMagnitude += firstValue * firstValue;
            secondMagnitude += secondValue * secondValue;
            dotProduct += firstValue * secondValue;
        }
        firstMagnitude = Math.sqrt(firstMagnitude);
        secondMagnitude = Math.sqrt(secondMagnitude);
        Failures.checkCondition(firstMagnitude != 0.0 && secondMagnitude != 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Vector magnitude cannot be zero", new Object[0]);
        double cosineSimilarity = dotProduct / (firstMagnitude * secondMagnitude);
        return 1.0 - cosineSimilarity;
    }
}

