/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.util.Failures;
import java.util.List;

public final class QuantileDigestFunctions {
    public static final double DEFAULT_ACCURACY = 0.01;
    public static final long DEFAULT_WEIGHT = 1L;

    private QuantileDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return FloatingPointBitsConverterUtil.sortableLongToDouble(QuantileDigestFunctions.valueAtQuantileBigint(input, quantile));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="real")
    public static long valueAtQuantileReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="double") double quantile) {
        return Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)QuantileDigestFunctions.valueAtQuantileBigint(input, quantile)));
    }

    @ScalarFunction(value="value_at_quantile")
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="bigint")
    public static long valueAtQuantileBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="double") double quantile) {
        return new QuantileDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="quantile_at_value")
    @Description(value="Given an input x between min/max values of qdigest, find which quantile is represented by that value")
    @SqlType(value="double")
    @SqlNullable
    public static Double quantileAtValueDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="double") double value) {
        return QuantileDigestFunctions.quantileAtValueBigint(input, FloatingPointBitsConverterUtil.doubleToSortableLong(value));
    }

    @ScalarFunction(value="quantile_at_value")
    @Description(value="Given an input x between min/max values of qdigest, find which quantile is represented by that value")
    @SqlType(value="double")
    @SqlNullable
    public static Double quantileAtValueReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="real") long value) {
        return QuantileDigestFunctions.quantileAtValueBigint(input, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)));
    }

    @ScalarFunction(value="quantile_at_value")
    @Description(value="Given an input x between min/max values of qdigest, find which quantile is represented by that value")
    @SqlType(value="double")
    @SqlNullable
    public static Double quantileAtValueBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="bigint") long value) {
        QuantileDigest digest = new QuantileDigest(input);
        if (digest.getCount() == 0.0 || value > digest.getMax() || value < digest.getMin()) {
            return null;
        }
        double bucketCount = ((QuantileDigest.Bucket)Iterables.getOnlyElement((Iterable)digest.getHistogram((List)ImmutableList.of((Object)value)))).getCount();
        return bucketCount / digest.getCount();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="qdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(real)")
    public static Block valuesAtQuantilesReal(@SqlType(value="qdigest(real)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = RealType.REAL.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            RealType.REAL.writeLong(output, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)))));
        }
        return output.build();
    }

    @ScalarFunction(value="values_at_quantiles")
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the qdigest is qn.")
    @SqlType(value="array(bigint)")
    public static Block valuesAtQuantilesBigint(@SqlType(value="qdigest(bigint)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        QuantileDigest digest = new QuantileDigest(input);
        BlockBuilder output = BigintType.BIGINT.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            BigintType.BIGINT.writeLong(output, digest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    public static double verifyAccuracy(double accuracy) {
        Failures.checkCondition(accuracy > 0.0 && accuracy < 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile accuracy must be exclusively between 0 and 1, was %s", accuracy);
        return accuracy;
    }

    public static long verifyWeight(long weight) {
        Failures.checkCondition(weight > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile weight must be > 0, was %s", weight);
        return weight;
    }
}

