/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.IrExpressionOptimizer;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class DynamicPageFilter {
    private final Metadata metadata;
    private final TypeManager typeManager;
    private final Session session;
    private final IrExpressionOptimizer irExpressionOptimizer;
    private final DomainTranslator domainTranslator;
    private final DynamicFilter dynamicFilter;
    private final Map<ColumnHandle, Symbol> columnHandles;
    private final Map<Symbol, Integer> sourceLayout;
    private final double selectivityThreshold;
    @Nullable
    @GuardedBy(value="this")
    private Supplier<FilterEvaluator> compiledDynamicFilter;
    @Nullable
    @GuardedBy(value="this")
    private CompletableFuture<?> isBlocked;

    public DynamicPageFilter(PlannerContext plannerContext, Session session, DynamicFilter dynamicFilter, Map<Symbol, ColumnHandle> columnHandles, Map<Symbol, Integer> sourceLayout, double selectivityThreshold) {
        this.metadata = Objects.requireNonNull(plannerContext.getMetadata(), "metadata is null");
        this.typeManager = Objects.requireNonNull(plannerContext.getTypeManager(), "typeManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.irExpressionOptimizer = IrExpressionOptimizer.newOptimizer(plannerContext);
        this.domainTranslator = new DomainTranslator(plannerContext.getMetadata());
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        this.columnHandles = (Map)columnHandles.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey));
        this.sourceLayout = ImmutableMap.copyOf(sourceLayout);
        this.selectivityThreshold = selectivityThreshold;
        this.isBlocked = dynamicFilter.isBlocked();
    }

    public synchronized Supplier<FilterEvaluator> createDynamicPageFilterEvaluator(ColumnarFilterCompiler compiler) {
        if (this.isBlocked == null) {
            return this.compiledDynamicFilter;
        }
        if (this.compiledDynamicFilter == null || this.isBlocked.isDone()) {
            this.isBlocked = this.dynamicFilter.isBlocked();
            boolean isAwaitable = this.dynamicFilter.isAwaitable();
            TupleDomain currentPredicate = this.dynamicFilter.getCurrentPredicate().transformKeys(this.columnHandles::get);
            List expressionConjuncts = (List)this.domainTranslator.toPredicateConjuncts((TupleDomain<Symbol>)currentPredicate).stream().map(expression -> this.irExpressionOptimizer.process((Expression)expression, this.session, (Map<Symbol, Expression>)ImmutableMap.of()).orElse((Expression)expression)).collect(ImmutableList.toImmutableList());
            List rowExpression = (List)expressionConjuncts.stream().map(expression -> SqlToRowExpressionTranslator.translate(expression, this.sourceLayout, this.metadata, this.typeManager)).collect(ImmutableList.toImmutableList());
            this.compiledDynamicFilter = DynamicPageFilter.createDynamicFilterEvaluator(rowExpression, compiler, this.selectivityThreshold);
            if (!isAwaitable) {
                this.isBlocked = null;
            }
        }
        return this.compiledDynamicFilter;
    }

    private static Supplier<FilterEvaluator> createDynamicFilterEvaluator(List<RowExpression> rowExpressions, ColumnarFilterCompiler compiler, double selectivityThreshold) {
        List subExpressionEvaluators = (List)rowExpressions.stream().map(expression -> FilterEvaluator.createColumnarFilterEvaluator(expression, compiler)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        return () -> new DynamicFilterEvaluator((List)subExpressionEvaluators.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()), selectivityThreshold);
    }

    static final class DynamicFilterEvaluator
    implements FilterEvaluator {
        private final List<FilterEvaluator> subFilterEvaluators;
        private final EffectiveFilterProfiler profiler;

        private DynamicFilterEvaluator(List<FilterEvaluator> subFilterEvaluators, double selectivityThreshold) {
            this.subFilterEvaluators = subFilterEvaluators;
            this.profiler = new EffectiveFilterProfiler(selectivityThreshold, subFilterEvaluators.size());
        }

        @Override
        public FilterEvaluator.SelectionResult evaluate(ConnectorSession session, SelectedPositions activePositions, Page page) {
            long filterTimeNanos = 0L;
            for (int filterIndex = 0; filterIndex < this.subFilterEvaluators.size(); ++filterIndex) {
                if (!this.profiler.isFilterEffective(filterIndex)) continue;
                FilterEvaluator evaluator = this.subFilterEvaluators.get(filterIndex);
                FilterEvaluator.SelectionResult result = evaluator.evaluate(session, activePositions, page);
                this.profiler.recordSelectivity(activePositions, result.selectedPositions(), filterIndex);
                filterTimeNanos += result.filterTimeNanos();
                activePositions = result.selectedPositions();
            }
            return new FilterEvaluator.SelectionResult(activePositions, filterTimeNanos);
        }
    }

    private static class EffectiveFilterProfiler {
        private static final int MIN_SAMPLE_POSITIONS = 2047;
        private final double selectivityThreshold;
        private final long[] filterInputPositions;
        private final long[] filterOutputPositions;
        private final IntOpenHashSet ineffectiveFilterChannels;

        private EffectiveFilterProfiler(double selectivityThreshold, int filterCount) {
            this.selectivityThreshold = selectivityThreshold;
            this.filterInputPositions = new long[filterCount];
            this.filterOutputPositions = new long[filterCount];
            this.ineffectiveFilterChannels = new IntOpenHashSet(filterCount);
        }

        private void recordSelectivity(SelectedPositions inputPositions, SelectedPositions selectedPositions, int filterIndex) {
            int n = filterIndex;
            this.filterInputPositions[n] = this.filterInputPositions[n] + (long)inputPositions.size();
            int n2 = filterIndex;
            this.filterOutputPositions[n2] = this.filterOutputPositions[n2] + (long)selectedPositions.size();
            if (this.filterInputPositions[filterIndex] < 2047L) {
                return;
            }
            if ((double)this.filterOutputPositions[filterIndex] > this.selectivityThreshold * (double)this.filterInputPositions[filterIndex]) {
                this.ineffectiveFilterChannels.add(filterIndex);
            }
        }

        private boolean isFilterEffective(int filterIndex) {
            return !this.ineffectiveFilterChannels.contains(filterIndex);
        }
    }
}

