/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Set;

public class PruneIntersectSourceColumns
implements Rule<IntersectNode> {
    @Override
    public Pattern<IntersectNode> getPattern() {
        return Patterns.intersect();
    }

    @Override
    public Rule.Result apply(IntersectNode node, Captures captures, Rule.Context context) {
        Set[] referencedInputs = new Set[node.getSources().size()];
        for (int i = 0; i < node.getSources().size(); ++i) {
            referencedInputs[i] = ImmutableSet.copyOf(node.sourceOutputLayout(i));
        }
        return Util.restrictChildOutputs(context.getIdAllocator(), node, referencedInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

