/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLongArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Long[] expectedValues = TestLongArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestLongArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Long[] expectedValues = TestLongArrayBlock.alternatingNullValues(TestLongArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestLongArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Long[] expectedValues = TestLongArrayBlock.createTestValue(100);
        LongArrayBlockBuilder emptyBlockBuilder = new LongArrayBlockBuilder(null, 0);
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestLongArrayBlock.writeValues(expectedValues, blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = (LongArrayBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        BlockBuilder blockBuilder = TestLongArrayBlock.createBlockBuilderWithValues(TestLongArrayBlock.createTestValue(100));
        Block block = blockBuilder.build();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo(8L);
        }
        Assertions.assertThat((long)new LongArrayBlockBuilder(null, 22).appendNull().build().getEstimatedDataSizeForStats(0)).isEqualTo(0L);
    }

    @Test
    public void testCompactBlock() {
        long[] longArray = new long[]{0L, 0L, 1L, 2L, 3L, 4L};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestLongArrayBlock.testCompactBlock((Block)new LongArrayBlock(0, Optional.empty(), new long[0]));
        TestLongArrayBlock.testCompactBlock((Block)new LongArrayBlock(longArray.length, Optional.of(valueIsNull), longArray));
        TestLongArrayBlock.testNotCompactBlock((Block)new LongArrayBlock(longArray.length - 1, Optional.of(valueIsNull), longArray));
    }

    private void assertFixedWithValues(Long[] expectedValues) {
        Block block = TestLongArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Long[] expectedValues) {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, expectedValues.length);
        TestLongArrayBlock.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Long[] expectedValues, LongArrayBlockBuilder blockBuilder) {
        for (Long expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeLong(expectedValue.longValue());
        }
    }

    private static Long[] createTestValue(int positionCount) {
        Long[] expectedValues = new Long[positionCount];
        Random random = new Random(0L);
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = random.nextLong();
        }
        return expectedValues;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        Assertions.assertThat((long)((LongArrayBlock)block).getLong(position)).isEqualTo(((Long)expectedValue).longValue());
    }
}

