/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.AllowAllGrants;
import io.trino.connector.Grants;
import io.trino.connector.MockConnector;
import io.trino.connector.MockConnectorAccessControl;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;

public class MockConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final List<PropertyMetadata<?>> sessionProperty;
    private final Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper;
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<String>> listTables;
    private final Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>>> streamTableColumns;
    private final Optional<StreamRelationColumns> streamRelationColumns;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final Supplier<List<PropertyMetadata<?>>> getViewProperties;
    private final Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews;
    private final BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector;
    private final BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final Function<SchemaTableName, Optional<String>> getComment;
    private final Function<SchemaTableName, TableStatistics> getTableStatistics;
    private final Function<SchemaTableName, List<String>> checkConstraints;
    private final ApplyProjection applyProjection;
    private final ApplyAggregation applyAggregation;
    private final ApplyJoin applyJoin;
    private final ApplyTopN applyTopN;
    private final ApplyFilter applyFilter;
    private final ApplyTableFunction applyTableFunction;
    private final ApplyTableScanRedirect applyTableScanRedirect;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout;
    private final BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType;
    private final BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges;
    private final Supplier<Iterable<EventListener>> eventListeners;
    private final Collection<FunctionMetadata> functions;
    private final Function<SchemaTableName, List<List<?>>> data;
    private final Function<SchemaTableName, Metrics> metrics;
    private final Set<Procedure> procedures;
    private final Set<TableProcedureMetadata> tableProcedures;
    private final Set<ConnectorTableFunction> tableFunctions;
    private final Optional<FunctionProvider> functionProvider;
    private final boolean allowMissingColumnsOnInsert;
    private final Supplier<List<PropertyMetadata<?>>> analyzeProperties;
    private final Supplier<List<PropertyMetadata<?>>> schemaProperties;
    private final Supplier<List<PropertyMetadata<?>>> tableProperties;
    private final Supplier<List<PropertyMetadata<?>>> columnProperties;
    private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
    private final Function<ConnectorTableFunctionHandle, ConnectorSplitSource> tableFunctionSplitsSources;
    private final ListRoleGrants roleGrants;
    private final Optional<ConnectorAccessControl> accessControl;
    private final OptionalInt maxWriterTasks;
    private final BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute;
    private final WriterScalingOptions writerScalingOptions;
    private final Supplier<Set<ConnectorCapabilities>> capabilities;

    private MockConnectorFactory(String name, List<PropertyMetadata<?>> sessionProperty, Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper, Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<String>> listTables, Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>>> streamTableColumns, Optional<StreamRelationColumns> streamRelationColumns, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, Supplier<List<PropertyMetadata<?>>> getViewProperties, Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews, BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector, BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, Function<SchemaTableName, Optional<String>> getComment, Function<SchemaTableName, TableStatistics> getTableStatistics, Function<SchemaTableName, List<String>> checkConstraints, ApplyProjection applyProjection, ApplyAggregation applyAggregation, ApplyJoin applyJoin, ApplyTopN applyTopN, ApplyFilter applyFilter, ApplyTableFunction applyTableFunction, ApplyTableScanRedirect applyTableScanRedirect, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout, BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType, BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties, BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges, Supplier<Iterable<EventListener>> eventListeners, Collection<FunctionMetadata> functions, Function<SchemaTableName, List<List<?>>> data, Function<SchemaTableName, Metrics> metrics, Set<Procedure> procedures, Set<TableProcedureMetadata> tableProcedures, Set<ConnectorTableFunction> tableFunctions, Optional<FunctionProvider> functionProvider, Supplier<List<PropertyMetadata<?>>> analyzeProperties, Supplier<List<PropertyMetadata<?>>> schemaProperties, Supplier<List<PropertyMetadata<?>>> tableProperties, Supplier<List<PropertyMetadata<?>>> columnProperties, Optional<ConnectorNodePartitioningProvider> partitioningProvider, ListRoleGrants roleGrants, Optional<ConnectorAccessControl> accessControl, boolean allowMissingColumnsOnInsert, Function<ConnectorTableFunctionHandle, ConnectorSplitSource> tableFunctionSplitsSources, OptionalInt maxWriterTasks, BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute, WriterScalingOptions writerScalingOptions, Supplier<Set<ConnectorCapabilities>> capabilities) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.sessionProperty = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperty, "sessionProperty is null"));
        this.metadataWrapper = Objects.requireNonNull(metadataWrapper, "metadataWrapper is null");
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.streamTableColumns = Objects.requireNonNull(streamTableColumns, "streamTableColumns is null");
        this.streamRelationColumns = Objects.requireNonNull(streamRelationColumns, "streamRelationColumns is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getViewProperties = Objects.requireNonNull(getViewProperties, "getViewProperties is null");
        this.getMaterializedViewProperties = Objects.requireNonNull(getMaterializedViewProperties, "getMaterializedViewProperties is null");
        this.getMaterializedViews = Objects.requireNonNull(getMaterializedViews, "getMaterializedViews is null");
        this.delegateMaterializedViewRefreshToConnector = Objects.requireNonNull(delegateMaterializedViewRefreshToConnector, "delegateMaterializedViewRefreshToConnector is null");
        this.refreshMaterializedView = Objects.requireNonNull(refreshMaterializedView, "refreshMaterializedView is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
        this.getComment = Objects.requireNonNull(getComment, "getComment is null");
        this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getTableStatistics is null");
        this.checkConstraints = Objects.requireNonNull(checkConstraints, "checkConstraints is null");
        this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
        this.applyAggregation = Objects.requireNonNull(applyAggregation, "applyAggregation is null");
        this.applyJoin = Objects.requireNonNull(applyJoin, "applyJoin is null");
        this.applyTopN = Objects.requireNonNull(applyTopN, "applyTopN is null");
        this.applyFilter = Objects.requireNonNull(applyFilter, "applyFilter is null");
        this.applyTableFunction = Objects.requireNonNull(applyTableFunction, "applyTableFunction is null");
        this.applyTableScanRedirect = Objects.requireNonNull(applyTableScanRedirect, "applyTableScanRedirection is null");
        this.redirectTable = Objects.requireNonNull(redirectTable, "redirectTable is null");
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.getSupportedType = Objects.requireNonNull(getSupportedType, "getSupportedType is null");
        this.getTableProperties = Objects.requireNonNull(getTableProperties, "getTableProperties is null");
        this.listTablePrivileges = Objects.requireNonNull(listTablePrivileges, "listTablePrivileges is null");
        this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
        this.functions = ImmutableList.copyOf(functions);
        this.analyzeProperties = Objects.requireNonNull(analyzeProperties, "analyzeProperties is null");
        this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
        this.columnProperties = Objects.requireNonNull(columnProperties, "columnProperties is null");
        this.partitioningProvider = Objects.requireNonNull(partitioningProvider, "partitioningProvider is null");
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
        this.procedures = Objects.requireNonNull(procedures, "procedures is null");
        this.tableProcedures = Objects.requireNonNull(tableProcedures, "tableProcedures is null");
        this.tableFunctions = Objects.requireNonNull(tableFunctions, "tableFunctions is null");
        this.functionProvider = Objects.requireNonNull(functionProvider, "functionProvider is null");
        this.allowMissingColumnsOnInsert = allowMissingColumnsOnInsert;
        this.tableFunctionSplitsSources = Objects.requireNonNull(tableFunctionSplitsSources, "tableFunctionSplitsSources is null");
        this.maxWriterTasks = maxWriterTasks;
        this.getLayoutForTableExecute = Objects.requireNonNull(getLayoutForTableExecute, "getLayoutForTableExecute is null");
        this.writerScalingOptions = Objects.requireNonNull(writerScalingOptions, "writerScalingOptions is null");
        this.capabilities = Objects.requireNonNull(capabilities, "capabilities is null");
    }

    public String getName() {
        return this.name;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new MockConnector(this.metadataWrapper, this.sessionProperty, this.listSchemaNames, this.listTables, this.streamTableColumns, this.streamRelationColumns, this.getViews, this.getViewProperties, this.getMaterializedViewProperties, this.getMaterializedViews, this.delegateMaterializedViewRefreshToConnector, this.refreshMaterializedView, this.getTableHandle, this.getColumns, this.getComment, this.getTableStatistics, this.checkConstraints, this.applyProjection, this.applyAggregation, this.applyJoin, this.applyTopN, this.applyFilter, this.applyTableFunction, this.applyTableScanRedirect, this.redirectTable, this.getInsertLayout, this.getNewTableLayout, this.getSupportedType, this.getTableProperties, this.listTablePrivileges, this.eventListeners, this.functions, this.roleGrants, this.partitioningProvider, this.accessControl, this.data, this.metrics, this.procedures, this.tableProcedures, this.tableFunctions, this.functionProvider, this.allowMissingColumnsOnInsert, this.analyzeProperties, this.schemaProperties, this.tableProperties, this.columnProperties, this.tableFunctionSplitsSources, this.maxWriterTasks, this.getLayoutForTableExecute, this.writerScalingOptions, this.capabilities);
    }

    public static MockConnectorFactory create() {
        return MockConnectorFactory.builder().build();
    }

    public static MockConnectorFactory create(String name) {
        return MockConnectorFactory.builder().withName(name).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface ApplyProjection {
        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, List<ConnectorExpression> var3, Map<String, ColumnHandle> var4);
    }

    @FunctionalInterface
    public static interface ApplyAggregation {
        public Optional<AggregationApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, List<AggregateFunction> var3, Map<String, ColumnHandle> var4, List<List<ColumnHandle>> var5);
    }

    @FunctionalInterface
    public static interface ApplyJoin {
        public Optional<JoinApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, JoinType var2, ConnectorTableHandle var3, ConnectorTableHandle var4, List<JoinCondition> var5, Map<String, ColumnHandle> var6, Map<String, ColumnHandle> var7);
    }

    @FunctionalInterface
    public static interface ApplyTopN {
        public Optional<TopNApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, long var3, List<SortItem> var5, Map<String, ColumnHandle> var6);
    }

    @FunctionalInterface
    public static interface ApplyFilter {
        public Optional<ConstraintApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, Constraint var3);
    }

    @FunctionalInterface
    public static interface ApplyTableFunction {
        public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableFunctionHandle var2);
    }

    @FunctionalInterface
    public static interface ApplyTableScanRedirect {
        public Optional<TableScanRedirectApplicationResult> apply(ConnectorSession var1, ConnectorTableHandle var2);
    }

    @FunctionalInterface
    public static interface ListRoleGrants {
        public Set<RoleGrant> apply(ConnectorSession var1, Optional<Set<String>> var2, Optional<Set<String>> var3, OptionalLong var4);
    }

    public static final class Builder {
        private String name = "mock";
        private final List<PropertyMetadata<?>> sessionProperties = new ArrayList();
        private Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper = Function.identity();
        private Function<ConnectorSession, List<String>> listSchemaNames = Builder.defaultListSchemaNames();
        private BiFunction<ConnectorSession, String, List<String>> listTables = Builder.defaultListTables();
        private Optional<BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>>> streamTableColumns = Optional.empty();
        private Optional<StreamRelationColumns> streamRelationColumns = Optional.empty();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews = Builder.defaultGetViews();
        private Supplier<List<PropertyMetadata<?>>> getViewProperties = Builder.defaultGetViewProperties();
        private Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties = Builder.defaultGetMaterializedViewProperties();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews = Builder.defaultGetMaterializedViews();
        private BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector = (session, viewName) -> false;
        private BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView = (session, viewName) -> CompletableFuture.completedFuture(null);
        private BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle = Builder.defaultGetTableHandle();
        private Function<SchemaTableName, List<ColumnMetadata>> getColumns = Builder.defaultGetColumns();
        private Function<SchemaTableName, Optional<String>> getComment = schemaTableName -> Optional.empty();
        private Function<SchemaTableName, TableStatistics> getTableStatistics = schemaTableName -> TableStatistics.empty();
        private Function<SchemaTableName, List<String>> checkConstraints = schemaTableName -> ImmutableList.of();
        private ApplyProjection applyProjection = (session, handle, projections, assignments) -> Optional.empty();
        private ApplyAggregation applyAggregation = (session, handle, aggregates, assignments, groupingSets) -> Optional.empty();
        private ApplyJoin applyJoin = (session, joinType, left, right, joinConditions, leftAssignments, rightAssignments) -> Optional.empty();
        private BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout = Builder.defaultGetInsertLayout();
        private BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout = Builder.defaultGetNewTableLayout();
        private BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType = (session, type) -> Optional.empty();
        private BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties = Builder.defaultGetTableProperties();
        private BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges = Builder.defaultListTablePrivileges();
        private Supplier<Iterable<EventListener>> eventListeners = ImmutableList::of;
        private Collection<FunctionMetadata> functions = ImmutableList.of();
        private ApplyTopN applyTopN = (session, handle, topNCount, sortItems, assignments) -> Optional.empty();
        private ApplyFilter applyFilter = (session, handle, constraint) -> Optional.empty();
        private ApplyTableFunction applyTableFunction = (session, handle) -> Optional.empty();
        private ApplyTableScanRedirect applyTableScanRedirect = (session, handle) -> Optional.empty();
        private BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable = (session, tableName) -> Optional.empty();
        private Function<SchemaTableName, List<List<?>>> data = schemaTableName -> ImmutableList.of();
        private Function<SchemaTableName, Metrics> metrics = schemaTableName -> Metrics.EMPTY;
        private Set<Procedure> procedures = ImmutableSet.of();
        private Set<TableProcedureMetadata> tableProcedures = ImmutableSet.of();
        private Set<ConnectorTableFunction> tableFunctions = ImmutableSet.of();
        private Optional<FunctionProvider> functionProvider = Optional.empty();
        private Supplier<List<PropertyMetadata<?>>> analyzeProperties = ImmutableList::of;
        private Supplier<List<PropertyMetadata<?>>> schemaProperties = ImmutableList::of;
        private Supplier<List<PropertyMetadata<?>>> tableProperties = ImmutableList::of;
        private Supplier<List<PropertyMetadata<?>>> columnProperties = ImmutableList::of;
        private Optional<ConnectorNodePartitioningProvider> partitioningProvider = Optional.empty();
        private Function<ConnectorTableFunctionHandle, ConnectorSplitSource> tableFunctionSplitsSources = handle -> null;
        private boolean provideAccessControl;
        private ListRoleGrants roleGrants = Builder.defaultRoleAuthorizations();
        private Grants<String> schemaGrants = new AllowAllGrants<String>();
        private Grants<SchemaTableName> tableGrants = new AllowAllGrants<SchemaTableName>();
        private Function<SchemaTableName, ViewExpression> rowFilter = tableName -> null;
        private BiFunction<SchemaTableName, String, ViewExpression> columnMask = (tableName, columnName) -> null;
        private boolean allowMissingColumnsOnInsert;
        private OptionalInt maxWriterTasks = OptionalInt.empty();
        private BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute = (session, handle) -> Optional.empty();
        private WriterScalingOptions writerScalingOptions = WriterScalingOptions.DISABLED;
        private Supplier<Set<ConnectorCapabilities>> capabilities = ImmutableSet::of;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
            return this;
        }

        public Builder withSessionProperty(PropertyMetadata<?> sessionProperty) {
            this.sessionProperties.add(sessionProperty);
            return this;
        }

        public Builder withSessionProperties(Iterable<PropertyMetadata<?>> sessionProperties) {
            for (PropertyMetadata<?> sessionProperty : sessionProperties) {
                this.withSessionProperty(sessionProperty);
            }
            return this;
        }

        public Builder withMetadataWrapper(Function<ConnectorMetadata, ConnectorMetadata> metadataWrapper) {
            this.metadataWrapper = Objects.requireNonNull(metadataWrapper, "metadataWrapper is null");
            return this;
        }

        public Builder withListSchemaNames(Function<ConnectorSession, List<String>> listSchemaNames) {
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            return this;
        }

        public Builder withListTables(BiFunction<ConnectorSession, String, List<String>> listTables) {
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            return this;
        }

        public Builder withStreamTableColumns(BiFunction<ConnectorSession, SchemaTablePrefix, Iterator<TableColumnsMetadata>> streamTableColumns) {
            this.streamTableColumns = Optional.of(Objects.requireNonNull(streamTableColumns, "streamTableColumns is null"));
            return this;
        }

        public Builder withStreamRelationColumns(StreamRelationColumns streamRelationColumns) {
            this.streamRelationColumns = Optional.of(streamRelationColumns);
            return this;
        }

        public Builder withGetViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews) {
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            return this;
        }

        public Builder withGetViewProperties(Supplier<List<PropertyMetadata<?>>> getViewProperties) {
            this.getViewProperties = Objects.requireNonNull(getViewProperties, "getViewProperties is null");
            return this;
        }

        public Builder withGetMaterializedViewProperties(Supplier<List<PropertyMetadata<?>>> getMaterializedViewProperties) {
            this.getMaterializedViewProperties = Objects.requireNonNull(getMaterializedViewProperties, "getMaterializedViewProperties is null");
            return this;
        }

        public Builder withGetMaterializedViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> getMaterializedViews) {
            this.getMaterializedViews = Objects.requireNonNull(getMaterializedViews, "getMaterializedViews is null");
            return this;
        }

        public Builder withDelegateMaterializedViewRefreshToConnector(BiFunction<ConnectorSession, SchemaTableName, Boolean> delegateMaterializedViewRefreshToConnector) {
            this.delegateMaterializedViewRefreshToConnector = Objects.requireNonNull(delegateMaterializedViewRefreshToConnector, "delegateMaterializedViewRefreshToConnector is null");
            return this;
        }

        public Builder withRefreshMaterializedView(BiFunction<ConnectorSession, SchemaTableName, CompletableFuture<?>> refreshMaterializedView) {
            this.refreshMaterializedView = Objects.requireNonNull(refreshMaterializedView, "refreshMaterializedView is null");
            return this;
        }

        public Builder withGetTableHandle(BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle) {
            this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
            return this;
        }

        public Builder withGetColumns(Function<SchemaTableName, List<ColumnMetadata>> getColumns) {
            this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
            return this;
        }

        public Builder withGetComment(Function<SchemaTableName, Optional<String>> getComment) {
            this.getComment = Objects.requireNonNull(getComment, "getComment is null");
            return this;
        }

        public Builder withGetTableStatistics(Function<SchemaTableName, TableStatistics> getTableStatistics) {
            this.getTableStatistics = Objects.requireNonNull(getTableStatistics, "getColumns is null");
            return this;
        }

        public Builder withCheckConstraints(Function<SchemaTableName, List<String>> checkConstraints) {
            this.checkConstraints = Objects.requireNonNull(checkConstraints, "checkConstraints is null");
            return this;
        }

        public Builder withApplyProjection(ApplyProjection applyProjection) {
            this.applyProjection = applyProjection;
            return this;
        }

        public Builder withApplyAggregation(ApplyAggregation applyAggregation) {
            this.applyAggregation = applyAggregation;
            return this;
        }

        public Builder withApplyJoin(ApplyJoin applyJoin) {
            this.applyJoin = applyJoin;
            return this;
        }

        public Builder withApplyTopN(ApplyTopN applyTopN) {
            this.applyTopN = applyTopN;
            return this;
        }

        public Builder withApplyFilter(ApplyFilter applyFilter) {
            this.applyFilter = applyFilter;
            return this;
        }

        public Builder withApplyTableFunction(ApplyTableFunction applyTableFunction) {
            this.applyTableFunction = applyTableFunction;
            return this;
        }

        public Builder withApplyTableScanRedirect(ApplyTableScanRedirect applyTableScanRedirect) {
            this.applyTableScanRedirect = applyTableScanRedirect;
            return this;
        }

        public Builder withRedirectTable(BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> redirectTable) {
            this.redirectTable = Objects.requireNonNull(redirectTable, "redirectTable is null");
            return this;
        }

        public Builder withGetInsertLayout(BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> getInsertLayout) {
            this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
            return this;
        }

        public Builder withGetNewTableLayout(BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> getNewTableLayout) {
            this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
            return this;
        }

        public Builder withGetSupportedType(BiFunction<ConnectorSession, Type, Optional<Type>> getSupportedType) {
            this.getSupportedType = Objects.requireNonNull(getSupportedType, "getSupportedType is null");
            return this;
        }

        public Builder withGetLayoutForTableExecute(BiFunction<ConnectorSession, ConnectorTableExecuteHandle, Optional<ConnectorTableLayout>> getLayoutForTableExecute) {
            this.getLayoutForTableExecute = Objects.requireNonNull(getLayoutForTableExecute, "getLayoutForTableExecute is null");
            return this;
        }

        public Builder withGetTableProperties(BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> getTableProperties) {
            this.getTableProperties = Objects.requireNonNull(getTableProperties, "getTableProperties is null");
            return this;
        }

        public Builder withListTablePrivileges(BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> listTablePrivileges) {
            this.provideAccessControl = true;
            this.listTablePrivileges = Objects.requireNonNull(listTablePrivileges, "listTablePrivileges is null");
            return this;
        }

        public Builder withEventListener(EventListener listener) {
            Objects.requireNonNull(listener, "listener is null");
            this.withEventListener(() -> listener);
            return this;
        }

        public Builder withEventListener(Supplier<EventListener> listenerFactory) {
            Objects.requireNonNull(listenerFactory, "listenerFactory is null");
            this.eventListeners = () -> ImmutableList.of((Object)((EventListener)listenerFactory.get()));
            return this;
        }

        public Builder withFunctions(Collection<FunctionMetadata> functions) {
            Objects.requireNonNull(functions, "functions is null");
            this.functions = ImmutableList.copyOf(functions);
            return this;
        }

        public Builder withData(Function<SchemaTableName, List<List<?>>> data) {
            this.data = Objects.requireNonNull(data, "data is null");
            return this;
        }

        public Builder withMetrics(Function<SchemaTableName, Metrics> metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics is null");
            return this;
        }

        public Builder withProcedures(Iterable<Procedure> procedures) {
            this.procedures = ImmutableSet.copyOf(procedures);
            return this;
        }

        public Builder withTableProcedures(Iterable<TableProcedureMetadata> tableProcedures) {
            this.tableProcedures = ImmutableSet.copyOf(tableProcedures);
            return this;
        }

        public Builder withTableFunctions(Iterable<ConnectorTableFunction> tableFunctions) {
            this.tableFunctions = ImmutableSet.copyOf(tableFunctions);
            return this;
        }

        public Builder withFunctionProvider(Optional<FunctionProvider> functionProvider) {
            this.functionProvider = Objects.requireNonNull(functionProvider, "functionProvider is null");
            return this;
        }

        public Builder withAnalyzeProperties(Supplier<List<PropertyMetadata<?>>> analyzeProperties) {
            this.analyzeProperties = Objects.requireNonNull(analyzeProperties, "analyzeProperties is null");
            return this;
        }

        public Builder withSchemaProperties(Supplier<List<PropertyMetadata<?>>> schemaProperties) {
            this.schemaProperties = Objects.requireNonNull(schemaProperties, "schemaProperties is null");
            return this;
        }

        public Builder withTableProperties(Supplier<List<PropertyMetadata<?>>> tableProperties) {
            this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
            return this;
        }

        public Builder withColumnProperties(Supplier<List<PropertyMetadata<?>>> columnProperties) {
            this.columnProperties = Objects.requireNonNull(columnProperties, "columnProperties is null");
            return this;
        }

        public Builder withPartitionProvider(ConnectorNodePartitioningProvider partitioningProvider) {
            this.partitioningProvider = Optional.of(partitioningProvider);
            return this;
        }

        public Builder withTableFunctionSplitSources(Function<ConnectorTableFunctionHandle, ConnectorSplitSource> sourceProvider) {
            this.tableFunctionSplitsSources = Objects.requireNonNull(sourceProvider, "sourceProvider is null");
            return this;
        }

        public Builder withListRoleGrants(ListRoleGrants roleGrants) {
            this.provideAccessControl = true;
            this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
            return this;
        }

        public Builder withSchemaGrants(Grants<String> schemaGrants) {
            this.provideAccessControl = true;
            this.schemaGrants = schemaGrants;
            return this;
        }

        public Builder withTableGrants(Grants<SchemaTableName> tableGrants) {
            this.provideAccessControl = true;
            this.tableGrants = tableGrants;
            return this;
        }

        public Builder withRowFilter(Function<SchemaTableName, ViewExpression> rowFilter) {
            this.provideAccessControl = true;
            this.rowFilter = rowFilter;
            return this;
        }

        public Builder withColumnMask(BiFunction<SchemaTableName, String, ViewExpression> columnMask) {
            this.provideAccessControl = true;
            this.columnMask = columnMask;
            return this;
        }

        public Builder withMaxWriterTasks(OptionalInt maxWriterTasks) {
            this.maxWriterTasks = maxWriterTasks;
            return this;
        }

        public Builder withAllowMissingColumnsOnInsert(boolean allowMissingColumnsOnInsert) {
            this.allowMissingColumnsOnInsert = allowMissingColumnsOnInsert;
            return this;
        }

        public Builder withWriterScalingOptions(WriterScalingOptions writerScalingOptions) {
            this.writerScalingOptions = writerScalingOptions;
            return this;
        }

        public Builder withCapabilities(Supplier<Set<ConnectorCapabilities>> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public MockConnectorFactory build() {
            Optional<ConnectorAccessControl> accessControl = Optional.empty();
            if (this.provideAccessControl) {
                accessControl = Optional.of(new MockConnectorAccessControl(this.schemaGrants, this.tableGrants, this.rowFilter, this.columnMask));
            }
            return new MockConnectorFactory(this.name, this.sessionProperties, this.metadataWrapper, this.listSchemaNames, this.listTables, this.streamTableColumns, this.streamRelationColumns, this.getViews, this.getViewProperties, this.getMaterializedViewProperties, this.getMaterializedViews, this.delegateMaterializedViewRefreshToConnector, this.refreshMaterializedView, this.getTableHandle, this.getColumns, this.getComment, this.getTableStatistics, this.checkConstraints, this.applyProjection, this.applyAggregation, this.applyJoin, this.applyTopN, this.applyFilter, this.applyTableFunction, this.applyTableScanRedirect, this.redirectTable, this.getInsertLayout, this.getNewTableLayout, this.getSupportedType, this.getTableProperties, this.listTablePrivileges, this.eventListeners, this.functions, this.data, this.metrics, this.procedures, this.tableProcedures, this.tableFunctions, this.functionProvider, this.analyzeProperties, this.schemaProperties, this.tableProperties, this.columnProperties, this.partitioningProvider, this.roleGrants, accessControl, this.allowMissingColumnsOnInsert, this.tableFunctionSplitsSources, this.maxWriterTasks, this.getLayoutForTableExecute, this.writerScalingOptions, this.capabilities);
        }

        public static Function<ConnectorSession, List<String>> defaultListSchemaNames() {
            return session -> ImmutableList.of();
        }

        public static ListRoleGrants defaultRoleAuthorizations() {
            return (session, roles, grantees, limit) -> ImmutableSet.of();
        }

        public static BiFunction<ConnectorSession, String, List<String>> defaultListTables() {
            return (session, schemaName) -> ImmutableList.of();
        }

        public static BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> defaultGetViews() {
            return (session, schemaTablePrefix) -> ImmutableMap.of();
        }

        public static Supplier<List<PropertyMetadata<?>>> defaultGetViewProperties() {
            return ImmutableList::of;
        }

        public static Supplier<List<PropertyMetadata<?>>> defaultGetMaterializedViewProperties() {
            return ImmutableList::of;
        }

        public static BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>> defaultGetMaterializedViews() {
            return (session, schemaTablePrefix) -> ImmutableMap.of();
        }

        public static BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> defaultGetTableHandle() {
            return (session, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName);
        }

        public static BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorTableLayout>> defaultGetInsertLayout() {
            return (session, schemaTableName) -> Optional.empty();
        }

        public static BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorTableLayout>> defaultGetNewTableLayout() {
            return (session, tableMetadata) -> Optional.empty();
        }

        public static BiFunction<ConnectorSession, ConnectorTableHandle, ConnectorTableProperties> defaultGetTableProperties() {
            return (session, tableHandle) -> new ConnectorTableProperties();
        }

        public static BiFunction<ConnectorSession, SchemaTablePrefix, List<GrantInfo>> defaultListTablePrivileges() {
            return (session, tableHandle) -> ImmutableList.of();
        }

        public static Function<SchemaTableName, List<ColumnMetadata>> defaultGetColumns() {
            return table -> (List)IntStream.range(0, 100).boxed().map(i -> new ColumnMetadata("column_" + i, (Type)VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        }
    }

    @FunctionalInterface
    public static interface StreamRelationColumns {
        public Iterator<RelationColumnsMetadata> apply(ConnectorSession var1, Optional<String> var2, UnaryOperator<Set<SchemaTableName>> var3);
    }
}

