/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.type.UnknownType;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestValuesNodeStats
extends BaseStatsCalculatorTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction DIVIDE_INTEGER = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    public void testStatsForValuesNode() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)pb.symbol("b", (Type)DoubleType.DOUBLE)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)6L), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)13.5)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)55L), (Object)new Constant((Type)DoubleType.DOUBLE, null)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)6L), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)13.5))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(3.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "a"), SymbolStatsEstimate.builder().setNullsFraction(0.0).setLowValue(6.0).setHighValue(55.0).setDistinctValuesCount(2.0).build()).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "b"), SymbolStatsEstimate.builder().setNullsFraction(0.3333333333333333).setLowValue(13.5).setHighValue(13.5).setDistinctValuesCount(1.0).build()).build()));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("v", (Type)VarcharType.createVarcharType((int)30))), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Alice"))), (Object)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"'has'"))), (Object)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"'a cat'"))), (Object)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(4.0).addSymbolStatistics(new Symbol((Type)VarcharType.createVarcharType((int)30), "v"), SymbolStatsEstimate.builder().setNullsFraction(0.25).setDistinctValuesCount(3.0).build()).build()));
    }

    @Test
    public void testDivisionByZero() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)0L))))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.unknown()));
    }

    @Test
    public void testStatsForValuesNodeWithJustNulls() {
        PlanNodeStatsEstimate nullAStats = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).addSymbolStatistics(new Symbol((Type)DoubleType.DOUBLE, "a"), SymbolStatsEstimate.zero()).build();
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)DoubleType.DOUBLE)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null))))).check(outputStats -> outputStats.equalTo(nullAStats));
    }

    @Test
    public void testStatsForEmptyValues() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of())).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(0.0).addSymbolStatistics(new Symbol((Type)BigintType.BIGINT, "a"), SymbolStatsEstimate.zero()).build()));
    }
}

