/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.QueryStats;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.OperatorStats;
import io.trino.operator.TableWriterOperator;
import io.trino.server.DynamicFilterService;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestQueryStats {
    public static final List<OperatorStats> operatorSummaries = ImmutableList.of((Object)new OperatorStats(10, 11, 12, new PlanNodeId("13"), TableWriterOperator.class.getSimpleName(), 14L, 15L, new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)181L), 1811L, new Duration(18.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)182L), 1822L, DataSize.succinctBytes((long)18L), DataSize.succinctBytes((long)19L), 110L, 111.0, 112L, new Duration(113.0, TimeUnit.NANOSECONDS), new Duration(114.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)116L), 117L, 1833L, Metrics.EMPTY, Metrics.EMPTY, Metrics.EMPTY, DataSize.succinctBytes((long)118L), new Duration(119.0, TimeUnit.NANOSECONDS), 120L, new Duration(121.0, TimeUnit.NANOSECONDS), new Duration(122.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)124L), DataSize.succinctBytes((long)125L), DataSize.succinctBytes((long)127L), DataSize.succinctBytes((long)128L), DataSize.succinctBytes((long)130L), DataSize.succinctBytes((long)131L), Optional.empty(), null), (Object)new OperatorStats(20, 21, 22, new PlanNodeId("23"), FilterAndProjectOperator.class.getSimpleName(), 24L, 25L, new Duration(26.0, TimeUnit.NANOSECONDS), new Duration(27.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)281L), 2811L, new Duration(28.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)282L), 2822L, DataSize.succinctBytes((long)28L), DataSize.succinctBytes((long)29L), 210L, 211.0, 212L, new Duration(213.0, TimeUnit.NANOSECONDS), new Duration(214.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)216L), 217L, 2833L, Metrics.EMPTY, Metrics.EMPTY, Metrics.EMPTY, DataSize.succinctBytes((long)218L), new Duration(219.0, TimeUnit.NANOSECONDS), 220L, new Duration(221.0, TimeUnit.NANOSECONDS), new Duration(222.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)224L), DataSize.succinctBytes((long)225L), DataSize.succinctBytes((long)227L), DataSize.succinctBytes((long)228L), DataSize.succinctBytes((long)230L), DataSize.succinctBytes((long)231L), Optional.empty(), null), (Object)new OperatorStats(30, 31, 32, new PlanNodeId("33"), TableWriterOperator.class.getSimpleName(), 34L, 35L, new Duration(36.0, TimeUnit.NANOSECONDS), new Duration(37.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)381L), 3811L, new Duration(38.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)382L), 3822L, DataSize.succinctBytes((long)38L), DataSize.succinctBytes((long)39L), 310L, 311.0, 312L, new Duration(313.0, TimeUnit.NANOSECONDS), new Duration(314.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)316L), 317L, 3833L, Metrics.EMPTY, Metrics.EMPTY, Metrics.EMPTY, DataSize.succinctBytes((long)318L), new Duration(319.0, TimeUnit.NANOSECONDS), 320L, new Duration(321.0, TimeUnit.NANOSECONDS), new Duration(322.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)324L), DataSize.succinctBytes((long)325L), DataSize.succinctBytes((long)327L), DataSize.succinctBytes((long)328L), DataSize.succinctBytes((long)329L), DataSize.succinctBytes((long)331L), Optional.empty(), null));
    private static final List<QueryPlanOptimizerStatistics> optimizerRulesSummaries = ImmutableList.of((Object)new QueryPlanOptimizerStatistics("io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan", 10L, 1L, 4600L, 0L), (Object)new QueryPlanOptimizerStatistics("io.trino.sql.planner.iterative.rule.PushTopNThroughUnion", 5L, 0L, 499L, 0L));
    public static final QueryStats EXPECTED = new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(32.0, TimeUnit.NANOSECONDS), new Duration(41.0, TimeUnit.NANOSECONDS), new Duration(33.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(150.0, TimeUnit.NANOSECONDS), new Duration(200.0, TimeUnit.NANOSECONDS), 9, 10, 11, 12, 13, 14, 15, 30, 16, 17.0, 18.0, DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)21L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)23L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), DataSize.ofBytes((long)27L), true, OptionalDouble.of(8.88), OptionalDouble.of(0.0), new Duration(28.0, TimeUnit.NANOSECONDS), new Duration(29.0, TimeUnit.NANOSECONDS), new Duration(30.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(32.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)241L), DataSize.ofBytes((long)242L), 251L, 252L, new Duration(33.0, TimeUnit.NANOSECONDS), new Duration(34.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)242L), DataSize.ofBytes((long)243L), 253L, 254L, DataSize.ofBytes((long)35L), DataSize.ofBytes((long)36L), 37L, 38L, DataSize.ofBytes((long)39L), DataSize.ofBytes((long)40L), 41L, 42L, new Duration(101.0, TimeUnit.SECONDS), new Duration(102.0, TimeUnit.SECONDS), DataSize.ofBytes((long)43L), DataSize.ofBytes((long)44L), 45L, 46L, new Duration(103.0, TimeUnit.SECONDS), new Duration(104.0, TimeUnit.SECONDS), DataSize.ofBytes((long)47L), DataSize.ofBytes((long)48L), (List)ImmutableList.of((Object)new StageGcStatistics(101, 102, 103, 104, 105, 106, 107)), DynamicFilterService.DynamicFiltersStats.EMPTY, operatorSummaries, optimizerRulesSummaries);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(QueryStats.class);
        String json = codec.toJson((Object)EXPECTED);
        QueryStats actual = (QueryStats)codec.fromJson(json);
        TestQueryStats.assertExpectedQueryStats(actual);
    }

    public static void assertExpectedQueryStats(QueryStats actual) {
        Assertions.assertThat((Comparable)actual.getCreateTime()).isEqualTo((Object)new DateTime(1L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getExecutionStartTime()).isEqualTo((Object)new DateTime(2L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getLastHeartbeat()).isEqualTo((Object)new DateTime(3L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getEndTime()).isEqualTo((Object)new DateTime(4L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getElapsedTime()).isEqualTo((Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getQueuedTime()).isEqualTo((Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getResourceWaitingTime()).isEqualTo((Object)new Duration(31.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getDispatchingTime()).isEqualTo((Object)new Duration(32.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getExecutionTime()).isEqualTo((Object)new Duration(41.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getAnalysisTime()).isEqualTo((Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPlanningTime()).isEqualTo((Object)new Duration(100.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPlanningCpuTime()).isEqualTo((Object)new Duration(150.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFinishingTime()).isEqualTo((Object)new Duration(200.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((int)actual.getTotalTasks()).isEqualTo(9);
        Assertions.assertThat((int)actual.getRunningTasks()).isEqualTo(10);
        Assertions.assertThat((int)actual.getCompletedTasks()).isEqualTo(11);
        Assertions.assertThat((int)actual.getFailedTasks()).isEqualTo(12);
        Assertions.assertThat((int)actual.getTotalDrivers()).isEqualTo(13);
        Assertions.assertThat((int)actual.getQueuedDrivers()).isEqualTo(14);
        Assertions.assertThat((int)actual.getRunningDrivers()).isEqualTo(15);
        Assertions.assertThat((int)actual.getBlockedDrivers()).isEqualTo(30);
        Assertions.assertThat((int)actual.getCompletedDrivers()).isEqualTo(16);
        Assertions.assertThat((double)actual.getCumulativeUserMemory()).isEqualTo(17.0);
        Assertions.assertThat((double)actual.getFailedCumulativeUserMemory()).isEqualTo(18.0);
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)19L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)20L));
        Assertions.assertThat((Comparable)actual.getTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)21L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)22L));
        Assertions.assertThat((Comparable)actual.getPeakRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)23L));
        Assertions.assertThat((Comparable)actual.getPeakTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)24L));
        Assertions.assertThat((Comparable)actual.getPeakTaskUserMemory()).isEqualTo((Object)DataSize.ofBytes((long)25L));
        Assertions.assertThat((Comparable)actual.getPeakTaskRevocableMemory()).isEqualTo((Object)DataSize.ofBytes((long)26L));
        Assertions.assertThat((Comparable)actual.getPeakTaskTotalMemory()).isEqualTo((Object)DataSize.ofBytes((long)27L));
        Assertions.assertThat((Comparable)actual.getSpilledDataSize()).isEqualTo((Object)DataSize.ofBytes((long)693L));
        Assertions.assertThat((Comparable)actual.getTotalScheduledTime()).isEqualTo((Object)new Duration(28.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedScheduledTime()).isEqualTo((Object)new Duration(29.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalCpuTime()).isEqualTo((Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedCpuTime()).isEqualTo((Object)new Duration(31.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalBlockedTime()).isEqualTo((Object)new Duration(32.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)241L));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)242L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(251L);
        Assertions.assertThat((long)actual.getFailedPhysicalInputPositions()).isEqualTo(252L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalInputReadTime()).isEqualTo((Object)new Duration(34.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)242L));
        Assertions.assertThat((Comparable)actual.getFailedInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)243L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(253L);
        Assertions.assertThat((long)actual.getFailedInternalNetworkInputPositions()).isEqualTo(254L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)35L));
        Assertions.assertThat((Comparable)actual.getFailedRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)36L));
        Assertions.assertThat((long)actual.getRawInputPositions()).isEqualTo(37L);
        Assertions.assertThat((long)actual.getFailedRawInputPositions()).isEqualTo(38L);
        Assertions.assertThat((Comparable)actual.getProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)39L));
        Assertions.assertThat((Comparable)actual.getFailedProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)40L));
        Assertions.assertThat((long)actual.getProcessedInputPositions()).isEqualTo(41L);
        Assertions.assertThat((long)actual.getFailedProcessedInputPositions()).isEqualTo(42L);
        Assertions.assertThat((Comparable)actual.getInputBlockedTime()).isEqualTo((Object)new Duration(101.0, TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)actual.getFailedInputBlockedTime()).isEqualTo((Object)new Duration(102.0, TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)43L));
        Assertions.assertThat((Comparable)actual.getFailedOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)44L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(45L);
        Assertions.assertThat((long)actual.getFailedOutputPositions()).isEqualTo(46L);
        Assertions.assertThat((Comparable)actual.getOutputBlockedTime()).isEqualTo((Object)new Duration(103.0, TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)actual.getFailedOutputBlockedTime()).isEqualTo((Object)new Duration(104.0, TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)47L));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)48L));
        Assertions.assertThat((int)actual.getStageGcStatistics().size()).isEqualTo(1);
        StageGcStatistics gcStatistics = (StageGcStatistics)actual.getStageGcStatistics().get(0);
        Assertions.assertThat((int)gcStatistics.getStageId()).isEqualTo(101);
        Assertions.assertThat((int)gcStatistics.getTasks()).isEqualTo(102);
        Assertions.assertThat((int)gcStatistics.getFullGcTasks()).isEqualTo(103);
        Assertions.assertThat((int)gcStatistics.getMinFullGcSec()).isEqualTo(104);
        Assertions.assertThat((int)gcStatistics.getMaxFullGcSec()).isEqualTo(105);
        Assertions.assertThat((int)gcStatistics.getTotalFullGcSec()).isEqualTo(106);
        Assertions.assertThat((int)gcStatistics.getAverageFullGcSec()).isEqualTo(107);
        Assertions.assertThat((int)420).isEqualTo(actual.getWrittenPositions());
        Assertions.assertThat((int)58).isEqualTo(actual.getLogicalWrittenDataSize().toBytes());
        Assertions.assertThat((Object)DynamicFilterService.DynamicFiltersStats.EMPTY).isEqualTo((Object)actual.getDynamicFiltersStats());
        Assertions.assertThat((int)actual.getOptimizerRulesSummaries().size()).isEqualTo(optimizerRulesSummaries.size());
        int end = optimizerRulesSummaries.size();
        for (int i = 0; i < end; ++i) {
            QueryPlanOptimizerStatistics actualRule = (QueryPlanOptimizerStatistics)actual.getOptimizerRulesSummaries().get(i);
            QueryPlanOptimizerStatistics expectedRule = optimizerRulesSummaries.get(i);
            Assertions.assertThat((String)actualRule.rule()).isEqualTo(expectedRule.rule());
            Assertions.assertThat((long)actualRule.applied()).isEqualTo(expectedRule.applied());
            Assertions.assertThat((long)actualRule.totalTime()).isEqualTo(expectedRule.totalTime());
            Assertions.assertThat((long)actualRule.invocations()).isEqualTo(expectedRule.invocations());
            Assertions.assertThat((long)actualRule.failures()).isEqualTo(expectedRule.failures());
        }
    }
}

