/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import io.trino.execution.resourcegroups.StochasticPriorityQueue;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStochasticPriorityQueue {
    @Test
    public void testContainsAndRemove() {
        int i;
        StochasticPriorityQueue queue = new StochasticPriorityQueue();
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)("test" + i), (long)(i + 1))).isTrue();
        }
        for (i = 0; i < 100; i += 2) {
            Assertions.assertThat((boolean)queue.remove((Object)("test" + i))).isTrue();
        }
        for (i = 1; i < 100; i += 2) {
            Assertions.assertThat((boolean)queue.contains((Object)("test" + i))).isTrue();
        }
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        Assertions.assertThat((int)queue.size()).isEqualTo(50);
        for (i = 1; i < 100; i += 2) {
            Assertions.assertThat((boolean)queue.remove((Object)("test" + i))).isTrue();
        }
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
        Assertions.assertThat((int)queue.size()).isEqualTo(0);
    }

    @Test
    public void testPollDistribution() {
        int i;
        int i2;
        StochasticPriorityQueue queue = new StochasticPriorityQueue();
        for (i2 = 0; i2 < 100; ++i2) {
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)("foo" + i2), 1L)).isTrue();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)("bar" + i2), 1L)).isTrue();
        }
        int foo = 0;
        for (int i3 = 0; i3 < 1000; ++i3) {
            String value = (String)queue.poll();
            if (value.startsWith("foo")) {
                ++foo;
            }
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)value, 1L)).isTrue();
        }
        BinomialDistribution binomial = new BinomialDistribution(1000, 0.5);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        io.airlift.testing.Assertions.assertLessThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(upperBound));
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(lowerBound));
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)("foo" + i), 2L)).isFalse();
        }
        foo = 0;
        for (i = 0; i < 1000; ++i) {
            String value = (String)queue.poll();
            if (value.startsWith("foo")) {
                ++foo;
                Assertions.assertThat((boolean)queue.addOrUpdate((Object)value, 2L)).isTrue();
                continue;
            }
            Assertions.assertThat((boolean)queue.addOrUpdate((Object)value, 1L)).isTrue();
        }
        binomial = new BinomialDistribution(1000, 0.6666666666666666);
        lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        upperBound = binomial.inverseCumulativeProbability(0.999999);
        io.airlift.testing.Assertions.assertLessThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(upperBound));
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(lowerBound));
    }
}

