/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureDeserializer;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSignature {
    @Test
    public void testSerializationRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER), TypeSignature.class, (Object)new TypeSignatureDeserializer()));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider, true).jsonCodec(Signature.class);
        Signature expected = Signature.builder().returnType((Type)BigintType.BIGINT).argumentType((Type)BooleanType.BOOLEAN).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)VarcharType.VARCHAR).build();
        String json = codec.toJson((Object)expected);
        Signature actual = (Signature)codec.fromJson(json);
        Assertions.assertThat((Object)actual.getReturnType()).isEqualTo((Object)expected.getReturnType());
        Assertions.assertThat((List)actual.getArgumentTypes()).isEqualTo((Object)expected.getArgumentTypes());
    }
}

